"""add project bugdet table

Revision ID: 83e2f33a9b14
Revises: 45f739ef962a
Create Date: 2025-04-09 20:17:08.331320

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "83e2f33a9b14"
down_revision = "45f739ef962a"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "budget",
        sa.Column(
            "project_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("revision", sa.Integer(), nullable=False),
        sa.Column("name", sa.String(length=255), nullable=False),
        sa.Column(
            "id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=False,
        ),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.Column("updated_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    with op.batch_alter_table("budget", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_budget_project_id"), ["project_id"], unique=False
        )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("budget", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_budget_project_id"))

    op.drop_table("budget")
    # ### end Alembic commands ###
