import click
from rich import print

import coiled

from .utils import CONTEXT_SETTINGS


@click.command(
    context_settings=CONTEXT_SETTINGS,
    help="CLI to hit endpoints using Coiled account authentication (mostly for internal use)",
)
@click.argument("url")
@click.option("-X", "--request", default="GET")
@click.option("-d", "--data", multiple=True)
@click.option("--json", is_flag=True, default=False)
def curl(url: str, request, data, json):
    all_data = "&".join(data) if data else None
    with coiled.Cloud() as cloud:
        if "http" not in url:
            url = f"{cloud.server}{url}"

        response = sync_request(cloud, url, method=request, data=all_data, json=json)

    print(response)


def sync_request(cloud, url, method, data, json: bool = False):
    response = cloud._sync(
        cloud._do_request,
        method=method,
        url=url,
        data=data,
    )
    if response.status >= 400:
        print(f"{url} returned {response.status}")

    async def get_result(r):
        return await (r.json() if json else r.text())

    return cloud._sync(
        get_result,
        response,
    )
