# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AclRolePolicyAttachmentArgs', 'AclRolePolicyAttachment']

@pulumi.input_type
class AclRolePolicyAttachmentArgs:
    def __init__(__self__, *,
                 policy: pulumi.Input[_builtins.str],
                 role_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AclRolePolicyAttachment resource.
        :param pulumi.Input[_builtins.str] policy: The policy name.
        :param pulumi.Input[_builtins.str] role_id: The id of the role.
        """
        pulumi.set(__self__, "policy", policy)
        pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Input[_builtins.str]:
        """
        The policy name.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role_id", value)


@pulumi.input_type
class _AclRolePolicyAttachmentState:
    def __init__(__self__, *,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AclRolePolicyAttachment resources.
        :param pulumi.Input[_builtins.str] policy: The policy name.
        :param pulumi.Input[_builtins.str] role_id: The id of the role.
        """
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if role_id is not None:
            pulumi.set(__self__, "role_id", role_id)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The policy name.
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy", value)

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the role.
        """
        return pulumi.get(self, "role_id")

    @role_id.setter
    def role_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_id", value)


@pulumi.type_token("consul:index/aclRolePolicyAttachment:AclRolePolicyAttachment")
class AclRolePolicyAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        my_role = consul.get_acl_role(name="my_role")
        read_policy = consul.AclPolicy("read_policy",
            name="read-policy",
            rules="node \\"\\" { policy = \\"read\\" }",
            datacenters=["dc1"])
        my_role_read_policy = consul.AclRolePolicyAttachment("my_role_read_policy",
            role_id=test["id"],
            policy=read_policy.name)
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/aclRolePolicyAttachment:AclRolePolicyAttachment my_role_read_policy 624d94ca-bc5c-f960-4e83-0a609cf588be:policy_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy: The policy name.
        :param pulumi.Input[_builtins.str] role_id: The id of the role.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclRolePolicyAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        my_role = consul.get_acl_role(name="my_role")
        read_policy = consul.AclPolicy("read_policy",
            name="read-policy",
            rules="node \\"\\" { policy = \\"read\\" }",
            datacenters=["dc1"])
        my_role_read_policy = consul.AclRolePolicyAttachment("my_role_read_policy",
            role_id=test["id"],
            policy=read_policy.name)
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/aclRolePolicyAttachment:AclRolePolicyAttachment my_role_read_policy 624d94ca-bc5c-f960-4e83-0a609cf588be:policy_name
        ```

        :param str resource_name: The name of the resource.
        :param AclRolePolicyAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclRolePolicyAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy: Optional[pulumi.Input[_builtins.str]] = None,
                 role_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclRolePolicyAttachmentArgs.__new__(AclRolePolicyAttachmentArgs)

            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            if role_id is None and not opts.urn:
                raise TypeError("Missing required property 'role_id'")
            __props__.__dict__["role_id"] = role_id
        super(AclRolePolicyAttachment, __self__).__init__(
            'consul:index/aclRolePolicyAttachment:AclRolePolicyAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy: Optional[pulumi.Input[_builtins.str]] = None,
            role_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AclRolePolicyAttachment':
        """
        Get an existing AclRolePolicyAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy: The policy name.
        :param pulumi.Input[_builtins.str] role_id: The id of the role.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclRolePolicyAttachmentState.__new__(_AclRolePolicyAttachmentState)

        __props__.__dict__["policy"] = policy
        __props__.__dict__["role_id"] = role_id
        return AclRolePolicyAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def policy(self) -> pulumi.Output[_builtins.str]:
        """
        The policy name.
        """
        return pulumi.get(self, "policy")

    @_builtins.property
    @pulumi.getter(name="roleId")
    def role_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the role.
        """
        return pulumi.get(self, "role_id")

