# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AclTokenRoleAttachmentArgs', 'AclTokenRoleAttachment']

@pulumi.input_type
class AclTokenRoleAttachmentArgs:
    def __init__(__self__, *,
                 role: pulumi.Input[_builtins.str],
                 token_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AclTokenRoleAttachment resource.
        :param pulumi.Input[_builtins.str] role: The role name.
        :param pulumi.Input[_builtins.str] token_id: The id of the token.
        """
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "token_id", token_id)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Input[_builtins.str]:
        """
        The role name.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Input[_builtins.str]:
        """
        The id of the token.
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "token_id", value)


@pulumi.input_type
class _AclTokenRoleAttachmentState:
    def __init__(__self__, *,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 token_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AclTokenRoleAttachment resources.
        :param pulumi.Input[_builtins.str] role: The role name.
        :param pulumi.Input[_builtins.str] token_id: The id of the token.
        """
        if role is not None:
            pulumi.set(__self__, "role", role)
        if token_id is not None:
            pulumi.set(__self__, "token_id", token_id)

    @_builtins.property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The role name.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role", value)

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The id of the token.
        """
        return pulumi.get(self, "token_id")

    @token_id.setter
    def token_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "token_id", value)


@pulumi.type_token("consul:index/aclTokenRoleAttachment:AclTokenRoleAttachment")
class AclTokenRoleAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        `consul_acl_token_role_attachment` can be imported. This is especially useful to manage the
        policies attached to the anonymous and the master tokens with Terraform:

        ```sh
        $ pulumi import consul:index/aclTokenRoleAttachment:AclTokenRoleAttachment anonymous token_id:role_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] role: The role name.
        :param pulumi.Input[_builtins.str] token_id: The id of the token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclTokenRoleAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        `consul_acl_token_role_attachment` can be imported. This is especially useful to manage the
        policies attached to the anonymous and the master tokens with Terraform:

        ```sh
        $ pulumi import consul:index/aclTokenRoleAttachment:AclTokenRoleAttachment anonymous token_id:role_id
        ```

        :param str resource_name: The name of the resource.
        :param AclTokenRoleAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclTokenRoleAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 role: Optional[pulumi.Input[_builtins.str]] = None,
                 token_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclTokenRoleAttachmentArgs.__new__(AclTokenRoleAttachmentArgs)

            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if token_id is None and not opts.urn:
                raise TypeError("Missing required property 'token_id'")
            __props__.__dict__["token_id"] = token_id
        super(AclTokenRoleAttachment, __self__).__init__(
            'consul:index/aclTokenRoleAttachment:AclTokenRoleAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            role: Optional[pulumi.Input[_builtins.str]] = None,
            token_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AclTokenRoleAttachment':
        """
        Get an existing AclTokenRoleAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] role: The role name.
        :param pulumi.Input[_builtins.str] token_id: The id of the token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclTokenRoleAttachmentState.__new__(_AclTokenRoleAttachmentState)

        __props__.__dict__["role"] = role
        __props__.__dict__["token_id"] = token_id
        return AclTokenRoleAttachment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def role(self) -> pulumi.Output[_builtins.str]:
        """
        The role name.
        """
        return pulumi.get(self, "role")

    @_builtins.property
    @pulumi.getter(name="tokenId")
    def token_id(self) -> pulumi.Output[_builtins.str]:
        """
        The id of the token.
        """
        return pulumi.get(self, "token_id")

