# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetAclPolicyResult',
    'AwaitableGetAclPolicyResult',
    'get_acl_policy',
    'get_acl_policy_output',
]

@pulumi.output_type
class GetAclPolicyResult:
    """
    A collection of values returned by getAclPolicy.
    """
    def __init__(__self__, datacenters=None, description=None, id=None, name=None, namespace=None, partition=None, rules=None):
        if datacenters and not isinstance(datacenters, list):
            raise TypeError("Expected argument 'datacenters' to be a list")
        pulumi.set(__self__, "datacenters", datacenters)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)
        if rules and not isinstance(rules, str):
            raise TypeError("Expected argument 'rules' to be a str")
        pulumi.set(__self__, "rules", rules)

    @_builtins.property
    @pulumi.getter
    def datacenters(self) -> Sequence[_builtins.str]:
        """
        The datacenters associated with the ACL Policy.
        """
        return pulumi.get(self, "datacenters")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the ACL Policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter
    def rules(self) -> _builtins.str:
        """
        The rules associated with the ACL Policy.
        """
        return pulumi.get(self, "rules")


class AwaitableGetAclPolicyResult(GetAclPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAclPolicyResult(
            datacenters=self.datacenters,
            description=self.description,
            id=self.id,
            name=self.name,
            namespace=self.namespace,
            partition=self.partition,
            rules=self.rules)


def get_acl_policy(name: Optional[_builtins.str] = None,
                   namespace: Optional[_builtins.str] = None,
                   partition: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAclPolicyResult:
    """
    The `AclPolicy` data source returns the information related to a
    [Consul ACL Policy](https://www.consul.io/docs/acl/acl-system.html#acl-policies).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    agent = consul.get_acl_policy(name="agent")
    pulumi.export("consulAclPolicy", agent.rules)
    ```


    :param _builtins.str name: The name of the ACL Policy.
    :param _builtins.str namespace: The namespace to lookup the policy.
    :param _builtins.str partition: The partition to lookup the policy.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['partition'] = partition
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getAclPolicy:getAclPolicy', __args__, opts=opts, typ=GetAclPolicyResult).value

    return AwaitableGetAclPolicyResult(
        datacenters=pulumi.get(__ret__, 'datacenters'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        partition=pulumi.get(__ret__, 'partition'),
        rules=pulumi.get(__ret__, 'rules'))
def get_acl_policy_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                          namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          partition: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAclPolicyResult]:
    """
    The `AclPolicy` data source returns the information related to a
    [Consul ACL Policy](https://www.consul.io/docs/acl/acl-system.html#acl-policies).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    agent = consul.get_acl_policy(name="agent")
    pulumi.export("consulAclPolicy", agent.rules)
    ```


    :param _builtins.str name: The name of the ACL Policy.
    :param _builtins.str namespace: The namespace to lookup the policy.
    :param _builtins.str partition: The partition to lookup the policy.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['partition'] = partition
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('consul:index/getAclPolicy:getAclPolicy', __args__, opts=opts, typ=GetAclPolicyResult)
    return __ret__.apply(lambda __response__: GetAclPolicyResult(
        datacenters=pulumi.get(__response__, 'datacenters'),
        description=pulumi.get(__response__, 'description'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        namespace=pulumi.get(__response__, 'namespace'),
        partition=pulumi.get(__response__, 'partition'),
        rules=pulumi.get(__response__, 'rules')))
