# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetKeyPrefixResult',
    'AwaitableGetKeyPrefixResult',
    'get_key_prefix',
    'get_key_prefix_output',
]

@pulumi.output_type
class GetKeyPrefixResult:
    """
    A collection of values returned by getKeyPrefix.
    """
    def __init__(__self__, datacenter=None, id=None, namespace=None, partition=None, path_prefix=None, subkey_collection=None, subkeys=None, token=None, var=None):
        if datacenter and not isinstance(datacenter, str):
            raise TypeError("Expected argument 'datacenter' to be a str")
        pulumi.set(__self__, "datacenter", datacenter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)
        if path_prefix and not isinstance(path_prefix, str):
            raise TypeError("Expected argument 'path_prefix' to be a str")
        pulumi.set(__self__, "path_prefix", path_prefix)
        if subkey_collection and not isinstance(subkey_collection, list):
            raise TypeError("Expected argument 'subkey_collection' to be a list")
        pulumi.set(__self__, "subkey_collection", subkey_collection)
        if subkeys and not isinstance(subkeys, dict):
            raise TypeError("Expected argument 'subkeys' to be a dict")
        pulumi.set(__self__, "subkeys", subkeys)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)
        if var and not isinstance(var, dict):
            raise TypeError("Expected argument 'var' to be a dict")
        pulumi.set(__self__, "var", var)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> _builtins.str:
        """
        The datacenter the keys are being read from.
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter(name="pathPrefix")
    def path_prefix(self) -> _builtins.str:
        """
        the common prefix shared by all keys being read.
        * `var.<name>` - For each name given, the corresponding attribute
        has the value of the key.
        """
        return pulumi.get(self, "path_prefix")

    @_builtins.property
    @pulumi.getter(name="subkeyCollection")
    def subkey_collection(self) -> Optional[Sequence['outputs.GetKeyPrefixSubkeyCollectionResult']]:
        return pulumi.get(self, "subkey_collection")

    @_builtins.property
    @pulumi.getter
    def subkeys(self) -> Mapping[str, _builtins.str]:
        """
        A map of the subkeys and values is set if no `subkey`
        block is provided.
        """
        return pulumi.get(self, "subkeys")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
    def token(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "token")

    @_builtins.property
    @pulumi.getter
    def var(self) -> Mapping[str, _builtins.str]:
        return pulumi.get(self, "var")


class AwaitableGetKeyPrefixResult(GetKeyPrefixResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyPrefixResult(
            datacenter=self.datacenter,
            id=self.id,
            namespace=self.namespace,
            partition=self.partition,
            path_prefix=self.path_prefix,
            subkey_collection=self.subkey_collection,
            subkeys=self.subkeys,
            token=self.token,
            var=self.var)


def get_key_prefix(datacenter: Optional[_builtins.str] = None,
                   namespace: Optional[_builtins.str] = None,
                   partition: Optional[_builtins.str] = None,
                   path_prefix: Optional[_builtins.str] = None,
                   subkey_collection: Optional[Sequence[Union['GetKeyPrefixSubkeyCollectionArgs', 'GetKeyPrefixSubkeyCollectionArgsDict']]] = None,
                   token: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyPrefixResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_consul as consul

    app = consul.get_key_prefix(datacenter="nyc1",
        token="abcd",
        path_prefix="myapp/config/",
        subkey_collection=[{
            "name": "ami",
            "path": "app/launch_ami",
            "default": "ami-1234",
        }])
    # Start our instance with the dynamic ami value
    app_instance = aws.index.Instance("app", ami=app.var.ami)
    ```

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_consul as consul

    web = consul.get_key_prefix(datacenter="nyc1",
        token="efgh",
        path_prefix="myapp/config/")
    # Start our instance with the dynamic ami value
    web_instance = aws.index.Instance("web", ami=web.subkeys.app_launch_ami)
    ```


    :param _builtins.str datacenter: The datacenter to use. This overrides the
           agent's default datacenter and the datacenter in the provider setup.
    :param _builtins.str namespace: The namespace to lookup the keys within.
    :param _builtins.str partition: The namespace to lookup the keys within.
    :param _builtins.str path_prefix: Specifies the common prefix shared by all keys
           that will be read by this data source instance. In most cases, this will
           end with a slash to read a "folder" of subkeys.
    :param Sequence[Union['GetKeyPrefixSubkeyCollectionArgs', 'GetKeyPrefixSubkeyCollectionArgsDict']] subkey_collection: Specifies a subkey in Consul to be read. Supported
           values documented below. Multiple blocks supported.
    :param _builtins.str token: The ACL token to use. This overrides the
           token that the agent provides by default.
    """
    __args__ = dict()
    __args__['datacenter'] = datacenter
    __args__['namespace'] = namespace
    __args__['partition'] = partition
    __args__['pathPrefix'] = path_prefix
    __args__['subkeyCollection'] = subkey_collection
    __args__['token'] = token
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getKeyPrefix:getKeyPrefix', __args__, opts=opts, typ=GetKeyPrefixResult).value

    return AwaitableGetKeyPrefixResult(
        datacenter=pulumi.get(__ret__, 'datacenter'),
        id=pulumi.get(__ret__, 'id'),
        namespace=pulumi.get(__ret__, 'namespace'),
        partition=pulumi.get(__ret__, 'partition'),
        path_prefix=pulumi.get(__ret__, 'path_prefix'),
        subkey_collection=pulumi.get(__ret__, 'subkey_collection'),
        subkeys=pulumi.get(__ret__, 'subkeys'),
        token=pulumi.get(__ret__, 'token'),
        var=pulumi.get(__ret__, 'var'))
def get_key_prefix_output(datacenter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          namespace: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          partition: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          path_prefix: Optional[pulumi.Input[_builtins.str]] = None,
                          subkey_collection: Optional[pulumi.Input[Optional[Sequence[Union['GetKeyPrefixSubkeyCollectionArgs', 'GetKeyPrefixSubkeyCollectionArgsDict']]]]] = None,
                          token: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyPrefixResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_consul as consul

    app = consul.get_key_prefix(datacenter="nyc1",
        token="abcd",
        path_prefix="myapp/config/",
        subkey_collection=[{
            "name": "ami",
            "path": "app/launch_ami",
            "default": "ami-1234",
        }])
    # Start our instance with the dynamic ami value
    app_instance = aws.index.Instance("app", ami=app.var.ami)
    ```

    ```python
    import pulumi
    import pulumi_aws as aws
    import pulumi_consul as consul

    web = consul.get_key_prefix(datacenter="nyc1",
        token="efgh",
        path_prefix="myapp/config/")
    # Start our instance with the dynamic ami value
    web_instance = aws.index.Instance("web", ami=web.subkeys.app_launch_ami)
    ```


    :param _builtins.str datacenter: The datacenter to use. This overrides the
           agent's default datacenter and the datacenter in the provider setup.
    :param _builtins.str namespace: The namespace to lookup the keys within.
    :param _builtins.str partition: The namespace to lookup the keys within.
    :param _builtins.str path_prefix: Specifies the common prefix shared by all keys
           that will be read by this data source instance. In most cases, this will
           end with a slash to read a "folder" of subkeys.
    :param Sequence[Union['GetKeyPrefixSubkeyCollectionArgs', 'GetKeyPrefixSubkeyCollectionArgsDict']] subkey_collection: Specifies a subkey in Consul to be read. Supported
           values documented below. Multiple blocks supported.
    :param _builtins.str token: The ACL token to use. This overrides the
           token that the agent provides by default.
    """
    __args__ = dict()
    __args__['datacenter'] = datacenter
    __args__['namespace'] = namespace
    __args__['partition'] = partition
    __args__['pathPrefix'] = path_prefix
    __args__['subkeyCollection'] = subkey_collection
    __args__['token'] = token
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('consul:index/getKeyPrefix:getKeyPrefix', __args__, opts=opts, typ=GetKeyPrefixResult)
    return __ret__.apply(lambda __response__: GetKeyPrefixResult(
        datacenter=pulumi.get(__response__, 'datacenter'),
        id=pulumi.get(__response__, 'id'),
        namespace=pulumi.get(__response__, 'namespace'),
        partition=pulumi.get(__response__, 'partition'),
        path_prefix=pulumi.get(__response__, 'path_prefix'),
        subkey_collection=pulumi.get(__response__, 'subkey_collection'),
        subkeys=pulumi.get(__response__, 'subkeys'),
        token=pulumi.get(__response__, 'token'),
        var=pulumi.get(__response__, 'var')))
