# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[_builtins.str] description: Free form namespace description.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies arbitrary KV metadata to associate with the namespace.
        :param pulumi.Input[_builtins.str] name: The namespace name.
        :param pulumi.Input[_builtins.str] partition: The partition to create the namespace within.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_defaults: The list of default policies that should be applied to all tokens created in this namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_defaults: The list of default roles that should be applied to all tokens created in this namespace.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policy_defaults is not None:
            pulumi.set(__self__, "policy_defaults", policy_defaults)
        if role_defaults is not None:
            pulumi.set(__self__, "role_defaults", role_defaults)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Free form namespace description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies arbitrary KV metadata to associate with the namespace.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partition to create the namespace within.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter(name="policyDefaults")
    def policy_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of default policies that should be applied to all tokens created in this namespace.
        """
        return pulumi.get(self, "policy_defaults")

    @policy_defaults.setter
    def policy_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_defaults", value)

    @_builtins.property
    @pulumi.getter(name="roleDefaults")
    def role_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of default roles that should be applied to all tokens created in this namespace.
        """
        return pulumi.get(self, "role_defaults")

    @role_defaults.setter
    def role_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "role_defaults", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input[_builtins.str] description: Free form namespace description.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies arbitrary KV metadata to associate with the namespace.
        :param pulumi.Input[_builtins.str] name: The namespace name.
        :param pulumi.Input[_builtins.str] partition: The partition to create the namespace within.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_defaults: The list of default policies that should be applied to all tokens created in this namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_defaults: The list of default roles that should be applied to all tokens created in this namespace.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if policy_defaults is not None:
            pulumi.set(__self__, "policy_defaults", policy_defaults)
        if role_defaults is not None:
            pulumi.set(__self__, "role_defaults", role_defaults)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Free form namespace description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies arbitrary KV metadata to associate with the namespace.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The namespace name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The partition to create the namespace within.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter(name="policyDefaults")
    def policy_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of default policies that should be applied to all tokens created in this namespace.
        """
        return pulumi.get(self, "policy_defaults")

    @policy_defaults.setter
    def policy_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "policy_defaults", value)

    @_builtins.property
    @pulumi.getter(name="roleDefaults")
    def role_defaults(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of default roles that should be applied to all tokens created in this namespace.
        """
        return pulumi.get(self, "role_defaults")

    @role_defaults.setter
    def role_defaults(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "role_defaults", value)


@pulumi.type_token("consul:index/namespace:Namespace")
class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        > **NOTE:** This feature requires Consul Enterprise.

        The `Namespace` resource provides isolated [Consul Enterprise Namespaces](https://www.consul.io/docs/enterprise/namespaces/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        production = consul.Namespace("production",
            name="production",
            description="Production namespace",
            meta={
                "foo": "bar",
            })
        ```

        ## Import

        `consul_namespace` can be imported. This is useful to manage attributes of the
        default namespace that is created automatically:

        ```sh
        $ pulumi import consul:index/namespace:Namespace default default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Free form namespace description.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies arbitrary KV metadata to associate with the namespace.
        :param pulumi.Input[_builtins.str] name: The namespace name.
        :param pulumi.Input[_builtins.str] partition: The partition to create the namespace within.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_defaults: The list of default policies that should be applied to all tokens created in this namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_defaults: The list of default roles that should be applied to all tokens created in this namespace.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[NamespaceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **NOTE:** This feature requires Consul Enterprise.

        The `Namespace` resource provides isolated [Consul Enterprise Namespaces](https://www.consul.io/docs/enterprise/namespaces/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        production = consul.Namespace("production",
            name="production",
            description="Production namespace",
            meta={
                "foo": "bar",
            })
        ```

        ## Import

        `consul_namespace` can be imported. This is useful to manage attributes of the
        default namespace that is created automatically:

        ```sh
        $ pulumi import consul:index/namespace:Namespace default default
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 policy_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 role_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["meta"] = meta
            __props__.__dict__["name"] = name
            __props__.__dict__["partition"] = partition
            __props__.__dict__["policy_defaults"] = policy_defaults
            __props__.__dict__["role_defaults"] = role_defaults
        super(Namespace, __self__).__init__(
            'consul:index/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            policy_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            role_defaults: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Free form namespace description.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies arbitrary KV metadata to associate with the namespace.
        :param pulumi.Input[_builtins.str] name: The namespace name.
        :param pulumi.Input[_builtins.str] partition: The partition to create the namespace within.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] policy_defaults: The list of default policies that should be applied to all tokens created in this namespace.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] role_defaults: The list of default roles that should be applied to all tokens created in this namespace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["description"] = description
        __props__.__dict__["meta"] = meta
        __props__.__dict__["name"] = name
        __props__.__dict__["partition"] = partition
        __props__.__dict__["policy_defaults"] = policy_defaults
        __props__.__dict__["role_defaults"] = role_defaults
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Free form namespace description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies arbitrary KV metadata to associate with the namespace.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The namespace name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The partition to create the namespace within.
        """
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter(name="policyDefaults")
    def policy_defaults(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of default policies that should be applied to all tokens created in this namespace.
        """
        return pulumi.get(self, "policy_defaults")

    @_builtins.property
    @pulumi.getter(name="roleDefaults")
    def role_defaults(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of default roles that should be applied to all tokens created in this namespace.
        """
        return pulumi.get(self, "role_defaults")

