# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['PeeringTokenArgs', 'PeeringToken']

@pulumi.input_type
class PeeringTokenArgs:
    def __init__(__self__, *,
                 peer_name: pulumi.Input[_builtins.str],
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 server_external_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a PeeringToken resource.
        :param pulumi.Input[_builtins.str] peer_name: The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_external_addresses: The addresses for the cluster that generates the peering token. Addresses take the form {host or IP}:port. You can specify one or more load balancers or external IPs that route external traffic to this cluster's Consul servers.
        """
        pulumi.set(__self__, "peer_name", peer_name)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if server_external_addresses is not None:
            pulumi.set(__self__, "server_external_addresses", server_external_addresses)

    @_builtins.property
    @pulumi.getter(name="peerName")
    def peer_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        """
        return pulumi.get(self, "peer_name")

    @peer_name.setter
    def peer_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "peer_name", value)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter(name="serverExternalAddresses")
    def server_external_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The addresses for the cluster that generates the peering token. Addresses take the form {host or IP}:port. You can specify one or more load balancers or external IPs that route external traffic to this cluster's Consul servers.
        """
        return pulumi.get(self, "server_external_addresses")

    @server_external_addresses.setter
    def server_external_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "server_external_addresses", value)


@pulumi.input_type
class _PeeringTokenState:
    def __init__(__self__, *,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 peering_token: Optional[pulumi.Input[_builtins.str]] = None,
                 server_external_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering PeeringToken resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        :param pulumi.Input[_builtins.str] peer_name: The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        :param pulumi.Input[_builtins.str] peering_token: The generated peering token
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_external_addresses: The addresses for the cluster that generates the peering token. Addresses take the form {host or IP}:port. You can specify one or more load balancers or external IPs that route external traffic to this cluster's Consul servers.
        """
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if peer_name is not None:
            pulumi.set(__self__, "peer_name", peer_name)
        if peering_token is not None:
            pulumi.set(__self__, "peering_token", peering_token)
        if server_external_addresses is not None:
            pulumi.set(__self__, "server_external_addresses", server_external_addresses)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "meta", value)

    @_builtins.property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "partition", value)

    @_builtins.property
    @pulumi.getter(name="peerName")
    def peer_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        """
        return pulumi.get(self, "peer_name")

    @peer_name.setter
    def peer_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peer_name", value)

    @_builtins.property
    @pulumi.getter(name="peeringToken")
    def peering_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated peering token
        """
        return pulumi.get(self, "peering_token")

    @peering_token.setter
    def peering_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "peering_token", value)

    @_builtins.property
    @pulumi.getter(name="serverExternalAddresses")
    def server_external_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The addresses for the cluster that generates the peering token. Addresses take the form {host or IP}:port. You can specify one or more load balancers or external IPs that route external traffic to this cluster's Consul servers.
        """
        return pulumi.get(self, "server_external_addresses")

    @server_external_addresses.setter
    def server_external_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "server_external_addresses", value)


@pulumi.type_token("consul:index/peeringToken:PeeringToken")
class PeeringToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_external_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        [Cluster Peering](https://www.consul.io/docs/connect/cluster-peering) can be used to create connections between two or more independent clusters so that services deployed to different partitions or datacenters can communicate.

        The `cluster_peering_token` resource can be used to generate a peering token that can later be used to establish a peering connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        token = consul.PeeringToken("token", peer_name="eu-cluster")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        :param pulumi.Input[_builtins.str] peer_name: The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_external_addresses: The addresses for the cluster that generates the peering token. Addresses take the form {host or IP}:port. You can specify one or more load balancers or external IPs that route external traffic to this cluster's Consul servers.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PeeringTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        [Cluster Peering](https://www.consul.io/docs/connect/cluster-peering) can be used to create connections between two or more independent clusters so that services deployed to different partitions or datacenters can communicate.

        The `cluster_peering_token` resource can be used to generate a peering token that can later be used to establish a peering connection.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        token = consul.PeeringToken("token", peer_name="eu-cluster")
        ```

        :param str resource_name: The name of the resource.
        :param PeeringTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PeeringTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 partition: Optional[pulumi.Input[_builtins.str]] = None,
                 peer_name: Optional[pulumi.Input[_builtins.str]] = None,
                 server_external_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PeeringTokenArgs.__new__(PeeringTokenArgs)

            __props__.__dict__["meta"] = meta
            __props__.__dict__["partition"] = partition
            if peer_name is None and not opts.urn:
                raise TypeError("Missing required property 'peer_name'")
            __props__.__dict__["peer_name"] = peer_name
            __props__.__dict__["server_external_addresses"] = server_external_addresses
            __props__.__dict__["peering_token"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["peeringToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(PeeringToken, __self__).__init__(
            'consul:index/peeringToken:PeeringToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            partition: Optional[pulumi.Input[_builtins.str]] = None,
            peer_name: Optional[pulumi.Input[_builtins.str]] = None,
            peering_token: Optional[pulumi.Input[_builtins.str]] = None,
            server_external_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'PeeringToken':
        """
        Get an existing PeeringToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] meta: Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        :param pulumi.Input[_builtins.str] peer_name: The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        :param pulumi.Input[_builtins.str] peering_token: The generated peering token
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] server_external_addresses: The addresses for the cluster that generates the peering token. Addresses take the form {host or IP}:port. You can specify one or more load balancers or external IPs that route external traffic to this cluster's Consul servers.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PeeringTokenState.__new__(_PeeringTokenState)

        __props__.__dict__["meta"] = meta
        __props__.__dict__["partition"] = partition
        __props__.__dict__["peer_name"] = peer_name
        __props__.__dict__["peering_token"] = peering_token
        __props__.__dict__["server_external_addresses"] = server_external_addresses
        return PeeringToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        """
        return pulumi.get(self, "meta")

    @_builtins.property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "partition")

    @_builtins.property
    @pulumi.getter(name="peerName")
    def peer_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        """
        return pulumi.get(self, "peer_name")

    @_builtins.property
    @pulumi.getter(name="peeringToken")
    def peering_token(self) -> pulumi.Output[_builtins.str]:
        """
        The generated peering token
        """
        return pulumi.get(self, "peering_token")

    @_builtins.property
    @pulumi.getter(name="serverExternalAddresses")
    def server_external_addresses(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The addresses for the cluster that generates the peering token. Addresses take the form {host or IP}:port. You can specify one or more load balancers or external IPs that route external traffic to this cluster's Consul servers.
        """
        return pulumi.get(self, "server_external_addresses")

