# This file is part of "echion" which is released under MIT.
#
# Copyright (c) 2023 Gabriele N. Tornetta <phoenix1987@gmail.com>.

import typing as t
from types import FrameType

if t.TYPE_CHECKING:
    from asyncio import BaseEventLoop, Task

def start() -> None: ...
def start_async() -> None: ...
def stop() -> None: ...
def track_thread(thread_id: int, name: str, native_id: int) -> None: ...
def untrack_thread(thread_id: int) -> None: ...

# Asyncio support
def track_asyncio_loop(thread_id: int, loop: BaseEventLoop) -> None: ...
def init() -> None: ...
def init_asyncio(
    threads: list, scheduled_tasks: set, eager_tasks: set | None
) -> None: ...
def link_tasks(parent: Task, child: Task) -> None: ...

# Greenlet support
def track_greenlet(
    greenlet_id: int, name: str | None, frame: FrameType | bool | None
) -> None: ...
def untrack_greenlet(greenlet_id: int) -> None: ...
def link_greenlets(greenlet_id: int, parent_id: int) -> None: ...
def update_greenlet_frame(greenlet_id: int, frame: FrameType | bool | None) -> None: ...

# Configuration interface
def set_interval(interval: int) -> None: ...
def set_cpu(cpu: bool) -> None: ...
def set_memory(memory: bool) -> None: ...
def set_native(native: bool) -> None: ...
def set_where(where: bool) -> None: ...
def set_pipe_name(name: str) -> None: ...
def set_max_frames(max_frames: int) -> None: ...
