# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RegistrationArgs', 'Registration']

@pulumi.input_type
class RegistrationArgs:
    def __init__(__self__, *,
                 email_address: pulumi.Input[str],
                 account_key_algorithm: Optional[pulumi.Input[str]] = None,
                 account_key_ecdsa_curve: Optional[pulumi.Input[str]] = None,
                 account_key_pem: Optional[pulumi.Input[str]] = None,
                 account_key_rsa_bits: Optional[pulumi.Input[int]] = None,
                 external_account_binding: Optional[pulumi.Input['RegistrationExternalAccountBindingArgs']] = None):
        """
        The set of arguments for constructing a Registration resource.
        """
        pulumi.set(__self__, "email_address", email_address)
        if account_key_algorithm is not None:
            pulumi.set(__self__, "account_key_algorithm", account_key_algorithm)
        if account_key_ecdsa_curve is not None:
            pulumi.set(__self__, "account_key_ecdsa_curve", account_key_ecdsa_curve)
        if account_key_pem is not None:
            pulumi.set(__self__, "account_key_pem", account_key_pem)
        if account_key_rsa_bits is not None:
            pulumi.set(__self__, "account_key_rsa_bits", account_key_rsa_bits)
        if external_account_binding is not None:
            pulumi.set(__self__, "external_account_binding", external_account_binding)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Input[str]:
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: pulumi.Input[str]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="accountKeyAlgorithm")
    def account_key_algorithm(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_key_algorithm")

    @account_key_algorithm.setter
    def account_key_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key_algorithm", value)

    @property
    @pulumi.getter(name="accountKeyEcdsaCurve")
    def account_key_ecdsa_curve(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_key_ecdsa_curve")

    @account_key_ecdsa_curve.setter
    def account_key_ecdsa_curve(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key_ecdsa_curve", value)

    @property
    @pulumi.getter(name="accountKeyPem")
    def account_key_pem(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_key_pem")

    @account_key_pem.setter
    def account_key_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key_pem", value)

    @property
    @pulumi.getter(name="accountKeyRsaBits")
    def account_key_rsa_bits(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "account_key_rsa_bits")

    @account_key_rsa_bits.setter
    def account_key_rsa_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_key_rsa_bits", value)

    @property
    @pulumi.getter(name="externalAccountBinding")
    def external_account_binding(self) -> Optional[pulumi.Input['RegistrationExternalAccountBindingArgs']]:
        return pulumi.get(self, "external_account_binding")

    @external_account_binding.setter
    def external_account_binding(self, value: Optional[pulumi.Input['RegistrationExternalAccountBindingArgs']]):
        pulumi.set(self, "external_account_binding", value)


@pulumi.input_type
class _RegistrationState:
    def __init__(__self__, *,
                 account_key_algorithm: Optional[pulumi.Input[str]] = None,
                 account_key_ecdsa_curve: Optional[pulumi.Input[str]] = None,
                 account_key_pem: Optional[pulumi.Input[str]] = None,
                 account_key_rsa_bits: Optional[pulumi.Input[int]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 external_account_binding: Optional[pulumi.Input['RegistrationExternalAccountBindingArgs']] = None,
                 registration_url: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Registration resources.
        """
        if account_key_algorithm is not None:
            pulumi.set(__self__, "account_key_algorithm", account_key_algorithm)
        if account_key_ecdsa_curve is not None:
            pulumi.set(__self__, "account_key_ecdsa_curve", account_key_ecdsa_curve)
        if account_key_pem is not None:
            pulumi.set(__self__, "account_key_pem", account_key_pem)
        if account_key_rsa_bits is not None:
            pulumi.set(__self__, "account_key_rsa_bits", account_key_rsa_bits)
        if email_address is not None:
            pulumi.set(__self__, "email_address", email_address)
        if external_account_binding is not None:
            pulumi.set(__self__, "external_account_binding", external_account_binding)
        if registration_url is not None:
            pulumi.set(__self__, "registration_url", registration_url)

    @property
    @pulumi.getter(name="accountKeyAlgorithm")
    def account_key_algorithm(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_key_algorithm")

    @account_key_algorithm.setter
    def account_key_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key_algorithm", value)

    @property
    @pulumi.getter(name="accountKeyEcdsaCurve")
    def account_key_ecdsa_curve(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_key_ecdsa_curve")

    @account_key_ecdsa_curve.setter
    def account_key_ecdsa_curve(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key_ecdsa_curve", value)

    @property
    @pulumi.getter(name="accountKeyPem")
    def account_key_pem(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "account_key_pem")

    @account_key_pem.setter
    def account_key_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "account_key_pem", value)

    @property
    @pulumi.getter(name="accountKeyRsaBits")
    def account_key_rsa_bits(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "account_key_rsa_bits")

    @account_key_rsa_bits.setter
    def account_key_rsa_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "account_key_rsa_bits", value)

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "email_address")

    @email_address.setter
    def email_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_address", value)

    @property
    @pulumi.getter(name="externalAccountBinding")
    def external_account_binding(self) -> Optional[pulumi.Input['RegistrationExternalAccountBindingArgs']]:
        return pulumi.get(self, "external_account_binding")

    @external_account_binding.setter
    def external_account_binding(self, value: Optional[pulumi.Input['RegistrationExternalAccountBindingArgs']]):
        pulumi.set(self, "external_account_binding", value)

    @property
    @pulumi.getter(name="registrationUrl")
    def registration_url(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "registration_url")

    @registration_url.setter
    def registration_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registration_url", value)


class Registration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_key_algorithm: Optional[pulumi.Input[str]] = None,
                 account_key_ecdsa_curve: Optional[pulumi.Input[str]] = None,
                 account_key_pem: Optional[pulumi.Input[str]] = None,
                 account_key_rsa_bits: Optional[pulumi.Input[int]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 external_account_binding: Optional[pulumi.Input[Union['RegistrationExternalAccountBindingArgs', 'RegistrationExternalAccountBindingArgsDict']]] = None,
                 __props__=None):
        """
        Create a Registration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RegistrationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Registration resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param RegistrationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RegistrationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_key_algorithm: Optional[pulumi.Input[str]] = None,
                 account_key_ecdsa_curve: Optional[pulumi.Input[str]] = None,
                 account_key_pem: Optional[pulumi.Input[str]] = None,
                 account_key_rsa_bits: Optional[pulumi.Input[int]] = None,
                 email_address: Optional[pulumi.Input[str]] = None,
                 external_account_binding: Optional[pulumi.Input[Union['RegistrationExternalAccountBindingArgs', 'RegistrationExternalAccountBindingArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RegistrationArgs.__new__(RegistrationArgs)

            __props__.__dict__["account_key_algorithm"] = account_key_algorithm
            __props__.__dict__["account_key_ecdsa_curve"] = account_key_ecdsa_curve
            __props__.__dict__["account_key_pem"] = None if account_key_pem is None else pulumi.Output.secret(account_key_pem)
            __props__.__dict__["account_key_rsa_bits"] = account_key_rsa_bits
            if email_address is None and not opts.urn:
                raise TypeError("Missing required property 'email_address'")
            __props__.__dict__["email_address"] = email_address
            __props__.__dict__["external_account_binding"] = external_account_binding
            __props__.__dict__["registration_url"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["accountKeyPem"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Registration, __self__).__init__(
            'acme:index/registration:Registration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_key_algorithm: Optional[pulumi.Input[str]] = None,
            account_key_ecdsa_curve: Optional[pulumi.Input[str]] = None,
            account_key_pem: Optional[pulumi.Input[str]] = None,
            account_key_rsa_bits: Optional[pulumi.Input[int]] = None,
            email_address: Optional[pulumi.Input[str]] = None,
            external_account_binding: Optional[pulumi.Input[Union['RegistrationExternalAccountBindingArgs', 'RegistrationExternalAccountBindingArgsDict']]] = None,
            registration_url: Optional[pulumi.Input[str]] = None) -> 'Registration':
        """
        Get an existing Registration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RegistrationState.__new__(_RegistrationState)

        __props__.__dict__["account_key_algorithm"] = account_key_algorithm
        __props__.__dict__["account_key_ecdsa_curve"] = account_key_ecdsa_curve
        __props__.__dict__["account_key_pem"] = account_key_pem
        __props__.__dict__["account_key_rsa_bits"] = account_key_rsa_bits
        __props__.__dict__["email_address"] = email_address
        __props__.__dict__["external_account_binding"] = external_account_binding
        __props__.__dict__["registration_url"] = registration_url
        return Registration(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountKeyAlgorithm")
    def account_key_algorithm(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "account_key_algorithm")

    @property
    @pulumi.getter(name="accountKeyEcdsaCurve")
    def account_key_ecdsa_curve(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "account_key_ecdsa_curve")

    @property
    @pulumi.getter(name="accountKeyPem")
    def account_key_pem(self) -> pulumi.Output[str]:
        return pulumi.get(self, "account_key_pem")

    @property
    @pulumi.getter(name="accountKeyRsaBits")
    def account_key_rsa_bits(self) -> pulumi.Output[Optional[int]]:
        return pulumi.get(self, "account_key_rsa_bits")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> pulumi.Output[str]:
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="externalAccountBinding")
    def external_account_binding(self) -> pulumi.Output[Optional['outputs.RegistrationExternalAccountBinding']]:
        return pulumi.get(self, "external_account_binding")

    @property
    @pulumi.getter(name="registrationUrl")
    def registration_url(self) -> pulumi.Output[str]:
        return pulumi.get(self, "registration_url")

