# Generated by ariadne-codegen
# Source: queries.graphql

from typing import TYPE_CHECKING, Any, Dict, List, Optional, Union

from architect_py.common_types import TradableProduct

from .base_model import UNSET
from .juniper_base_client import JuniperBaseClient

if TYPE_CHECKING:
    from .base_model import UnsetType
    from .get_execution_info_query import GetExecutionInfoQuerySymbology
    from .get_execution_infos_query import GetExecutionInfosQuerySymbology
    from .get_first_notice_date_query import GetFirstNoticeDateQuerySymbology
    from .get_future_series_query import GetFutureSeriesQuerySymbology
    from .get_product_info_query import GetProductInfoQuerySymbology
    from .get_product_infos_query import GetProductInfosQuerySymbology
    from .search_symbols_query import SearchSymbolsQuerySymbology
    from .user_id_query import UserIdQueryUser


def gql(q: str) -> str:
    return q


class GraphQLClient(JuniperBaseClient):
    async def user_id_query(self, **kwargs: Any) -> "UserIdQueryUser":
        from .user_id_query import UserIdQuery

        query = gql(
            """
            query UserIdQuery {
              user {
                userId
                userEmail
              }
            }
            """
        )
        variables: Dict[str, object] = {}
        response = await self.execute(
            query=query, operation_name="UserIdQuery", variables=variables, **kwargs
        )
        data = self.get_data(response)
        return UserIdQuery.model_validate(data).user

    async def search_symbols_query(
        self,
        search_string: Union[Optional[str], "UnsetType"] = UNSET,
        execution_venue: Union[Optional[str], "UnsetType"] = UNSET,
        include_expired: Union[Optional[bool], "UnsetType"] = UNSET,
        sort_alphabetically: Union[Optional[bool], "UnsetType"] = UNSET,
        offset: Union[Optional[int], "UnsetType"] = UNSET,
        limit: Union[Optional[int], "UnsetType"] = UNSET,
        **kwargs: Any
    ) -> "SearchSymbolsQuerySymbology":
        from .search_symbols_query import SearchSymbolsQuery

        query = gql(
            """
            query SearchSymbolsQuery($searchString: String, $executionVenue: ExecutionVenue, $include_expired: Boolean, $sort_alphabetically: Boolean, $offset: Int, $limit: Int) {
              symbology {
                searchSymbols(
                  searchString: $searchString
                  executionVenue: $executionVenue
                  offset: $offset
                  limit: $limit
                  includeExpired: $include_expired
                  sortAlphabetically: $sort_alphabetically
                )
              }
            }
            """
        )
        variables: Dict[str, object] = {
            "searchString": search_string,
            "executionVenue": execution_venue,
            "include_expired": include_expired,
            "sort_alphabetically": sort_alphabetically,
            "offset": offset,
            "limit": limit,
        }
        response = await self.execute(
            query=query,
            operation_name="SearchSymbolsQuery",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return SearchSymbolsQuery.model_validate(data).symbology

    async def get_product_info_query(
        self, symbol: str, **kwargs: Any
    ) -> "GetProductInfoQuerySymbology":
        from .get_product_info_query import GetProductInfoQuery

        query = gql(
            """
            query GetProductInfoQuery($symbol: String!) {
              symbology {
                productInfo(symbol: $symbol) {
                  ...ProductInfoFields
                }
              }
            }

            fragment ProductInfoFields on ProductInfo {
              __typename
              symbol
              productType
              underlying
              multiplier
              derivativeKind
              firstNoticeDate
              primaryVenue
              priceDisplayFormat
              spreadLegs {
                ...SpreadLegFields
              }
            }

            fragment SpreadLegFields on SpreadLeg {
              product
              quantity
            }
            """
        )
        variables: Dict[str, object] = {"symbol": symbol}
        response = await self.execute(
            query=query,
            operation_name="GetProductInfoQuery",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetProductInfoQuery.model_validate(data).symbology

    async def get_product_infos_query(
        self, symbols: Union[Optional[List[str]], "UnsetType"] = UNSET, **kwargs: Any
    ) -> "GetProductInfosQuerySymbology":
        from .get_product_infos_query import GetProductInfosQuery

        query = gql(
            """
            query GetProductInfosQuery($symbols: [String!]) {
              symbology {
                productInfos(symbols: $symbols) {
                  ...ProductInfoFields
                }
              }
            }

            fragment ProductInfoFields on ProductInfo {
              __typename
              symbol
              productType
              underlying
              multiplier
              derivativeKind
              firstNoticeDate
              primaryVenue
              priceDisplayFormat
              spreadLegs {
                ...SpreadLegFields
              }
            }

            fragment SpreadLegFields on SpreadLeg {
              product
              quantity
            }
            """
        )
        variables: Dict[str, object] = {"symbols": symbols}
        response = await self.execute(
            query=query,
            operation_name="GetProductInfosQuery",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetProductInfosQuery.model_validate(data).symbology

    async def get_first_notice_date_query(
        self, symbol: str, **kwargs: Any
    ) -> "GetFirstNoticeDateQuerySymbology":
        from .get_first_notice_date_query import GetFirstNoticeDateQuery

        query = gql(
            """
            query GetFirstNoticeDateQuery($symbol: String!) {
              symbology {
                productInfo(symbol: $symbol) {
                  firstNoticeDate
                }
              }
            }
            """
        )
        variables: Dict[str, object] = {"symbol": symbol}
        response = await self.execute(
            query=query,
            operation_name="GetFirstNoticeDateQuery",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetFirstNoticeDateQuery.model_validate(data).symbology

    async def get_future_series_query(
        self, series_symbol: str, **kwargs: Any
    ) -> "GetFutureSeriesQuerySymbology":
        from .get_future_series_query import GetFutureSeriesQuery

        query = gql(
            """
            query GetFutureSeriesQuery($seriesSymbol: String!) {
              symbology {
                futuresSeries(seriesSymbol: $seriesSymbol)
              }
            }
            """
        )
        variables: Dict[str, object] = {"seriesSymbol": series_symbol}
        response = await self.execute(
            query=query,
            operation_name="GetFutureSeriesQuery",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetFutureSeriesQuery.model_validate(data).symbology

    async def get_execution_info_query(
        self, symbol: TradableProduct, execution_venue: str, **kwargs: Any
    ) -> "GetExecutionInfoQuerySymbology":
        from .get_execution_info_query import GetExecutionInfoQuery

        query = gql(
            """
            query GetExecutionInfoQuery($symbol: TradableProduct!, $executionVenue: ExecutionVenue!) {
              symbology {
                executionInfo(symbol: $symbol, executionVenue: $executionVenue) {
                  ...ExecutionInfoFields
                }
              }
            }

            fragment ExecutionInfoFields on ExecutionInfo {
              symbol
              executionVenue
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              isDelisted
              initialMargin
              maintenanceMargin
            }
            """
        )
        variables: Dict[str, object] = {
            "symbol": symbol,
            "executionVenue": execution_venue,
        }
        response = await self.execute(
            query=query,
            operation_name="GetExecutionInfoQuery",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetExecutionInfoQuery.model_validate(data).symbology

    async def get_execution_infos_query(
        self,
        symbols: Union[Optional[List[TradableProduct]], "UnsetType"] = UNSET,
        execution_venue: Union[Optional[str], "UnsetType"] = UNSET,
        **kwargs: Any
    ) -> "GetExecutionInfosQuerySymbology":
        from .get_execution_infos_query import GetExecutionInfosQuery

        query = gql(
            """
            query GetExecutionInfosQuery($symbols: [TradableProduct!], $executionVenue: ExecutionVenue) {
              symbology {
                executionInfos(symbols: $symbols, executionVenue: $executionVenue) {
                  ...ExecutionInfoFields
                }
              }
            }

            fragment ExecutionInfoFields on ExecutionInfo {
              symbol
              executionVenue
              tickSize
              stepSize
              minOrderQuantity
              minOrderQuantityUnit
              isDelisted
              initialMargin
              maintenanceMargin
            }
            """
        )
        variables: Dict[str, object] = {
            "symbols": symbols,
            "executionVenue": execution_venue,
        }
        response = await self.execute(
            query=query,
            operation_name="GetExecutionInfosQuery",
            variables=variables,
            **kwargs
        )
        data = self.get_data(response)
        return GetExecutionInfosQuery.model_validate(data).symbology
