# Generated by ariadne-codegen
# Source: queries.graphql

from datetime import date
from decimal import Decimal
from typing import List, Optional

from pydantic import Field

from .base_model import BaseModel
from .enums import MinOrderQuantityUnit


class ExecutionInfoFields(BaseModel):
    symbol: str
    execution_venue: str = Field(alias="executionVenue")
    tick_size: Optional[Decimal] = Field(alias="tickSize")
    step_size: Decimal = Field(alias="stepSize")
    min_order_quantity: Decimal = Field(alias="minOrderQuantity")
    min_order_quantity_unit: MinOrderQuantityUnit = Field(alias="minOrderQuantityUnit")
    is_delisted: bool = Field(alias="isDelisted")
    initial_margin: Optional[Decimal] = Field(alias="initialMargin")
    maintenance_margin: Optional[Decimal] = Field(alias="maintenanceMargin")


class SpreadLegFields(BaseModel):
    product: str
    quantity: Decimal


class ProductInfoFields(BaseModel):
    typename__: str = Field(alias="__typename")
    symbol: str
    product_type: str = Field(alias="productType")
    underlying: Optional[str]
    multiplier: Optional[Decimal]
    derivative_kind: Optional[str] = Field(alias="derivativeKind")
    first_notice_date: Optional[date] = Field(alias="firstNoticeDate")
    primary_venue: Optional[str] = Field(alias="primaryVenue")
    price_display_format: Optional[str] = Field(alias="priceDisplayFormat")
    spread_legs: Optional[List["ProductInfoFieldsSpreadLegs"]] = Field(
        alias="spreadLegs"
    )


class ProductInfoFieldsSpreadLegs(SpreadLegFields):
    pass


ExecutionInfoFields.model_rebuild()
SpreadLegFields.model_rebuild()
ProductInfoFields.model_rebuild()
