# generated by datamodel-codegen:
#   filename:  Accounts/AccountsRequest.json

from __future__ import annotations
from architect_py.grpc.models.Accounts.AccountsResponse import AccountsResponse

from typing import Annotated, Optional

from msgspec import Meta, Struct

from .. import definitions


class AccountsRequest(Struct, omit_defaults=True):
    paper: Optional[bool] = False
    trader: Optional[
        Annotated[
            Optional[definitions.TraderIdOrEmail],
            Meta(
                description="Request accounts from the perspective of this trader; if not specified, defaults to the caller user."
            ),
        ]
    ] = None
    """
    Request accounts from the perspective of this trader; if not specified, defaults to the caller user.
    """

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        paper: Optional[bool] = False,
        trader: Optional[definitions.TraderIdOrEmail] = None,
    ):
        return cls(
            paper,
            trader,
        )

    def __str__(self) -> str:
        return f"AccountsRequest(paper={self.paper},trader={self.trader})"

    @staticmethod
    def get_response_type():
        return AccountsResponse

    @staticmethod
    def get_unannotated_response_type():
        return AccountsResponse

    @staticmethod
    def get_route() -> str:
        return "/json.architect.Accounts/Accounts"

    @staticmethod
    def get_rpc_method():
        return "unary"
