# generated by datamodel-codegen:
#   filename:  Accounts/ResetPaperAccountRequest.json

from __future__ import annotations
from architect_py.grpc.models.Accounts.ResetPaperAccountResponse import (
    ResetPaperAccountResponse,
)

from typing import Annotated, Optional

from msgspec import Meta, Struct

from .. import definitions


class ResetPaperAccountRequest(Struct, omit_defaults=True):
    account: Annotated[
        definitions.AccountIdOrName,
        Meta(
            description="The trader for whom to reset paper accounts. If not specified, defaults to the caller user."
        ),
    ]
    """
    The trader for whom to reset paper accounts. If not specified, defaults to the caller user.
    """
    balance: Optional[int] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account: definitions.AccountIdOrName,
        balance: Optional[int] = None,
    ):
        return cls(
            account,
            balance,
        )

    def __str__(self) -> str:
        return (
            f"ResetPaperAccountRequest(account={self.account},balance={self.balance})"
        )

    @staticmethod
    def get_response_type():
        return ResetPaperAccountResponse

    @staticmethod
    def get_unannotated_response_type():
        return ResetPaperAccountResponse

    @staticmethod
    def get_route() -> str:
        return "/json.architect.Accounts/ResetPaperAccount"

    @staticmethod
    def get_rpc_method():
        return "unary"
