# generated by datamodel-codegen:
#   filename:  Algo/AlgoOrder.json

from __future__ import annotations

from datetime import datetime
from typing import Annotated, Any, List, Optional

from msgspec import Meta, Struct

from .. import definitions


class AlgoOrder(Struct, omit_defaults=True):
    algo: str
    create_time: datetime
    id: definitions.OrderId
    num_errors: Annotated[int, Meta(ge=0)]
    num_open_orders: Annotated[int, Meta(ge=0)]
    num_rejects: Annotated[int, Meta(ge=0)]
    num_sent_orders: Annotated[int, Meta(ge=0)]
    params: Any
    status: definitions.AlgoOrderStatus
    status_details: Any
    trader: definitions.UserId
    display_symbols: Optional[List[str]] = None
    finish_success: Optional[
        Annotated[
            Optional[bool],
            Meta(
                description="If the algo order is stopped, whether the stop was successful."
            ),
        ]
    ] = None
    """
    If the algo order is stopped, whether the stop was successful.
    """
    finish_time: Optional[
        Annotated[
            Optional[datetime],
            Meta(
                description="If the algo order is stopped, the time at which it was stopped."
            ),
        ]
    ] = None
    """
    If the algo order is stopped, the time at which it was stopped.
    """
    parent_id: Optional[definitions.OrderId] = None
    reject_or_error_reason: Optional[
        Annotated[
            Optional[str],
            Meta(
                description="If algo order status is rejected, contains the reject reason; for algo orders that finished unsuccessfully, contains the error reason."
            ),
        ]
    ] = None
    """
    If algo order status is rejected, contains the reject reason; for algo orders that finished unsuccessfully, contains the error reason.
    """
    working_progress: Optional[
        Annotated[
            Optional[float],
            Meta(description="Progress of the algo, 0.0 to 1.0, if computable"),
        ]
    ] = None
    """
    Progress of the algo, 0.0 to 1.0, if computable
    """

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        algo: str,
        create_time: datetime,
        id: definitions.OrderId,
        num_errors: int,
        num_open_orders: int,
        num_rejects: int,
        num_sent_orders: int,
        params: Any,
        status: definitions.AlgoOrderStatus,
        status_details: Any,
        trader: definitions.UserId,
        display_symbols: Optional[List[str]] = None,
        finish_success: Optional[bool] = None,
        finish_time: Optional[datetime] = None,
        parent_id: Optional[definitions.OrderId] = None,
        reject_or_error_reason: Optional[str] = None,
        working_progress: Optional[float] = None,
    ):
        return cls(
            algo,
            create_time,
            id,
            num_errors,
            num_open_orders,
            num_rejects,
            num_sent_orders,
            params,
            status,
            status_details,
            trader,
            display_symbols,
            finish_success,
            finish_time,
            parent_id,
            reject_or_error_reason,
            working_progress,
        )

    def __str__(self) -> str:
        return f"AlgoOrder(algo={self.algo},create_time={self.create_time},id={self.id},num_errors={self.num_errors},num_open_orders={self.num_open_orders},num_rejects={self.num_rejects},num_sent_orders={self.num_sent_orders},params={self.params},status={self.status},status_details={self.status_details},trader={self.trader},display_symbols={self.display_symbols},finish_success={self.finish_success},finish_time={self.finish_time},parent_id={self.parent_id},reject_or_error_reason={self.reject_or_error_reason},working_progress={self.working_progress})"
