# generated by datamodel-codegen:
#   filename:  Algo/AlgoOrdersRequest.json

from __future__ import annotations
from architect_py.grpc.models.Algo.AlgoOrdersResponse import AlgoOrdersResponse

from datetime import datetime
from typing import List, Optional

from msgspec import Struct

from .. import definitions


class AlgoOrdersRequest(Struct, omit_defaults=True):
    """
    Find all algo orders matching the given criteria.

    If limit is not specified, it will default to 100.
    """

    algo: Optional[str] = None
    display_symbol: Optional[str] = None
    from_inclusive: Optional[datetime] = None
    limit: Optional[int] = None
    parent_order_id: Optional[definitions.OrderId] = None
    status: Optional[List[definitions.AlgoOrderStatus]] = None
    to_exclusive: Optional[datetime] = None
    trader: Optional[definitions.TraderIdOrEmail] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        algo: Optional[str] = None,
        display_symbol: Optional[str] = None,
        from_inclusive: Optional[datetime] = None,
        limit: Optional[int] = None,
        parent_order_id: Optional[definitions.OrderId] = None,
        status: Optional[List[definitions.AlgoOrderStatus]] = None,
        to_exclusive: Optional[datetime] = None,
        trader: Optional[definitions.TraderIdOrEmail] = None,
    ):
        return cls(
            algo,
            display_symbol,
            from_inclusive,
            limit,
            parent_order_id,
            status,
            to_exclusive,
            trader,
        )

    def __str__(self) -> str:
        return f"AlgoOrdersRequest(algo={self.algo},display_symbol={self.display_symbol},from_inclusive={self.from_inclusive},limit={self.limit},parent_order_id={self.parent_order_id},status={self.status},to_exclusive={self.to_exclusive},trader={self.trader})"

    @staticmethod
    def get_response_type():
        return AlgoOrdersResponse

    @staticmethod
    def get_unannotated_response_type():
        return AlgoOrdersResponse

    @staticmethod
    def get_route() -> str:
        return "/json.architect.Algo/AlgoOrders"

    @staticmethod
    def get_rpc_method():
        return "unary"
