# generated by datamodel-codegen:
#   filename:  Cpty/CptyRequest.json

from __future__ import annotations
from architect_py.grpc.models.Cpty.CptyResponse import (
    CptyResponse,
    Symbology,
    ReconcileOrder,
    ReconcileOpenOrders,
    UpdateAccountSummary,
)

from typing import Annotated, List, Optional, Union

from msgspec import Meta, Struct

from .. import definitions
from ..Oms.Cancel import Cancel
from ..Oms.Order import Order


class CancelAllOrders(
    Struct, omit_defaults=True, tag_field="t", tag="cancel_all_orders"
):
    cancel_id: str
    account: Optional[str] = None
    trader: Optional[definitions.UserId] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        cancel_id: str,
        account: Optional[str] = None,
        trader: Optional[definitions.UserId] = None,
    ):
        return cls(
            cancel_id,
            account,
            trader,
        )

    def __str__(self) -> str:
        return f"CancelAllOrders(cancel_id={self.cancel_id},account={self.account},trader={self.trader})"


class CancelOrder(Struct, omit_defaults=True, tag_field="t", tag="cancel_order"):
    cancel: Cancel
    original_order: Optional[Order] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        cancel: Cancel,
        original_order: Optional[Order] = None,
    ):
        return cls(
            cancel,
            original_order,
        )

    def __str__(self) -> str:
        return f"CancelOrder(cancel={self.cancel},original_order={self.original_order})"


class BatchCancelOrders(
    Struct, omit_defaults=True, tag_field="t", tag="batch_cancel_orders"
):
    cancels: List[Cancel]
    original_orders: List[Optional[Order]]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        cancels: List[Cancel],
        original_orders: List[Optional[Order]],
    ):
        return cls(
            cancels,
            original_orders,
        )

    def __str__(self) -> str:
        return f"BatchCancelOrders(cancels={self.cancels},original_orders={self.original_orders})"


class Login(
    definitions.CptyLoginRequest, omit_defaults=True, tag_field="t", tag="login"
):
    pass


class Logout(
    definitions.CptyLogoutRequest, omit_defaults=True, tag_field="t", tag="logout"
):
    pass


class PlaceOrder(Order, omit_defaults=True, tag_field="t", tag="place_order"):
    pass


class PlaceBatchOrder(
    definitions.BatchOrder, omit_defaults=True, tag_field="t", tag="place_batch_order"
):
    pass


CptyRequest = Annotated[
    Union[
        Login,
        Logout,
        PlaceOrder,
        PlaceBatchOrder,
        CancelOrder,
        CancelAllOrders,
        BatchCancelOrders,
    ],
    Meta(title="CptyRequest"),
]

CptyRequest_rpc_method = "duplex_stream"
UnannotatedCptyRequest = (
    Login
    | Logout
    | PlaceOrder
    | PlaceBatchOrder
    | CancelOrder
    | CancelAllOrders
    | BatchCancelOrders
)
CptyRequestResponseType = CptyResponse
CptyRequestUnannotatedResponseType = (
    Symbology | ReconcileOrder | ReconcileOpenOrders | UpdateAccountSummary
)
CptyRequest_route = "/json.architect.Cpty/Cpty"
