# generated by datamodel-codegen:
#   filename:  Cpty/CptyResponse.json

from __future__ import annotations

from typing import Annotated, Any, Dict, List, Optional, Union

from msgspec import Meta, Struct

from .. import definitions
from ..Oms.Order import Order


class UpdateAccountSummary(Struct, omit_defaults=True, tag_field="t", tag="as"):
    account: definitions.AccountIdOrName
    is_snapshot: bool
    timestamp: int
    timestamp_ns: Annotated[int, Meta(ge=0)]
    balances: Optional[Dict[str, Any]] = None
    positions: Optional[Dict[str, Any]] = None
    statistics: Optional[definitions.AccountStatistics] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account: definitions.AccountIdOrName,
        is_snapshot: bool,
        timestamp: int,
        timestamp_ns: int,
        balances: Optional[Dict[str, Any]] = None,
        positions: Optional[Dict[str, Any]] = None,
        statistics: Optional[definitions.AccountStatistics] = None,
    ):
        return cls(
            account,
            is_snapshot,
            timestamp,
            timestamp_ns,
            balances,
            positions,
            statistics,
        )

    def __str__(self) -> str:
        return f"UpdateAccountSummary(account={self.account},is_snapshot={self.is_snapshot},timestamp={self.timestamp},timestamp_ns={self.timestamp_ns},balances={self.balances},positions={self.positions},statistics={self.statistics})"


class Symbology(Struct, omit_defaults=True, tag_field="t", tag="xs"):
    execution_info: Dict[str, Dict[str, definitions.ExecutionInfo]]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        execution_info: Dict[str, Dict[str, definitions.ExecutionInfo]],
    ):
        return cls(
            execution_info,
        )

    def __str__(self) -> str:
        return f"Symbology(execution_info={self.execution_info})"


class ReconcileOpenOrders(Struct, omit_defaults=True, tag_field="t", tag="oo"):
    orders: List[Order]
    snapshot_for_account: Optional[definitions.AccountIdOrName] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        orders: List[Order],
        snapshot_for_account: Optional[definitions.AccountIdOrName] = None,
    ):
        return cls(
            orders,
            snapshot_for_account,
        )

    def __str__(self) -> str:
        return f"ReconcileOpenOrders(orders={self.orders},snapshot_for_account={self.snapshot_for_account})"


class ReconcileOrder(Order, omit_defaults=True, tag_field="t", tag="ro"):
    pass


CptyResponse = Annotated[
    Union[Symbology, ReconcileOrder, ReconcileOpenOrders, UpdateAccountSummary],
    Meta(title="CptyResponse"),
]
