# generated by datamodel-codegen:
#   filename:  Folio/AccountSummariesRequest.json

from __future__ import annotations
from architect_py.grpc.models.Folio.AccountSummariesResponse import (
    AccountSummariesResponse,
)

from typing import Annotated, List, Optional

from msgspec import Meta, Struct

from .. import definitions


class AccountSummariesRequest(Struct, omit_defaults=True):
    accounts: Optional[
        Annotated[
            List[definitions.AccountIdOrName],
            Meta(
                description="If trader and accounts are both None, return all accounts for the user"
            ),
        ]
    ] = None
    """
    If trader and accounts are both None, return all accounts for the user
    """
    trader: Optional[definitions.TraderIdOrEmail] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        accounts: Optional[List[definitions.AccountIdOrName]] = None,
        trader: Optional[definitions.TraderIdOrEmail] = None,
    ):
        return cls(
            accounts,
            trader,
        )

    def __str__(self) -> str:
        return f"AccountSummariesRequest(accounts={self.accounts},trader={self.trader})"

    @staticmethod
    def get_response_type():
        return AccountSummariesResponse

    @staticmethod
    def get_unannotated_response_type():
        return AccountSummariesResponse

    @staticmethod
    def get_route() -> str:
        return "/json.architect.Folio/AccountSummaries"

    @staticmethod
    def get_rpc_method():
        return "unary"
