# generated by datamodel-codegen:
#   filename:  Folio/HistoricalFillsRequest.json

from __future__ import annotations
from architect_py.grpc.models.Folio.HistoricalFillsResponse import (
    HistoricalFillsResponse,
)

from datetime import datetime
from typing import Annotated, Optional

from msgspec import Meta, Struct

from .. import definitions


class HistoricalFillsRequest(Struct, omit_defaults=True):
    account: Optional[definitions.AccountIdOrName] = None
    from_inclusive: Optional[datetime] = None
    limit: Optional[
        Annotated[Optional[int], Meta(description="Default maximum is 1000.")]
    ] = None
    """
    Default maximum is 1000.
    """
    order_id: Optional[definitions.OrderId] = None
    symbol: Optional[str] = None
    to_exclusive: Optional[datetime] = None
    trader: Optional[definitions.TraderIdOrEmail] = None
    venue: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account: Optional[definitions.AccountIdOrName] = None,
        from_inclusive: Optional[datetime] = None,
        limit: Optional[int] = None,
        order_id: Optional[definitions.OrderId] = None,
        symbol: Optional[str] = None,
        to_exclusive: Optional[datetime] = None,
        trader: Optional[definitions.TraderIdOrEmail] = None,
        venue: Optional[str] = None,
    ):
        return cls(
            account,
            from_inclusive,
            limit,
            order_id,
            symbol,
            to_exclusive,
            trader,
            venue,
        )

    def __str__(self) -> str:
        return f"HistoricalFillsRequest(account={self.account},from_inclusive={self.from_inclusive},limit={self.limit},order_id={self.order_id},symbol={self.symbol},to_exclusive={self.to_exclusive},trader={self.trader},venue={self.venue})"

    @staticmethod
    def get_response_type():
        return HistoricalFillsResponse

    @staticmethod
    def get_unannotated_response_type():
        return HistoricalFillsResponse

    @staticmethod
    def get_route() -> str:
        return "/json.architect.Folio/HistoricalFills"

    @staticmethod
    def get_rpc_method():
        return "unary"
