# generated by datamodel-codegen:
#   filename:  Marketdata/L1BookSnapshot.json

from __future__ import annotations
from datetime import datetime, timezone

from decimal import Decimal
from typing import Annotated, List, Optional

from msgspec import Meta, Struct


class L1BookSnapshot(Struct, omit_defaults=True):
    s: Annotated[str, Meta(title="symbol")]
    tn: Annotated[int, Meta(ge=0, title="timestamp_ns")]
    ts: Annotated[
        int,
        Meta(
            description="Time that the exchange stamped the message", title="timestamp"
        ),
    ]
    """
    Time that the exchange stamped the message
    """
    a: Optional[
        Annotated[
            List[Decimal], Meta(description="(price, quantity)", title="best_ask")
        ]
    ] = None
    """
    (price, quantity)
    """
    b: Optional[
        Annotated[
            List[Decimal], Meta(description="(price, quantity)", title="best_bid")
        ]
    ] = None
    """
    (price, quantity)
    """
    rt: Optional[
        Annotated[
            Optional[int],
            Meta(
                description="Time that Architect feed received the message that updated the BBO",
                title="recv_time",
            ),
        ]
    ] = None
    """
    Time that Architect feed received the message that updated the BBO
    """
    rtn: Optional[Annotated[Optional[int], Meta(title="recv_time_ns")]] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        symbol: str,
        timestamp_ns: int,
        timestamp: int,
        best_ask: Optional[List[Decimal]] = None,
        best_bid: Optional[List[Decimal]] = None,
        recv_time: Optional[int] = None,
        recv_time_ns: Optional[int] = None,
    ):
        return cls(
            symbol,
            timestamp_ns,
            timestamp,
            best_ask,
            best_bid,
            recv_time,
            recv_time_ns,
        )

    def __str__(self) -> str:
        return f"L1BookSnapshot(symbol={self.s},timestamp_ns={self.tn},timestamp={self.ts},best_ask={self.a},best_bid={self.b},recv_time={self.rt},recv_time_ns={self.rtn})"

    @property
    def symbol(self) -> str:
        return self.s

    @symbol.setter
    def symbol(self, value: str) -> None:
        self.s = value

    @property
    def timestamp_ns(self) -> int:
        return self.tn

    @timestamp_ns.setter
    def timestamp_ns(self, value: int) -> None:
        self.tn = value

    @property
    def timestamp(self) -> int:
        return self.ts

    @timestamp.setter
    def timestamp(self, value: int) -> None:
        self.ts = value

    @property
    def datetime(self) -> datetime:
        """
        Convenience property to get the timestamp as a datetime object in UTC.
        """
        return datetime.fromtimestamp(self.ts, tz=timezone.utc)

    @property
    def datetime_local(self) -> datetime:
        """
        Convenience property to get the timestamp as a datetime object in local time.
        """
        return datetime.fromtimestamp(self.ts)

    @property
    def best_ask(self) -> Optional[List[Decimal]]:
        return self.a

    @best_ask.setter
    def best_ask(self, value: Optional[List[Decimal]]) -> None:
        self.a = value

    @property
    def best_bid(self) -> Optional[List[Decimal]]:
        return self.b

    @best_bid.setter
    def best_bid(self, value: Optional[List[Decimal]]) -> None:
        self.b = value

    @property
    def recv_time(self) -> Optional[int]:
        return self.rt

    @recv_time.setter
    def recv_time(self, value: Optional[int]) -> None:
        self.rt = value

    @property
    def recv_time_ns(self) -> Optional[int]:
        return self.rtn

    @recv_time_ns.setter
    def recv_time_ns(self, value: Optional[int]) -> None:
        self.rtn = value
