# generated by datamodel-codegen:
#   filename:  Marketdata/L2BookUpdate.json

from __future__ import annotations

from typing import Annotated, Union

from msgspec import Meta

from .. import definitions
from .L2BookSnapshot import L2BookSnapshot


class Snapshot(L2BookSnapshot, omit_defaults=True, tag_field="t", tag="s"):
    pass


class Diff(definitions.L2BookDiff, omit_defaults=True, tag_field="t", tag="d"):
    pass


L2BookUpdate = Annotated[
    Union[Snapshot, Diff],
    Meta(
        description='To build a book from a stream of updates, the client should first subscribe to this update stream, which then returns a stream starting with a snapshot and following with diffs.\n\nDiffs should be applied consecutively to the snapshot in order to reconstruct the state of the book.\n\n```rust # use architect_api::marketdata::*; # use std::collections::BTreeMap; # use rust_decimal::Decimal; # use rust_decimal_macros::dec;\n\n/// Suppose we receive this snapshot from the server: let snapshot: L2BookUpdate = serde_json::from_str(r#"{ "t": "s", "ts": 1729700837, "tn": 0, "sid": 123, "sn": 8999, "b": [["99.00", "3"], ["98.78", "2"]], "a": [["100.00", "1"], ["100.10", "2"]] }"#)?;\n\n/// It corresponds to the following book: let mut book = BTreeMap::new(); book.insert(dec!(99.00), 3); book.insert(dec!(98.78), 2); book.insert(dec!(100.00), 1); book.insert(dec!(100.10), 2);\n\n/// Then we receive this update: let diff: L2BookUpdate = serde_json::from_str(r#"{ "t": "d", "ts": 1729700839, "tn": 0, "sid": 123, "sn": 9000, "b": [["99.00", "1"]], "a": [] }"#)?;\n\n/// Verify that the sequence number is correct assert!(diff.sequence().is_next_in_sequence(&snapshot.sequence()));\n\n/// Apply the update to our book book.insert(dec!(99.00), 1);\n\n// Suppose we then receive this update: let diff: L2BookUpdate = serde_json::from_str(r#"{ "t": "d", "ts": 1729700841, "tn": 0, "sid": 123, "sn": 9005, "b": [], "a": [["103.00", "1"]] }"#)?;\n\n/// We shouldn\'t apply this update because it\'s not next in sequence! assert_eq!(diff.sequence().is_next_in_sequence(&snapshot.sequence()), false);\n\n/// Or if we had received this update: let diff: L2BookUpdate = serde_json::from_str(r#"{ "t": "d", "ts": 1729700841, "tn": 0, "sid": 170, "sn": 9001, "b": [], "a": [["103.00", "1"]] }"#)?;\n\n/// It appears that the sequence id is changed, signalling a new sequence. /// In this case, we should re-request the snapshot from the server. assert_eq!(diff.sequence().is_next_in_sequence(&snapshot.sequence()), false);\n\n# Ok::<(), anyhow::Error>(()) ```',
        title="L2BookUpdate",
    ),
]
