# generated by datamodel-codegen:
#   filename:  Marketdata/SubscribeCandlesRequest.json

from __future__ import annotations
from architect_py.grpc.models.Marketdata.Candle import Candle

from typing import Annotated, List, Optional

from msgspec import Meta, Struct

from .. import definitions


class SubscribeCandlesRequest(Struct, omit_defaults=True):
    symbol: str
    candle_widths: Optional[
        Annotated[
            List[definitions.CandleWidth],
            Meta(description="If None, subscribe from all candle widths on the feed"),
        ]
    ] = None
    """
    If None, subscribe from all candle widths on the feed
    """
    venue: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        symbol: str,
        candle_widths: Optional[List[definitions.CandleWidth]] = None,
        venue: Optional[str] = None,
    ):
        return cls(
            symbol,
            candle_widths,
            venue,
        )

    def __str__(self) -> str:
        return f"SubscribeCandlesRequest(symbol={self.symbol},candle_widths={self.candle_widths},venue={self.venue})"

    @staticmethod
    def get_response_type():
        return Candle

    @staticmethod
    def get_unannotated_response_type():
        return Candle

    @staticmethod
    def get_route() -> str:
        return "/json.architect.Marketdata/SubscribeCandles"

    @staticmethod
    def get_rpc_method():
        return "stream"
