# generated by datamodel-codegen:
#   filename:  Marketdata/SubscribeCurrentCandlesRequest.json

from __future__ import annotations
from architect_py.grpc.models.Marketdata.Candle import Candle

from typing import Annotated, Optional

from msgspec import Meta, Struct

from .. import definitions


class SubscribeCurrentCandlesRequest(Struct, omit_defaults=True):
    """
    Subscribe to the current candle.  This allows you to display the most recent/building candle live in a UI, for example.
    """

    candle_width: definitions.CandleWidth
    symbol: str
    tick_period_ms: Optional[
        Annotated[
            Optional[int],
            Meta(
                description="If None, send the current candle on every trade or candle tick. Otherwise, send a candle every `tick_period_ms`."
            ),
        ]
    ] = None
    """
    If None, send the current candle on every trade or candle tick. Otherwise, send a candle every `tick_period_ms`.
    """
    venue: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        candle_width: definitions.CandleWidth,
        symbol: str,
        tick_period_ms: Optional[int] = None,
        venue: Optional[str] = None,
    ):
        return cls(
            candle_width,
            symbol,
            tick_period_ms,
            venue,
        )

    def __str__(self) -> str:
        return f"SubscribeCurrentCandlesRequest(candle_width={self.candle_width},symbol={self.symbol},tick_period_ms={self.tick_period_ms},venue={self.venue})"

    @staticmethod
    def get_response_type():
        return Candle

    @staticmethod
    def get_unannotated_response_type():
        return Candle

    @staticmethod
    def get_route() -> str:
        return "/json.architect.Marketdata/SubscribeCurrentCandles"

    @staticmethod
    def get_rpc_method():
        return "stream"
