# generated by datamodel-codegen:
#   filename:  Marketdata/Ticker.json

from __future__ import annotations
from datetime import datetime, timezone

from datetime import date, datetime
from decimal import Decimal
from typing import Annotated, Optional

from msgspec import Meta, Struct, field


class Ticker(Struct, omit_defaults=True):
    s: Annotated[str, Meta(title="symbol")]
    tn: Annotated[int, Meta(ge=0, title="timestamp_ns")]
    ts: Annotated[int, Meta(title="timestamp")]
    ve: Annotated[str, Meta(title="venue")]
    ap: Optional[Annotated[Optional[Decimal], Meta(title="ask_price")]] = None
    as_: Optional[Annotated[Optional[Decimal], Meta(title="ask_size")]] = field(
        name="as", default=None
    )
    bp: Optional[Annotated[Optional[Decimal], Meta(title="bid_price")]] = None
    bs: Optional[Annotated[Optional[Decimal], Meta(title="bid_size")]] = None
    dividend: Optional[Decimal] = None
    dividend_yield: Optional[Decimal] = None
    eps_adj: Optional[Decimal] = None
    fr: Optional[Annotated[Optional[Decimal], Meta(title="funding_rate")]] = None
    ft: Optional[Annotated[Optional[datetime], Meta(title="next_funding_time")]] = None
    h: Optional[Annotated[Optional[Decimal], Meta(title="high_24h")]] = None
    ip: Optional[Annotated[Optional[Decimal], Meta(title="index_price")]] = None
    isp: Optional[
        Annotated[Optional[Decimal], Meta(title="indicative_settlement_price")]
    ] = None
    l: Optional[Annotated[Optional[Decimal], Meta(title="low_24h")]] = None
    market_cap: Optional[Decimal] = None
    mp: Optional[Annotated[Optional[Decimal], Meta(title="mark_price")]] = None
    o: Optional[Annotated[Optional[Decimal], Meta(title="open_24h")]] = None
    oi: Optional[Annotated[Optional[Decimal], Meta(title="open_interest")]] = None
    p: Optional[Annotated[Optional[Decimal], Meta(title="last_price")]] = None
    price_to_earnings: Optional[Decimal] = None
    q: Optional[Annotated[Optional[Decimal], Meta(title="last_size")]] = None
    sd: Optional[Annotated[Optional[date], Meta(title="last_settlement_date")]] = None
    shares_outstanding_weighted_adj: Optional[Decimal] = None
    sp: Optional[Annotated[Optional[Decimal], Meta(title="last_settlement_price")]] = (
        None
    )
    v: Optional[Annotated[Optional[Decimal], Meta(title="volume_24h")]] = None
    vm: Optional[Annotated[Optional[Decimal], Meta(title="volume_30d")]] = None
    xh: Optional[Annotated[Optional[Decimal], Meta(title="session_high")]] = None
    xl: Optional[Annotated[Optional[Decimal], Meta(title="session_low")]] = None
    xo: Optional[Annotated[Optional[Decimal], Meta(title="session_open")]] = None
    xv: Optional[Annotated[Optional[Decimal], Meta(title="session_volume")]] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        symbol: str,
        timestamp_ns: int,
        timestamp: int,
        venue: str,
        ask_price: Optional[Decimal] = None,
        ask_size: Optional[Decimal] = field(name="as", default=None),
        bid_price: Optional[Decimal] = None,
        bid_size: Optional[Decimal] = None,
        dividend: Optional[Decimal] = None,
        dividend_yield: Optional[Decimal] = None,
        eps_adj: Optional[Decimal] = None,
        funding_rate: Optional[Decimal] = None,
        next_funding_time: Optional[datetime] = None,
        high_24h: Optional[Decimal] = None,
        index_price: Optional[Decimal] = None,
        indicative_settlement_price: Optional[Decimal] = None,
        low_24h: Optional[Decimal] = None,
        market_cap: Optional[Decimal] = None,
        mark_price: Optional[Decimal] = None,
        open_24h: Optional[Decimal] = None,
        open_interest: Optional[Decimal] = None,
        last_price: Optional[Decimal] = None,
        price_to_earnings: Optional[Decimal] = None,
        last_size: Optional[Decimal] = None,
        last_settlement_date: Optional[date] = None,
        shares_outstanding_weighted_adj: Optional[Decimal] = None,
        last_settlement_price: Optional[Decimal] = None,
        volume_24h: Optional[Decimal] = None,
        volume_30d: Optional[Decimal] = None,
        session_high: Optional[Decimal] = None,
        session_low: Optional[Decimal] = None,
        session_open: Optional[Decimal] = None,
        session_volume: Optional[Decimal] = None,
    ):
        return cls(
            symbol,
            timestamp_ns,
            timestamp,
            venue,
            ask_price,
            ask_size,
            bid_price,
            bid_size,
            dividend,
            dividend_yield,
            eps_adj,
            funding_rate,
            next_funding_time,
            high_24h,
            index_price,
            indicative_settlement_price,
            low_24h,
            market_cap,
            mark_price,
            open_24h,
            open_interest,
            last_price,
            price_to_earnings,
            last_size,
            last_settlement_date,
            shares_outstanding_weighted_adj,
            last_settlement_price,
            volume_24h,
            volume_30d,
            session_high,
            session_low,
            session_open,
            session_volume,
        )

    def __str__(self) -> str:
        return f"Ticker(symbol={self.s},timestamp_ns={self.tn},timestamp={self.ts},venue={self.ve},ask_price={self.ap},ask_size={self.as_},bid_price={self.bp},bid_size={self.bs},dividend={self.dividend},dividend_yield={self.dividend_yield},eps_adj={self.eps_adj},funding_rate={self.fr},next_funding_time={self.ft},high_24h={self.h},index_price={self.ip},indicative_settlement_price={self.isp},low_24h={self.l},market_cap={self.market_cap},mark_price={self.mp},open_24h={self.o},open_interest={self.oi},last_price={self.p},price_to_earnings={self.price_to_earnings},last_size={self.q},last_settlement_date={self.sd},shares_outstanding_weighted_adj={self.shares_outstanding_weighted_adj},last_settlement_price={self.sp},volume_24h={self.v},volume_30d={self.vm},session_high={self.xh},session_low={self.xl},session_open={self.xo},session_volume={self.xv})"

    @property
    def symbol(self) -> str:
        return self.s

    @symbol.setter
    def symbol(self, value: str) -> None:
        self.s = value

    @property
    def timestamp_ns(self) -> int:
        return self.tn

    @timestamp_ns.setter
    def timestamp_ns(self, value: int) -> None:
        self.tn = value

    @property
    def timestamp(self) -> int:
        return self.ts

    @timestamp.setter
    def timestamp(self, value: int) -> None:
        self.ts = value

    @property
    def datetime(self) -> datetime:
        """
        Convenience property to get the timestamp as a datetime object in UTC.
        """
        return datetime.fromtimestamp(self.ts, tz=timezone.utc)

    @property
    def datetime_local(self) -> datetime:
        """
        Convenience property to get the timestamp as a datetime object in local time.
        """
        return datetime.fromtimestamp(self.ts)

    @property
    def venue(self) -> str:
        return self.ve

    @venue.setter
    def venue(self, value: str) -> None:
        self.ve = value

    @property
    def ask_price(self) -> Optional[Decimal]:
        return self.ap

    @ask_price.setter
    def ask_price(self, value: Optional[Decimal]) -> None:
        self.ap = value

    @property
    def ask_size(self) -> Optional[Decimal]:
        return self.as_

    @ask_size.setter
    def ask_size(self, value: Optional[Decimal]) -> None:
        self.as_ = value

    @property
    def bid_price(self) -> Optional[Decimal]:
        return self.bp

    @bid_price.setter
    def bid_price(self, value: Optional[Decimal]) -> None:
        self.bp = value

    @property
    def bid_size(self) -> Optional[Decimal]:
        return self.bs

    @bid_size.setter
    def bid_size(self, value: Optional[Decimal]) -> None:
        self.bs = value

    @property
    def funding_rate(self) -> Optional[Decimal]:
        return self.fr

    @funding_rate.setter
    def funding_rate(self, value: Optional[Decimal]) -> None:
        self.fr = value

    @property
    def next_funding_time(self) -> Optional[datetime]:
        return self.ft

    @next_funding_time.setter
    def next_funding_time(self, value: Optional[datetime]) -> None:
        self.ft = value

    @property
    def high_24h(self) -> Optional[Decimal]:
        return self.h

    @high_24h.setter
    def high_24h(self, value: Optional[Decimal]) -> None:
        self.h = value

    @property
    def index_price(self) -> Optional[Decimal]:
        return self.ip

    @index_price.setter
    def index_price(self, value: Optional[Decimal]) -> None:
        self.ip = value

    @property
    def indicative_settlement_price(self) -> Optional[Decimal]:
        return self.isp

    @indicative_settlement_price.setter
    def indicative_settlement_price(self, value: Optional[Decimal]) -> None:
        self.isp = value

    @property
    def low_24h(self) -> Optional[Decimal]:
        return self.l

    @low_24h.setter
    def low_24h(self, value: Optional[Decimal]) -> None:
        self.l = value

    @property
    def mark_price(self) -> Optional[Decimal]:
        return self.mp

    @mark_price.setter
    def mark_price(self, value: Optional[Decimal]) -> None:
        self.mp = value

    @property
    def open_24h(self) -> Optional[Decimal]:
        return self.o

    @open_24h.setter
    def open_24h(self, value: Optional[Decimal]) -> None:
        self.o = value

    @property
    def open_interest(self) -> Optional[Decimal]:
        return self.oi

    @open_interest.setter
    def open_interest(self, value: Optional[Decimal]) -> None:
        self.oi = value

    @property
    def last_price(self) -> Optional[Decimal]:
        return self.p

    @last_price.setter
    def last_price(self, value: Optional[Decimal]) -> None:
        self.p = value

    @property
    def last_size(self) -> Optional[Decimal]:
        return self.q

    @last_size.setter
    def last_size(self, value: Optional[Decimal]) -> None:
        self.q = value

    @property
    def last_settlement_date(self) -> Optional[date]:
        return self.sd

    @last_settlement_date.setter
    def last_settlement_date(self, value: Optional[date]) -> None:
        self.sd = value

    @property
    def last_settlement_price(self) -> Optional[Decimal]:
        return self.sp

    @last_settlement_price.setter
    def last_settlement_price(self, value: Optional[Decimal]) -> None:
        self.sp = value

    @property
    def volume_24h(self) -> Optional[Decimal]:
        return self.v

    @volume_24h.setter
    def volume_24h(self, value: Optional[Decimal]) -> None:
        self.v = value

    @property
    def volume_30d(self) -> Optional[Decimal]:
        return self.vm

    @volume_30d.setter
    def volume_30d(self, value: Optional[Decimal]) -> None:
        self.vm = value

    @property
    def session_high(self) -> Optional[Decimal]:
        return self.xh

    @session_high.setter
    def session_high(self, value: Optional[Decimal]) -> None:
        self.xh = value

    @property
    def session_low(self) -> Optional[Decimal]:
        return self.xl

    @session_low.setter
    def session_low(self, value: Optional[Decimal]) -> None:
        self.xl = value

    @property
    def session_open(self) -> Optional[Decimal]:
        return self.xo

    @session_open.setter
    def session_open(self, value: Optional[Decimal]) -> None:
        self.xo = value

    @property
    def session_volume(self) -> Optional[Decimal]:
        return self.xv

    @session_volume.setter
    def session_volume(self, value: Optional[Decimal]) -> None:
        self.xv = value
