# generated by datamodel-codegen:
#   filename:  Oms/Modify.json

from __future__ import annotations

from decimal import Decimal
from typing import Annotated, Optional

from msgspec import Meta, Struct

from .. import definitions


class Modify(Struct, omit_defaults=True):
    id: Annotated[definitions.OrderId, Meta(title="order_id")]
    mid: Annotated[str, Meta(title="modify_id")]
    nid: Annotated[
        definitions.OrderId,
        Meta(
            description="The new order ID that will be assigned to the order after modification.",
            title="new_order_id",
        ),
    ]
    """
    The new order ID that will be assigned to the order after modification.
    """
    o: Annotated[definitions.ModifyStatus, Meta(title="status")]
    tn: Annotated[int, Meta(ge=0, title="recv_time_ns")]
    ts: Annotated[int, Meta(title="recv_time")]
    p: Optional[Annotated[Optional[Decimal], Meta(title="new_price")]] = None
    q: Optional[Annotated[Optional[Decimal], Meta(title="new_quantity")]] = None
    r: Optional[Annotated[Optional[str], Meta(title="reject_reason")]] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        order_id: definitions.OrderId,
        modify_id: str,
        new_order_id: definitions.OrderId,
        status: definitions.ModifyStatus,
        recv_time_ns: int,
        recv_time: int,
        new_price: Optional[Decimal] = None,
        new_quantity: Optional[Decimal] = None,
        reject_reason: Optional[str] = None,
    ):
        return cls(
            order_id,
            modify_id,
            new_order_id,
            status,
            recv_time_ns,
            recv_time,
            new_price,
            new_quantity,
            reject_reason,
        )

    def __str__(self) -> str:
        return f"Modify(order_id={self.id},modify_id={self.mid},new_order_id={self.nid},status={self.o},recv_time_ns={self.tn},recv_time={self.ts},new_price={self.p},new_quantity={self.q},reject_reason={self.r})"

    @property
    def order_id(self) -> definitions.OrderId:
        return self.id

    @order_id.setter
    def order_id(self, value: definitions.OrderId) -> None:
        self.id = value

    @property
    def modify_id(self) -> str:
        return self.mid

    @modify_id.setter
    def modify_id(self, value: str) -> None:
        self.mid = value

    @property
    def new_order_id(self) -> definitions.OrderId:
        return self.nid

    @new_order_id.setter
    def new_order_id(self, value: definitions.OrderId) -> None:
        self.nid = value

    @property
    def status(self) -> definitions.ModifyStatus:
        return self.o

    @status.setter
    def status(self, value: definitions.ModifyStatus) -> None:
        self.o = value

    @property
    def recv_time_ns(self) -> int:
        return self.tn

    @recv_time_ns.setter
    def recv_time_ns(self, value: int) -> None:
        self.tn = value

    @property
    def recv_time(self) -> int:
        return self.ts

    @recv_time.setter
    def recv_time(self, value: int) -> None:
        self.ts = value

    @property
    def new_price(self) -> Optional[Decimal]:
        return self.p

    @new_price.setter
    def new_price(self, value: Optional[Decimal]) -> None:
        self.p = value

    @property
    def new_quantity(self) -> Optional[Decimal]:
        return self.q

    @new_quantity.setter
    def new_quantity(self, value: Optional[Decimal]) -> None:
        self.q = value

    @property
    def reject_reason(self) -> Optional[str]:
        return self.r

    @reject_reason.setter
    def reject_reason(self, value: Optional[str]) -> None:
        self.r = value
