# generated by datamodel-codegen:
#   filename:  Oms/ModifyOrderRequest.json

from __future__ import annotations
from architect_py.grpc.models.Oms.Modify import Modify

from decimal import Decimal
from typing import Annotated, Optional

from msgspec import Meta, Struct

from .. import definitions


class ModifyOrderRequest(Struct, omit_defaults=True):
    """
    The ModifyOrderRequest will cause the order to get a new OrderId
    """

    id: Annotated[definitions.OrderId, Meta(title="order_id")]
    mid: Optional[
        Annotated[
            Optional[str],
            Meta(
                description="If not specified, one will be generated for you; note, in that case, you won't know for sure if the specific request went through.",
                title="modify_id",
            ),
        ]
    ] = None
    """
    If not specified, one will be generated for you; note, in that case, you won't know for sure if the specific request went through.
    """
    p: Optional[Annotated[Optional[Decimal], Meta(title="new_price")]] = None
    q: Optional[Annotated[Optional[Decimal], Meta(title="new_quantity")]] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        order_id: definitions.OrderId,
        modify_id: Optional[str] = None,
        new_price: Optional[Decimal] = None,
        new_quantity: Optional[Decimal] = None,
    ):
        return cls(
            order_id,
            modify_id,
            new_price,
            new_quantity,
        )

    def __str__(self) -> str:
        return f"ModifyOrderRequest(order_id={self.id},modify_id={self.mid},new_price={self.p},new_quantity={self.q})"

    @property
    def order_id(self) -> definitions.OrderId:
        return self.id

    @order_id.setter
    def order_id(self, value: definitions.OrderId) -> None:
        self.id = value

    @property
    def modify_id(self) -> Optional[str]:
        return self.mid

    @modify_id.setter
    def modify_id(self, value: Optional[str]) -> None:
        self.mid = value

    @property
    def new_price(self) -> Optional[Decimal]:
        return self.p

    @new_price.setter
    def new_price(self, value: Optional[Decimal]) -> None:
        self.p = value

    @property
    def new_quantity(self) -> Optional[Decimal]:
        return self.q

    @new_quantity.setter
    def new_quantity(self, value: Optional[Decimal]) -> None:
        self.q = value

    @staticmethod
    def get_response_type():
        return Modify

    @staticmethod
    def get_unannotated_response_type():
        return Modify

    @staticmethod
    def get_route() -> str:
        return "/json.architect.Oms/ModifyOrder"

    @staticmethod
    def get_rpc_method():
        return "unary"
