# generated by datamodel-codegen:
#   filename:  OptionsMarketdata/OptionsContract.json

from __future__ import annotations

from datetime import date
from decimal import Decimal
from typing import Optional

from msgspec import Struct

from .. import definitions
from ..Marketdata.Ticker import Ticker


class OptionsContract(Struct, omit_defaults=True):
    expiration: date
    put_or_call: definitions.PutOrCall
    strike: Decimal
    ticker: Ticker
    underlying: str
    in_the_money: Optional[bool] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        expiration: date,
        put_or_call: definitions.PutOrCall,
        strike: Decimal,
        ticker: Ticker,
        underlying: str,
        in_the_money: Optional[bool] = None,
    ):
        return cls(
            expiration,
            put_or_call,
            strike,
            ticker,
            underlying,
            in_the_money,
        )

    def __str__(self) -> str:
        return f"OptionsContract(expiration={self.expiration},put_or_call={self.put_or_call},strike={self.strike},ticker={self.ticker},underlying={self.underlying},in_the_money={self.in_the_money})"
