# generated by datamodel-codegen:
#   filename:  Orderflow/OrderflowRequest.json

from __future__ import annotations
from architect_py.grpc.models.Orderflow.Orderflow import (
    Orderflow,
    OrderPending,
    TaggedOrderAck,
    TaggedOrderReject,
    TaggedOrderOut,
    OrderReconciledOut,
    TaggedOrderStale,
    CancelPending,
    TaggedCancelReject,
    TaggedOrderCanceling,
    TaggedOrderCanceled,
    TaggedModifyPending,
    TaggedModifyReject,
    TaggedOrderModified,
    TaggedFill,
    TaggedAberrantFill,
)

from typing import Annotated, Union

from msgspec import Meta

from ..Oms.BatchCancelOrdersRequest import BatchCancelOrdersRequest
from ..Oms.CancelAllOrdersRequest import CancelAllOrdersRequest
from ..Oms.CancelOrderRequest import CancelOrderRequest
from ..Oms.ModifyOrderRequest import ModifyOrderRequest
from ..Oms.PlaceBatchOrderRequest import PlaceBatchOrderRequest
from ..Oms.PlaceOrderRequest import PlaceOrderRequest


class PlaceOrder(PlaceOrderRequest, omit_defaults=True, tag_field="t", tag="p"):
    pass


class PlaceBatchOrder(
    PlaceBatchOrderRequest, omit_defaults=True, tag_field="t", tag="pp"
):
    pass


class CancelOrder(CancelOrderRequest, omit_defaults=True, tag_field="t", tag="x"):
    pass


class CancelAllOrders(
    CancelAllOrdersRequest, omit_defaults=True, tag_field="t", tag="xo"
):
    pass


class BatchCancelOrders(
    BatchCancelOrdersRequest, omit_defaults=True, tag_field="t", tag="xb"
):
    pass


class ModifyOrder(
    ModifyOrderRequest, omit_defaults=True, tag_field="t", tag="modify_order"
):
    pass


OrderflowRequest = Annotated[
    Union[
        PlaceOrder,
        PlaceBatchOrder,
        CancelOrder,
        CancelAllOrders,
        BatchCancelOrders,
        ModifyOrder,
    ],
    Meta(title="OrderflowRequest"),
]

OrderflowRequest_rpc_method = "duplex_stream"
UnannotatedOrderflowRequest = (
    PlaceOrder
    | PlaceBatchOrder
    | CancelOrder
    | CancelAllOrders
    | BatchCancelOrders
    | ModifyOrder
)
OrderflowRequestResponseType = Orderflow
OrderflowRequestUnannotatedResponseType = (
    OrderPending
    | TaggedOrderAck
    | TaggedOrderReject
    | TaggedOrderOut
    | OrderReconciledOut
    | TaggedOrderStale
    | CancelPending
    | TaggedCancelReject
    | TaggedOrderCanceling
    | TaggedOrderCanceled
    | TaggedModifyPending
    | TaggedModifyReject
    | TaggedOrderModified
    | TaggedFill
    | TaggedAberrantFill
)
OrderflowRequest_route = "/json.architect.Orderflow/Orderflow"
