# generated by datamodel-codegen:
#   filename:  Orderflow/SubscribeOrderflowRequest.json

from __future__ import annotations
from architect_py.grpc.models.Orderflow.Orderflow import (
    Orderflow,
    OrderPending,
    TaggedOrderAck,
    TaggedOrderReject,
    TaggedOrderOut,
    OrderReconciledOut,
    TaggedOrderStale,
    CancelPending,
    TaggedCancelReject,
    TaggedOrderCanceling,
    TaggedOrderCanceled,
    TaggedModifyPending,
    TaggedModifyReject,
    TaggedOrderModified,
    TaggedFill,
    TaggedAberrantFill,
)

from typing import Optional

from msgspec import Struct

from .. import definitions


class SubscribeOrderflowRequest(Struct, omit_defaults=True):
    """
    Subscribe/listen to orderflow events.
    """

    account: Optional[definitions.AccountIdOrName] = None
    execution_venue: Optional[str] = None
    trader: Optional[definitions.TraderIdOrEmail] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account: Optional[definitions.AccountIdOrName] = None,
        execution_venue: Optional[str] = None,
        trader: Optional[definitions.TraderIdOrEmail] = None,
    ):
        return cls(
            account,
            execution_venue,
            trader,
        )

    def __str__(self) -> str:
        return f"SubscribeOrderflowRequest(account={self.account},execution_venue={self.execution_venue},trader={self.trader})"

    @staticmethod
    def get_response_type():
        return Orderflow

    @staticmethod
    def get_unannotated_response_type():
        return (
            OrderPending
            | TaggedOrderAck
            | TaggedOrderReject
            | TaggedOrderOut
            | OrderReconciledOut
            | TaggedOrderStale
            | CancelPending
            | TaggedCancelReject
            | TaggedOrderCanceling
            | TaggedOrderCanceled
            | TaggedModifyPending
            | TaggedModifyReject
            | TaggedOrderModified
            | TaggedFill
            | TaggedAberrantFill
        )

    @staticmethod
    def get_route() -> str:
        return "/json.architect.Orderflow/SubscribeOrderflow"

    @staticmethod
    def get_rpc_method():
        return "stream"
