# generated by datamodel-codegen:
#   filename:  Symbology/SymbologySnapshot.json

from __future__ import annotations

from typing import Annotated, Dict, Optional

from msgspec import Meta, Struct

from .. import definitions


class SymbologySnapshot(Struct, omit_defaults=True):
    """
    Unique sequence id and number.
    """

    execution_info: Dict[str, Dict[str, definitions.ExecutionInfo]]
    options_series: Dict[str, definitions.OptionsSeriesInfo]
    products: Dict[str, definitions.ProductInfo]
    sid: Annotated[int, Meta(ge=0, title="sequence_id")]
    sn: Annotated[int, Meta(ge=0, title="sequence_number")]
    product_aliases: Optional[Dict[str, Dict[str, str]]] = {}
    product_catalog: Optional[Dict[str, Dict[str, definitions.ProductCatalogInfo]]] = {}

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        execution_info: Dict[str, Dict[str, definitions.ExecutionInfo]],
        options_series: Dict[str, definitions.OptionsSeriesInfo],
        products: Dict[str, definitions.ProductInfo],
        sequence_id: int,
        sequence_number: int,
        product_aliases: Optional[Dict[str, Dict[str, str]]] = {},
        product_catalog: Optional[
            Dict[str, Dict[str, definitions.ProductCatalogInfo]]
        ] = {},
    ):
        return cls(
            execution_info,
            options_series,
            products,
            sequence_id,
            sequence_number,
            product_aliases,
            product_catalog,
        )

    def __str__(self) -> str:
        return f"SymbologySnapshot(execution_info={self.execution_info},options_series={self.options_series},products={self.products},sequence_id={self.sid},sequence_number={self.sn},product_aliases={self.product_aliases},product_catalog={self.product_catalog})"

    @property
    def sequence_id(self) -> int:
        return self.sid

    @sequence_id.setter
    def sequence_id(self, value: int) -> None:
        self.sid = value

    @property
    def sequence_number(self) -> int:
        return self.sn

    @sequence_number.setter
    def sequence_number(self, value: int) -> None:
        self.sn = value
