# generated by datamodel-codegen:
#   filename:  definitions.json

from __future__ import annotations
from architect_py.common_types import OrderDir
from datetime import datetime, timezone

from datetime import date, datetime, time
from decimal import Decimal
from enum import Enum
from typing import Annotated, Dict, List, Literal, Optional, Union

from msgspec import Meta, Struct

from .Oms.Order import Order


class AccountHistoryGranularity(str, Enum):
    FiveMinutes = "FiveMinutes"
    Hourly = "Hourly"
    Daily = "Daily"


AccountIdOrName = str


class AccountPosition(Struct, omit_defaults=True):
    quantity: Decimal
    break_even_price: Optional[Decimal] = None
    cost_basis: Optional[
        Annotated[
            Optional[Decimal], Meta(description="Cost basis of the position, if known.")
        ]
    ] = None
    """
    Cost basis of the position, if known.
    """
    liquidation_price: Optional[Decimal] = None
    trade_time: Optional[
        Annotated[
            Optional[datetime],
            Meta(description="NB: the meaning of this field varies by reporting venue"),
        ]
    ] = None
    """
    NB: the meaning of this field varies by reporting venue
    """
    unrealized_pnl: Optional[
        Annotated[
            Optional[Decimal],
            Meta(description="Unrealized PNL of the position, if known."),
        ]
    ] = None
    """
    Unrealized PNL of the position, if known.
    """

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        quantity: Decimal,
        break_even_price: Optional[Decimal] = None,
        cost_basis: Optional[Decimal] = None,
        liquidation_price: Optional[Decimal] = None,
        trade_time: Optional[datetime] = None,
        unrealized_pnl: Optional[Decimal] = None,
    ):
        return cls(
            quantity,
            break_even_price,
            cost_basis,
            liquidation_price,
            trade_time,
            unrealized_pnl,
        )

    def __str__(self) -> str:
        return f"AccountPosition(quantity={self.quantity},break_even_price={self.break_even_price},cost_basis={self.cost_basis},liquidation_price={self.liquidation_price},trade_time={self.trade_time},unrealized_pnl={self.unrealized_pnl})"


class AccountStatistics(Struct, omit_defaults=True):
    cash_excess: Optional[
        Annotated[Optional[Decimal], Meta(description="Cash available to withdraw.")]
    ] = None
    """
    Cash available to withdraw.
    """
    equity: Optional[
        Annotated[
            Optional[Decimal],
            Meta(description="Total account equity; net liquidation value."),
        ]
    ] = None
    """
    Total account equity; net liquidation value.
    """
    position_margin: Optional[
        Annotated[
            Optional[Decimal],
            Meta(description="Margin requirement based on current positions only."),
        ]
    ] = None
    """
    Margin requirement based on current positions only.
    """
    purchasing_power: Optional[
        Annotated[
            Optional[Decimal],
            Meta(
                description="Total purchasing power; post-multiplied. (e.g. for cash margin account could be 2x available cash)"
            ),
        ]
    ] = None
    """
    Total purchasing power; post-multiplied. (e.g. for cash margin account could be 2x available cash)
    """
    realized_pnl: Optional[Decimal] = None
    total_margin: Optional[
        Annotated[
            Optional[Decimal],
            Meta(
                description="Margin requirement calculated for worst-case based on open positions and working orders."
            ),
        ]
    ] = None
    """
    Margin requirement calculated for worst-case based on open positions and working orders.
    """
    unrealized_pnl: Optional[Decimal] = None
    yesterday_equity: Optional[
        Annotated[
            Optional[Decimal], Meta(description="Yesterday total account equity.")
        ]
    ] = None
    """
    Yesterday total account equity.
    """

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        cash_excess: Optional[Decimal] = None,
        equity: Optional[Decimal] = None,
        position_margin: Optional[Decimal] = None,
        purchasing_power: Optional[Decimal] = None,
        realized_pnl: Optional[Decimal] = None,
        total_margin: Optional[Decimal] = None,
        unrealized_pnl: Optional[Decimal] = None,
        yesterday_equity: Optional[Decimal] = None,
    ):
        return cls(
            cash_excess,
            equity,
            position_margin,
            purchasing_power,
            realized_pnl,
            total_margin,
            unrealized_pnl,
            yesterday_equity,
        )

    def __str__(self) -> str:
        return f"AccountStatistics(cash_excess={self.cash_excess},equity={self.equity},position_margin={self.position_margin},purchasing_power={self.purchasing_power},realized_pnl={self.realized_pnl},total_margin={self.total_margin},unrealized_pnl={self.unrealized_pnl},yesterday_equity={self.yesterday_equity})"


class AlgoOrderStatus(int, Enum):
    Working = 1
    Rejected = 2
    Paused = 63
    Stopped = 127


class CancelStatus(int, Enum):
    Pending = 0
    Acked = 1
    Rejected = 2
    Out = 127


class CandleWidth(int, Enum):
    OneSecond = 1
    FiveSecond = 5
    OneMinute = 60
    TwoMinute = 120
    ThreeMinute = 180
    FifteenMinute = 900
    OneHour = 3600
    OneDay = 86400


class ConnectionStatus(Struct, omit_defaults=True):
    connected: bool
    last_heartbeat: Annotated[int, Meta(description="UNIX epoch time or -1 for never")]
    """
    UNIX epoch time or -1 for never
    """
    last_heartbeat_stale_threshold: Annotated[
        int, Meta(description="Stale threshold in seconds, or -1 for never stale")
    ]
    """
    Stale threshold in seconds, or -1 for never stale
    """
    logged_in: Optional[
        Annotated[
            Optional[bool], Meta(description="Not applicable to connection if None")
        ]
    ] = None
    """
    Not applicable to connection if None
    """

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        connected: bool,
        last_heartbeat: int,
        last_heartbeat_stale_threshold: int,
        logged_in: Optional[bool] = None,
    ):
        return cls(
            connected,
            last_heartbeat,
            last_heartbeat_stale_threshold,
            logged_in,
        )

    def __str__(self) -> str:
        return f"ConnectionStatus(connected={self.connected},last_heartbeat={self.last_heartbeat},last_heartbeat_stale_threshold={self.last_heartbeat_stale_threshold},logged_in={self.logged_in})"


class CptyLogoutRequest(Struct, omit_defaults=True):
    pass

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
    ):
        return cls()

    def __str__(self) -> str:
        return f"CptyLogoutRequest()"


DateTimeOrUtc = datetime


class Deposit(Struct, omit_defaults=True):
    account: str
    amount: Decimal
    description: str
    timestamp: datetime

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account: str,
        amount: Decimal,
        description: str,
        timestamp: datetime,
    ):
        return cls(
            account,
            amount,
            description,
            timestamp,
        )

    def __str__(self) -> str:
        return f"Deposit(account={self.account},amount={self.amount},description={self.description},timestamp={self.timestamp})"


class HealthMetric(Struct, omit_defaults=True):
    timestamp: int
    value: float
    should_be_greater_than: Optional[float] = None
    should_be_greater_than_or_equal_to: Optional[float] = None
    should_be_less_than: Optional[float] = None
    should_be_less_than_or_equal_to: Optional[float] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        timestamp: int,
        value: float,
        should_be_greater_than: Optional[float] = None,
        should_be_greater_than_or_equal_to: Optional[float] = None,
        should_be_less_than: Optional[float] = None,
        should_be_less_than_or_equal_to: Optional[float] = None,
    ):
        return cls(
            timestamp,
            value,
            should_be_greater_than,
            should_be_greater_than_or_equal_to,
            should_be_less_than,
            should_be_less_than_or_equal_to,
        )

    def __str__(self) -> str:
        return f"HealthMetric(timestamp={self.timestamp},value={self.value},should_be_greater_than={self.should_be_greater_than},should_be_greater_than_or_equal_to={self.should_be_greater_than_or_equal_to},should_be_less_than={self.should_be_less_than},should_be_less_than_or_equal_to={self.should_be_less_than_or_equal_to})"


class HealthStatus(str, Enum):
    UNKNOWN = "UNKNOWN"
    SERVING = "SERVING"
    NOT_SERVING = "NOT_SERVING"
    SERVICE_UNKNOWN = "SERVICE_UNKNOWN"


Ask = List[Decimal]


Bid = List[Decimal]


class L2BookDiff(Struct, omit_defaults=True):
    """
    Unique sequence id and number.
    """

    a: Annotated[
        List[Ask],
        Meta(
            description="Set of (price, level) updates. If zero, the price level has been removed from the book.",
            title="asks",
        ),
    ]
    """
    Set of (price, level) updates. If zero, the price level has been removed from the book.
    """
    b: Annotated[
        List[Bid],
        Meta(
            description="Set of (price, level) updates. If zero, the price level has been removed from the book.",
            title="bids",
        ),
    ]
    """
    Set of (price, level) updates. If zero, the price level has been removed from the book.
    """
    sid: Annotated[int, Meta(ge=0, title="sequence_id")]
    sn: Annotated[int, Meta(ge=0, title="sequence_number")]
    tn: Annotated[int, Meta(ge=0, title="timestamp_ns")]
    ts: Annotated[int, Meta(title="timestamp")]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        asks: List[Ask],
        bids: List[Bid],
        sequence_id: int,
        sequence_number: int,
        timestamp_ns: int,
        timestamp: int,
    ):
        return cls(
            asks,
            bids,
            sequence_id,
            sequence_number,
            timestamp_ns,
            timestamp,
        )

    def __str__(self) -> str:
        return f"L2BookDiff(asks={self.a},bids={self.b},sequence_id={self.sid},sequence_number={self.sn},timestamp_ns={self.tn},timestamp={self.ts})"

    @property
    def asks(self) -> List[Ask]:
        return self.a

    @asks.setter
    def asks(self, value: List[Ask]) -> None:
        self.a = value

    @property
    def bids(self) -> List[Bid]:
        return self.b

    @bids.setter
    def bids(self, value: List[Bid]) -> None:
        self.b = value

    @property
    def sequence_id(self) -> int:
        return self.sid

    @sequence_id.setter
    def sequence_id(self, value: int) -> None:
        self.sid = value

    @property
    def sequence_number(self) -> int:
        return self.sn

    @sequence_number.setter
    def sequence_number(self, value: int) -> None:
        self.sn = value

    @property
    def timestamp_ns(self) -> int:
        return self.tn

    @timestamp_ns.setter
    def timestamp_ns(self, value: int) -> None:
        self.tn = value

    @property
    def timestamp(self) -> int:
        return self.ts

    @timestamp.setter
    def timestamp(self, value: int) -> None:
        self.ts = value

    @property
    def datetime(self) -> datetime:
        """
        Convenience property to get the timestamp as a datetime object in UTC.
        """
        return datetime.fromtimestamp(self.ts, tz=timezone.utc)

    @property
    def datetime_local(self) -> datetime:
        """
        Convenience property to get the timestamp as a datetime object in local time.
        """
        return datetime.fromtimestamp(self.ts)


class MarginCall(Struct, omit_defaults=True):
    account_number: str
    call_amount: Decimal
    call_type: str
    correspondent_id: str
    description: str
    office: str
    remarks: str
    satisfied_amount: Decimal
    status: str
    create_date: Optional[datetime] = None
    due_date: Optional[datetime] = None
    system_date: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account_number: str,
        call_amount: Decimal,
        call_type: str,
        correspondent_id: str,
        description: str,
        office: str,
        remarks: str,
        satisfied_amount: Decimal,
        status: str,
        create_date: Optional[datetime] = None,
        due_date: Optional[datetime] = None,
        system_date: Optional[str] = None,
    ):
        return cls(
            account_number,
            call_amount,
            call_type,
            correspondent_id,
            description,
            office,
            remarks,
            satisfied_amount,
            status,
            create_date,
            due_date,
            system_date,
        )

    def __str__(self) -> str:
        return f"MarginCall(account_number={self.account_number},call_amount={self.call_amount},call_type={self.call_type},correspondent_id={self.correspondent_id},description={self.description},office={self.office},remarks={self.remarks},satisfied_amount={self.satisfied_amount},status={self.status},create_date={self.create_date},due_date={self.due_date},system_date={self.system_date})"


class ModifyStatus(int, Enum):
    Pending = 0
    Acked = 1
    Rejected = 2
    Out = 127


class OptionsTransaction(Struct, omit_defaults=True):
    clearing_firm_account: str
    quantity: Decimal
    timestamp: datetime
    tradable_product: str
    transaction_type: str
    price: Optional[Decimal] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        clearing_firm_account: str,
        quantity: Decimal,
        timestamp: datetime,
        tradable_product: str,
        transaction_type: str,
        price: Optional[Decimal] = None,
    ):
        return cls(
            clearing_firm_account,
            quantity,
            timestamp,
            tradable_product,
            transaction_type,
            price,
        )

    def __str__(self) -> str:
        return f"OptionsTransaction(clearing_firm_account={self.clearing_firm_account},quantity={self.quantity},timestamp={self.timestamp},tradable_product={self.tradable_product},transaction_type={self.transaction_type},price={self.price})"


OrderId = Annotated[
    str, Meta(description="System-unique, persistent order identifiers")
]


class OrderModified(Struct, omit_defaults=True):
    mid: str
    n: OrderId
    o: OrderId

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        mid: str,
        n: OrderId,
        o: OrderId,
    ):
        return cls(
            mid,
            n,
            o,
        )

    def __str__(self) -> str:
        return f"OrderModified(mid={self.mid},n={self.n},o={self.o})"


class OrderOut(Struct, omit_defaults=True):
    id: OrderId

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        id: OrderId,
    ):
        return cls(
            id,
        )

    def __str__(self) -> str:
        return f"OrderOut(id={self.id})"


class OrderRejectReason(str, Enum):
    DuplicateOrderId = "DuplicateOrderId"
    NotAuthorized = "NotAuthorized"
    NoExecutionVenue = "NoExecutionVenue"
    NoAccount = "NoAccount"
    NoCpty = "NoCpty"
    UnsupportedOrderType = "UnsupportedOrderType"
    UnsupportedExecutionVenue = "UnsupportedExecutionVenue"
    InsufficientCash = "InsufficientCash"
    InsufficientMargin = "InsufficientMargin"
    NotEasyToBorrow = "NotEasyToBorrow"
    InvalidOrder = "InvalidOrder"
    Unknown = "Unknown"


class OrderSource(int, Enum):
    API = 0
    GUI = 1
    Algo = 2
    Reconciled = 3
    CLI = 4
    Telegram = 5
    Other = 255


class OrderStale(Struct, omit_defaults=True):
    id: OrderId

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        id: OrderId,
    ):
        return cls(
            id,
        )

    def __str__(self) -> str:
        return f"OrderStale(id={self.id})"


class OrderStatus(int, Enum):
    Pending = 0
    Open = 1
    Rejected = 2
    Out = 127
    Canceling = 128
    Canceled = 129
    ReconciledOut = 130
    ModifiedOut = 131
    Stale = 254
    Unknown = 255


class OrderType(str, Enum):
    MARKET = "MARKET"
    LIMIT = "LIMIT"
    STOP_LOSS_LIMIT = "STOP_LOSS_LIMIT"
    TAKE_PROFIT_LIMIT = "TAKE_PROFIT_LIMIT"
    BRACKET = "BRACKET"


class ProductCatalogInfo(Struct, omit_defaults=True):
    """
    Loosely normalized information about exchange products; used to seed symbology loaders and populate extended product info;

    Symbology loaders will use catalog fields to augment and/or cross-check any other load source.

    Numeric data is very rough and not at all precise in time. These fields, such as eps_adj, dividend_yield, etc. should be considered almost cosmetic.  They can still be useful for rough purposes.
    """

    exchange: str
    exchange_product: Annotated[str, Meta(description="Could be anything really")]
    """
    Could be anything really
    """
    as_of_date: Optional[date] = None
    category: Optional[str] = None
    cqg_contract_symbol: Optional[str] = None
    dividend: Optional[Decimal] = None
    dividend_yield: Optional[Decimal] = None
    eps_adj: Optional[
        Annotated[
            Optional[Decimal],
            Meta(description="For stocks, adjusted earnings per share"),
        ]
    ] = None
    """
    For stocks, adjusted earnings per share
    """
    info_url: Optional[
        Annotated[Optional[str], Meta(description="URL to more product info")]
    ] = None
    """
    URL to more product info
    """
    last_updated: Optional[datetime] = None
    long_description: Optional[str] = None
    market_cap: Optional[Decimal] = None
    multiplier: Optional[
        Annotated[
            Optional[Decimal],
            Meta(description="For derivatives contracts, the multiplier"),
        ]
    ] = None
    """
    For derivatives contracts, the multiplier
    """
    price_display_format: Optional[str] = None
    price_to_earnings: Optional[Decimal] = None
    quote_currency: Optional[str] = None
    schedule_description: Optional[str] = None
    settle_method: Optional[str] = None
    shared_outstanding_weighted_adj: Optional[Decimal] = None
    short_description: Optional[
        Annotated[
            Optional[str],
            Meta(
                description="Short description of the product, suitable for display in a bubble, for example"
            ),
        ]
    ] = None
    """
    Short description of the product, suitable for display in a bubble, for example
    """
    sub_category: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        exchange: str,
        exchange_product: str,
        as_of_date: Optional[date] = None,
        category: Optional[str] = None,
        cqg_contract_symbol: Optional[str] = None,
        dividend: Optional[Decimal] = None,
        dividend_yield: Optional[Decimal] = None,
        eps_adj: Optional[Decimal] = None,
        info_url: Optional[str] = None,
        last_updated: Optional[datetime] = None,
        long_description: Optional[str] = None,
        market_cap: Optional[Decimal] = None,
        multiplier: Optional[Decimal] = None,
        price_display_format: Optional[str] = None,
        price_to_earnings: Optional[Decimal] = None,
        quote_currency: Optional[str] = None,
        schedule_description: Optional[str] = None,
        settle_method: Optional[str] = None,
        shared_outstanding_weighted_adj: Optional[Decimal] = None,
        short_description: Optional[str] = None,
        sub_category: Optional[str] = None,
    ):
        return cls(
            exchange,
            exchange_product,
            as_of_date,
            category,
            cqg_contract_symbol,
            dividend,
            dividend_yield,
            eps_adj,
            info_url,
            last_updated,
            long_description,
            market_cap,
            multiplier,
            price_display_format,
            price_to_earnings,
            quote_currency,
            schedule_description,
            settle_method,
            shared_outstanding_weighted_adj,
            short_description,
            sub_category,
        )

    def __str__(self) -> str:
        return f"ProductCatalogInfo(exchange={self.exchange},exchange_product={self.exchange_product},as_of_date={self.as_of_date},category={self.category},cqg_contract_symbol={self.cqg_contract_symbol},dividend={self.dividend},dividend_yield={self.dividend_yield},eps_adj={self.eps_adj},info_url={self.info_url},last_updated={self.last_updated},long_description={self.long_description},market_cap={self.market_cap},multiplier={self.multiplier},price_display_format={self.price_display_format},price_to_earnings={self.price_to_earnings},quote_currency={self.quote_currency},schedule_description={self.schedule_description},settle_method={self.settle_method},shared_outstanding_weighted_adj={self.shared_outstanding_weighted_adj},short_description={self.short_description},sub_category={self.sub_category})"


class PutOrCall(str, Enum):
    P = "P"
    C = "C"


class RqdAccountStatistics(Struct, omit_defaults=True):
    account_number: str
    account_type: Optional[str] = None
    as_of_date: Optional[str] = None
    available_cash_balance: Optional[Decimal] = None
    cash_available_for_withdrawal: Optional[Decimal] = None
    cumulative_day_trade_pnl: Optional[Decimal] = None
    day_trading_buying_power: Optional[Decimal] = None
    day_trading_buying_power_high_water_mark: Optional[Decimal] = None
    day_trading_buying_power_maintenance_margin_multiplier: Optional[Decimal] = None
    day_trading_house_minimum_equity_margin_call_amount: Optional[Decimal] = None
    day_trading_margin_call_amount: Optional[Decimal] = None
    day_trading_minimum_equity_margin_call_amount: Optional[Decimal] = None
    excess_sma_amount: Optional[Decimal] = None
    house_initial_margin_requirement_adjustment_factor: Optional[Decimal] = None
    house_margin_call_amount: Optional[Decimal] = None
    house_margin_requirement: Optional[Decimal] = None
    house_margin_requirement_adjustment_factor: Optional[Decimal] = None
    is_day_trader: Optional[str] = None
    maintenance_margin_requirement: Optional[Decimal] = None
    margin_call_amount: Optional[Decimal] = None
    marginable_equity: Optional[Decimal] = None
    market_value_adjustment_factor: Optional[Decimal] = None
    number_open_day_trading_margin_calls: Optional[Decimal] = None
    option_only_maintenance_margin_requirement: Optional[Decimal] = None
    option_trade_date_short_market_value: Optional[Decimal] = None
    overall_current_sma_balance: Optional[Decimal] = None
    overnight_buying_power: Optional[Decimal] = None
    reg_t_initial_margin_requirement: Optional[Decimal] = None
    reg_t_maintenance_margin_requirement_adjustment_factor: Optional[str] = None
    reg_t_margin_call_amount: Optional[Decimal] = None
    settlement_date_cash_balance: Optional[Decimal] = None
    settlement_date_long_market_value: Optional[Decimal] = None
    settlement_date_option_long_market_value: Optional[Decimal] = None
    settlement_date_option_short_market_value: Optional[Decimal] = None
    settlement_date_short_market_value: Optional[Decimal] = None
    start_of_day_day_trading_buying_power: Optional[Decimal] = None
    start_of_day_day_trading_buying_power_margin_call_amount: Optional[Decimal] = None
    start_of_day_house_margin_call_amount: Optional[Decimal] = None
    start_of_day_maintenance_margin_call_amount: Optional[Decimal] = None
    start_of_day_reg_t_margin_call_amount: Optional[Decimal] = None
    strategy_based_relief_adjustment_factor: Optional[Decimal] = None
    total_equity: Optional[Decimal] = None
    trade_date_cash_balance: Optional[Decimal] = None
    trade_date_option_long_market_value: Optional[Decimal] = None
    trade_date_total_long_market_value: Optional[Decimal] = None
    trade_date_total_short_market_value: Optional[Decimal] = None
    usable_sma_balance: Optional[Decimal] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account_number: str,
        account_type: Optional[str] = None,
        as_of_date: Optional[str] = None,
        available_cash_balance: Optional[Decimal] = None,
        cash_available_for_withdrawal: Optional[Decimal] = None,
        cumulative_day_trade_pnl: Optional[Decimal] = None,
        day_trading_buying_power: Optional[Decimal] = None,
        day_trading_buying_power_high_water_mark: Optional[Decimal] = None,
        day_trading_buying_power_maintenance_margin_multiplier: Optional[
            Decimal
        ] = None,
        day_trading_house_minimum_equity_margin_call_amount: Optional[Decimal] = None,
        day_trading_margin_call_amount: Optional[Decimal] = None,
        day_trading_minimum_equity_margin_call_amount: Optional[Decimal] = None,
        excess_sma_amount: Optional[Decimal] = None,
        house_initial_margin_requirement_adjustment_factor: Optional[Decimal] = None,
        house_margin_call_amount: Optional[Decimal] = None,
        house_margin_requirement: Optional[Decimal] = None,
        house_margin_requirement_adjustment_factor: Optional[Decimal] = None,
        is_day_trader: Optional[str] = None,
        maintenance_margin_requirement: Optional[Decimal] = None,
        margin_call_amount: Optional[Decimal] = None,
        marginable_equity: Optional[Decimal] = None,
        market_value_adjustment_factor: Optional[Decimal] = None,
        number_open_day_trading_margin_calls: Optional[Decimal] = None,
        option_only_maintenance_margin_requirement: Optional[Decimal] = None,
        option_trade_date_short_market_value: Optional[Decimal] = None,
        overall_current_sma_balance: Optional[Decimal] = None,
        overnight_buying_power: Optional[Decimal] = None,
        reg_t_initial_margin_requirement: Optional[Decimal] = None,
        reg_t_maintenance_margin_requirement_adjustment_factor: Optional[str] = None,
        reg_t_margin_call_amount: Optional[Decimal] = None,
        settlement_date_cash_balance: Optional[Decimal] = None,
        settlement_date_long_market_value: Optional[Decimal] = None,
        settlement_date_option_long_market_value: Optional[Decimal] = None,
        settlement_date_option_short_market_value: Optional[Decimal] = None,
        settlement_date_short_market_value: Optional[Decimal] = None,
        start_of_day_day_trading_buying_power: Optional[Decimal] = None,
        start_of_day_day_trading_buying_power_margin_call_amount: Optional[
            Decimal
        ] = None,
        start_of_day_house_margin_call_amount: Optional[Decimal] = None,
        start_of_day_maintenance_margin_call_amount: Optional[Decimal] = None,
        start_of_day_reg_t_margin_call_amount: Optional[Decimal] = None,
        strategy_based_relief_adjustment_factor: Optional[Decimal] = None,
        total_equity: Optional[Decimal] = None,
        trade_date_cash_balance: Optional[Decimal] = None,
        trade_date_option_long_market_value: Optional[Decimal] = None,
        trade_date_total_long_market_value: Optional[Decimal] = None,
        trade_date_total_short_market_value: Optional[Decimal] = None,
        usable_sma_balance: Optional[Decimal] = None,
    ):
        return cls(
            account_number,
            account_type,
            as_of_date,
            available_cash_balance,
            cash_available_for_withdrawal,
            cumulative_day_trade_pnl,
            day_trading_buying_power,
            day_trading_buying_power_high_water_mark,
            day_trading_buying_power_maintenance_margin_multiplier,
            day_trading_house_minimum_equity_margin_call_amount,
            day_trading_margin_call_amount,
            day_trading_minimum_equity_margin_call_amount,
            excess_sma_amount,
            house_initial_margin_requirement_adjustment_factor,
            house_margin_call_amount,
            house_margin_requirement,
            house_margin_requirement_adjustment_factor,
            is_day_trader,
            maintenance_margin_requirement,
            margin_call_amount,
            marginable_equity,
            market_value_adjustment_factor,
            number_open_day_trading_margin_calls,
            option_only_maintenance_margin_requirement,
            option_trade_date_short_market_value,
            overall_current_sma_balance,
            overnight_buying_power,
            reg_t_initial_margin_requirement,
            reg_t_maintenance_margin_requirement_adjustment_factor,
            reg_t_margin_call_amount,
            settlement_date_cash_balance,
            settlement_date_long_market_value,
            settlement_date_option_long_market_value,
            settlement_date_option_short_market_value,
            settlement_date_short_market_value,
            start_of_day_day_trading_buying_power,
            start_of_day_day_trading_buying_power_margin_call_amount,
            start_of_day_house_margin_call_amount,
            start_of_day_maintenance_margin_call_amount,
            start_of_day_reg_t_margin_call_amount,
            strategy_based_relief_adjustment_factor,
            total_equity,
            trade_date_cash_balance,
            trade_date_option_long_market_value,
            trade_date_total_long_market_value,
            trade_date_total_short_market_value,
            usable_sma_balance,
        )

    def __str__(self) -> str:
        return f"RqdAccountStatistics(account_number={self.account_number},account_type={self.account_type},as_of_date={self.as_of_date},available_cash_balance={self.available_cash_balance},cash_available_for_withdrawal={self.cash_available_for_withdrawal},cumulative_day_trade_pnl={self.cumulative_day_trade_pnl},day_trading_buying_power={self.day_trading_buying_power},day_trading_buying_power_high_water_mark={self.day_trading_buying_power_high_water_mark},day_trading_buying_power_maintenance_margin_multiplier={self.day_trading_buying_power_maintenance_margin_multiplier},day_trading_house_minimum_equity_margin_call_amount={self.day_trading_house_minimum_equity_margin_call_amount},day_trading_margin_call_amount={self.day_trading_margin_call_amount},day_trading_minimum_equity_margin_call_amount={self.day_trading_minimum_equity_margin_call_amount},excess_sma_amount={self.excess_sma_amount},house_initial_margin_requirement_adjustment_factor={self.house_initial_margin_requirement_adjustment_factor},house_margin_call_amount={self.house_margin_call_amount},house_margin_requirement={self.house_margin_requirement},house_margin_requirement_adjustment_factor={self.house_margin_requirement_adjustment_factor},is_day_trader={self.is_day_trader},maintenance_margin_requirement={self.maintenance_margin_requirement},margin_call_amount={self.margin_call_amount},marginable_equity={self.marginable_equity},market_value_adjustment_factor={self.market_value_adjustment_factor},number_open_day_trading_margin_calls={self.number_open_day_trading_margin_calls},option_only_maintenance_margin_requirement={self.option_only_maintenance_margin_requirement},option_trade_date_short_market_value={self.option_trade_date_short_market_value},overall_current_sma_balance={self.overall_current_sma_balance},overnight_buying_power={self.overnight_buying_power},reg_t_initial_margin_requirement={self.reg_t_initial_margin_requirement},reg_t_maintenance_margin_requirement_adjustment_factor={self.reg_t_maintenance_margin_requirement_adjustment_factor},reg_t_margin_call_amount={self.reg_t_margin_call_amount},settlement_date_cash_balance={self.settlement_date_cash_balance},settlement_date_long_market_value={self.settlement_date_long_market_value},settlement_date_option_long_market_value={self.settlement_date_option_long_market_value},settlement_date_option_short_market_value={self.settlement_date_option_short_market_value},settlement_date_short_market_value={self.settlement_date_short_market_value},start_of_day_day_trading_buying_power={self.start_of_day_day_trading_buying_power},start_of_day_day_trading_buying_power_margin_call_amount={self.start_of_day_day_trading_buying_power_margin_call_amount},start_of_day_house_margin_call_amount={self.start_of_day_house_margin_call_amount},start_of_day_maintenance_margin_call_amount={self.start_of_day_maintenance_margin_call_amount},start_of_day_reg_t_margin_call_amount={self.start_of_day_reg_t_margin_call_amount},strategy_based_relief_adjustment_factor={self.strategy_based_relief_adjustment_factor},total_equity={self.total_equity},trade_date_cash_balance={self.trade_date_cash_balance},trade_date_option_long_market_value={self.trade_date_option_long_market_value},trade_date_total_long_market_value={self.trade_date_total_long_market_value},trade_date_total_short_market_value={self.trade_date_total_short_market_value},usable_sma_balance={self.usable_sma_balance})"


class SortTickersBy(str, Enum):
    VOLUME_DESC = "VOLUME_DESC"
    CHANGE_ASC = "CHANGE_ASC"
    CHANGE_DESC = "CHANGE_DESC"
    ABS_CHANGE_DESC = "ABS_CHANGE_DESC"


class Statement(Struct, omit_defaults=True):
    account: str
    clearing_firm: str
    filename: str
    statement_date: date
    statement_type: str
    statement_uuid: str

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account: str,
        clearing_firm: str,
        filename: str,
        statement_date: date,
        statement_type: str,
        statement_uuid: str,
    ):
        return cls(
            account,
            clearing_firm,
            filename,
            statement_date,
            statement_type,
            statement_uuid,
        )

    def __str__(self) -> str:
        return f"Statement(account={self.account},clearing_firm={self.clearing_firm},filename={self.filename},statement_date={self.statement_date},statement_type={self.statement_type},statement_uuid={self.statement_uuid})"


TraderIdOrEmail = str


class TriggerLimitOrderType(Struct, omit_defaults=True):
    p: Annotated[Decimal, Meta(title="limit_price")]
    tp: Annotated[Decimal, Meta(title="trigger_price")]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        limit_price: Decimal,
        trigger_price: Decimal,
    ):
        return cls(
            limit_price,
            trigger_price,
        )

    def __str__(self) -> str:
        return f"TriggerLimitOrderType(limit_price={self.p},trigger_price={self.tp})"

    @property
    def limit_price(self) -> Decimal:
        return self.p

    @limit_price.setter
    def limit_price(self, value: Decimal) -> None:
        self.p = value

    @property
    def trigger_price(self) -> Decimal:
        return self.tp

    @trigger_price.setter
    def trigger_price(self, value: Decimal) -> None:
        self.tp = value


UserId = str


class Withdrawal(Struct, omit_defaults=True):
    account: str
    amount: Decimal
    description: str
    timestamp: datetime

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account: str,
        amount: Decimal,
        description: str,
        timestamp: datetime,
    ):
        return cls(
            account,
            amount,
            description,
            timestamp,
        )

    def __str__(self) -> str:
        return f"Withdrawal(account={self.account},amount={self.amount},description={self.description},timestamp={self.timestamp})"


class AccountPermissions(Struct, omit_defaults=True):
    """
    Set of flags for account permissions
    """

    list: bool
    reduce_or_close: bool
    set_limits: bool
    trade: bool
    view: bool

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        list: bool,
        reduce_or_close: bool,
        set_limits: bool,
        trade: bool,
        view: bool,
    ):
        return cls(
            list,
            reduce_or_close,
            set_limits,
            trade,
            view,
        )

    def __str__(self) -> str:
        return f"AccountPermissions(list={self.list},reduce_or_close={self.reduce_or_close},set_limits={self.set_limits},trade={self.trade},view={self.view})"


class AliasKind(str, Enum):
    CME_GLOBEX = "CME_GLOBEX"
    CFE = "CFE"


BoolOrListForString = Union[bool, List[str]]


class DerivativeKind(str, Enum):
    Linear = "Linear"
    Inverse = "Inverse"
    Quanto = "Quanto"


class FillKind(int, Enum):
    Normal = 0
    Reversal = 1
    Correction = 2


HumanDuration = str


class Unit(str, Enum):
    base = "base"
    quote = "quote"


class MinOrderQuantityUnit(Struct, omit_defaults=True):
    unit: Unit

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        unit: Unit,
    ):
        return cls(
            unit,
        )

    def __str__(self) -> str:
        return f"MinOrderQuantityUnit(unit={self.unit})"


class OptionsExerciseType(str, Enum):
    american = "american"
    european = "european"
    unknown = "unknown"


PriceDisplayFormat = str


class Fiat(Struct, omit_defaults=True):
    product_type: Literal["Fiat"]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        product_type: Literal["Fiat"],
    ):
        return cls(
            product_type,
        )

    def __str__(self) -> str:
        return f"Fiat(product_type={self.product_type})"


class Commodity(Struct, omit_defaults=True):
    product_type: Literal["Commodity"]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        product_type: Literal["Commodity"],
    ):
        return cls(
            product_type,
        )

    def __str__(self) -> str:
        return f"Commodity(product_type={self.product_type})"


class Crypto(Struct, omit_defaults=True):
    product_type: Literal["Crypto"]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        product_type: Literal["Crypto"],
    ):
        return cls(
            product_type,
        )

    def __str__(self) -> str:
        return f"Crypto(product_type={self.product_type})"


class Equity(Struct, omit_defaults=True):
    product_type: Literal["Equity"]
    easy_to_borrow: Optional[bool] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        product_type: Literal["Equity"],
        easy_to_borrow: Optional[bool] = None,
    ):
        return cls(
            product_type,
            easy_to_borrow,
        )

    def __str__(self) -> str:
        return f"Equity(product_type={self.product_type},easy_to_borrow={self.easy_to_borrow})"


class Index(Struct, omit_defaults=True):
    product_type: Literal["Index"]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        product_type: Literal["Index"],
    ):
        return cls(
            product_type,
        )

    def __str__(self) -> str:
        return f"Index(product_type={self.product_type})"


class Future(Struct, omit_defaults=True):
    derivative_kind: DerivativeKind
    expiration: datetime
    multiplier: Decimal
    product_type: Literal["Future"]
    first_notice_date: Optional[date] = None
    series: Optional[str] = None
    underlying: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        derivative_kind: DerivativeKind,
        expiration: datetime,
        multiplier: Decimal,
        product_type: Literal["Future"],
        first_notice_date: Optional[date] = None,
        series: Optional[str] = None,
        underlying: Optional[str] = None,
    ):
        return cls(
            derivative_kind,
            expiration,
            multiplier,
            product_type,
            first_notice_date,
            series,
            underlying,
        )

    def __str__(self) -> str:
        return f"Future(derivative_kind={self.derivative_kind},expiration={self.expiration},multiplier={self.multiplier},product_type={self.product_type},first_notice_date={self.first_notice_date},series={self.series},underlying={self.underlying})"


class Perpetual(Struct, omit_defaults=True):
    derivative_kind: DerivativeKind
    multiplier: Decimal
    product_type: Literal["Perpetual"]
    underlying: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        derivative_kind: DerivativeKind,
        multiplier: Decimal,
        product_type: Literal["Perpetual"],
        underlying: Optional[str] = None,
    ):
        return cls(
            derivative_kind,
            multiplier,
            product_type,
            underlying,
        )

    def __str__(self) -> str:
        return f"Perpetual(derivative_kind={self.derivative_kind},multiplier={self.multiplier},product_type={self.product_type},underlying={self.underlying})"


class Unknown(Struct, omit_defaults=True):
    product_type: Literal["Unknown"]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        product_type: Literal["Unknown"],
    ):
        return cls(
            product_type,
        )

    def __str__(self) -> str:
        return f"Unknown(product_type={self.product_type})"


class SnapshotOrUpdateForStringAndProductCatalogInfo1(Struct, omit_defaults=True):
    snapshot: Dict[str, ProductCatalogInfo]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        snapshot: Dict[str, ProductCatalogInfo],
    ):
        return cls(
            snapshot,
        )

    def __str__(self) -> str:
        return (
            f"SnapshotOrUpdateForStringAndProductCatalogInfo1(snapshot={self.snapshot})"
        )


Update6 = List[Union[str, Optional[ProductCatalogInfo]]]


class SnapshotOrUpdateForStringAndProductCatalogInfo2(Struct, omit_defaults=True):
    updates: List[Update6]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        updates: List[Update6],
    ):
        return cls(
            updates,
        )

    def __str__(self) -> str:
        return (
            f"SnapshotOrUpdateForStringAndProductCatalogInfo2(updates={self.updates})"
        )


SnapshotOrUpdateForStringAndProductCatalogInfo = Union[
    SnapshotOrUpdateForStringAndProductCatalogInfo1,
    SnapshotOrUpdateForStringAndProductCatalogInfo2,
]


class SnapshotOrUpdateForStringAndString1(Struct, omit_defaults=True):
    snapshot: Dict[str, str]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        snapshot: Dict[str, str],
    ):
        return cls(
            snapshot,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndString1(snapshot={self.snapshot})"


Update7 = List[Union[str, Optional[str]]]


class SnapshotOrUpdateForStringAndString2(Struct, omit_defaults=True):
    updates: List[Update7]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        updates: List[Update7],
    ):
        return cls(
            updates,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndString2(updates={self.updates})"


SnapshotOrUpdateForStringAndString = Union[
    SnapshotOrUpdateForStringAndString1, SnapshotOrUpdateForStringAndString2
]


class SpreaderPhase(str, Enum):
    ScanningForTakes = "ScanningForTakes"
    AwaitingOrderResults = "AwaitingOrderResults"
    OrderLockout = "OrderLockout"
    NoBbo = "NoBbo"
    NotEnoughBboSize = "NotEnoughBboSize"
    DoneOverfilled = "DoneOverfilled"
    DoneAndFullyHedged = "DoneAndFullyHedged"
    DoneAndGivingUp = "DoneAndGivingUp"


class SimpleDecimal(Struct, omit_defaults=True):
    simple: Decimal

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        simple: Decimal,
    ):
        return cls(
            simple,
        )

    def __str__(self) -> str:
        return f"SimpleDecimal(simple={self.simple})"


Threshold = List[Decimal]


class Varying1(Struct, omit_defaults=True):
    thresholds: List[Threshold]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        thresholds: List[Threshold],
    ):
        return cls(
            thresholds,
        )

    def __str__(self) -> str:
        return f"Varying1(thresholds={self.thresholds})"


class Varying(Struct, omit_defaults=True):
    """
    List of (threshold, tick_size) pairs.  For price greater than or equal to each threshold, the tick size is the corresponding value.
    """

    varying: Varying1

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        varying: Varying1,
    ):
        return cls(
            varying,
        )

    def __str__(self) -> str:
        return f"Varying(varying={self.varying})"


TickSize = Union[SimpleDecimal, Varying]


AccountName = str


class OptionLike(Struct, omit_defaults=True):
    strike: Decimal
    expiration: Optional[datetime] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        strike: Decimal,
        expiration: Optional[datetime] = None,
    ):
        return cls(
            strike,
            expiration,
        )

    def __str__(self) -> str:
        return f"OptionLike(strike={self.strike},expiration={self.expiration})"


class EventContractSeriesInstance2(Struct, omit_defaults=True):
    OptionLike: OptionLike

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        OptionLike: OptionLike,
    ):
        return cls(
            OptionLike,
        )

    def __str__(self) -> str:
        return f"EventContractSeriesInstance2(OptionLike={self.OptionLike})"


class OptionsSeriesInstance(Struct, omit_defaults=True):
    """
    A specific option from a series.
    """

    expiration: datetime
    put_or_call: PutOrCall
    strike: Decimal

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        expiration: datetime,
        put_or_call: PutOrCall,
        strike: Decimal,
    ):
        return cls(
            expiration,
            put_or_call,
            strike,
        )

    def __str__(self) -> str:
        return f"OptionsSeriesInstance(expiration={self.expiration},put_or_call={self.put_or_call},strike={self.strike})"


class SpreadLeg(Struct, omit_defaults=True):
    product: str
    quantity: Annotated[
        Decimal,
        Meta(
            description="Some spreads have different ratios for their legs, like buy 1 A, sell 2 B, buy 1 C; We would represent that with quantities in the legs: 1, -2, 1"
        ),
    ]
    """
    Some spreads have different ratios for their legs, like buy 1 A, sell 2 B, buy 1 C; We would represent that with quantities in the legs: 1, -2, 1
    """

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        product: str,
        quantity: Decimal,
    ):
        return cls(
            product,
            quantity,
        )

    def __str__(self) -> str:
        return f"SpreadLeg(product={self.product},quantity={self.quantity})"


class Outcome(Struct, omit_defaults=True):
    name: str

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        name: str,
    ):
        return cls(
            name,
        )

    def __str__(self) -> str:
        return f"Outcome(name={self.name})"


class AberrantFill(Struct, omit_defaults=True):
    """
    Fills which we received but couldn't parse fully, return details best effort
    """

    id: Annotated[str, Meta(title="fill_id")]
    x: Annotated[str, Meta(title="execution_venue")]
    a: Optional[Annotated[Optional[str], Meta(title="account")]] = None
    atn: Optional[Annotated[Optional[int], Meta(title="recv_time_ns")]] = None
    ats: Optional[Annotated[Optional[int], Meta(title="recv_time")]] = None
    d: Optional[Annotated[Optional[OrderDir], Meta(title="dir")]] = None
    f: Optional[Annotated[Optional[Decimal], Meta(title="fee")]] = None
    fu: Optional[Annotated[Optional[str], Meta(title="fee_currency")]] = None
    k: Optional[Annotated[Optional[FillKind], Meta(title="fill_kind")]] = None
    oid: Optional[Annotated[Optional[OrderId], Meta(title="order_id")]] = None
    p: Optional[Annotated[Optional[Decimal], Meta(title="price")]] = None
    q: Optional[Annotated[Optional[Decimal], Meta(title="quantity")]] = None
    s: Optional[Annotated[Optional[str], Meta(title="symbol")]] = None
    tn: Optional[Annotated[Optional[int], Meta(title="trade_time_ns")]] = None
    ts: Optional[Annotated[Optional[int], Meta(title="trade_time")]] = None
    u: Optional[Annotated[Optional[UserId], Meta(title="trader")]] = None
    xid: Optional[Annotated[Optional[str], Meta(title="exchange_fill_id")]] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        fill_id: str,
        execution_venue: str,
        account: Optional[str] = None,
        recv_time_ns: Optional[int] = None,
        recv_time: Optional[int] = None,
        dir: Optional[OrderDir] = None,
        fee: Optional[Decimal] = None,
        fee_currency: Optional[str] = None,
        fill_kind: Optional[FillKind] = None,
        order_id: Optional[OrderId] = None,
        price: Optional[Decimal] = None,
        quantity: Optional[Decimal] = None,
        symbol: Optional[str] = None,
        trade_time_ns: Optional[int] = None,
        trade_time: Optional[int] = None,
        trader: Optional[UserId] = None,
        exchange_fill_id: Optional[str] = None,
    ):
        return cls(
            fill_id,
            execution_venue,
            account,
            recv_time_ns,
            recv_time,
            dir,
            fee,
            fee_currency,
            fill_kind,
            order_id,
            price,
            quantity,
            symbol,
            trade_time_ns,
            trade_time,
            trader,
            exchange_fill_id,
        )

    def __str__(self) -> str:
        return f"AberrantFill(fill_id={self.id},execution_venue={self.x},account={self.a},recv_time_ns={self.atn},recv_time={self.ats},dir={self.d},fee={self.f},fee_currency={self.fu},fill_kind={self.k},order_id={self.oid},price={self.p},quantity={self.q},symbol={self.s},trade_time_ns={self.tn},trade_time={self.ts},trader={self.u},exchange_fill_id={self.xid})"

    @property
    def fill_id(self) -> str:
        return self.id

    @fill_id.setter
    def fill_id(self, value: str) -> None:
        self.id = value

    @property
    def execution_venue(self) -> str:
        return self.x

    @execution_venue.setter
    def execution_venue(self, value: str) -> None:
        self.x = value

    @property
    def account(self) -> Optional[str]:
        return self.a

    @account.setter
    def account(self, value: Optional[str]) -> None:
        self.a = value

    @property
    def recv_time_ns(self) -> Optional[int]:
        return self.atn

    @recv_time_ns.setter
    def recv_time_ns(self, value: Optional[int]) -> None:
        self.atn = value

    @property
    def recv_time(self) -> Optional[int]:
        return self.ats

    @recv_time.setter
    def recv_time(self, value: Optional[int]) -> None:
        self.ats = value

    @property
    def dir(self) -> Optional[OrderDir]:
        return self.d

    @dir.setter
    def dir(self, value: Optional[OrderDir]) -> None:
        self.d = value

    @property
    def fee(self) -> Optional[Decimal]:
        return self.f

    @fee.setter
    def fee(self, value: Optional[Decimal]) -> None:
        self.f = value

    @property
    def fee_currency(self) -> Optional[str]:
        return self.fu

    @fee_currency.setter
    def fee_currency(self, value: Optional[str]) -> None:
        self.fu = value

    @property
    def fill_kind(self) -> Optional[FillKind]:
        return self.k

    @fill_kind.setter
    def fill_kind(self, value: Optional[FillKind]) -> None:
        self.k = value

    @property
    def order_id(self) -> Optional[OrderId]:
        return self.oid

    @order_id.setter
    def order_id(self, value: Optional[OrderId]) -> None:
        self.oid = value

    @property
    def price(self) -> Optional[Decimal]:
        return self.p

    @price.setter
    def price(self, value: Optional[Decimal]) -> None:
        self.p = value

    @property
    def quantity(self) -> Optional[Decimal]:
        return self.q

    @quantity.setter
    def quantity(self, value: Optional[Decimal]) -> None:
        self.q = value

    @property
    def symbol(self) -> Optional[str]:
        return self.s

    @symbol.setter
    def symbol(self, value: Optional[str]) -> None:
        self.s = value

    @property
    def trade_time_ns(self) -> Optional[int]:
        return self.tn

    @trade_time_ns.setter
    def trade_time_ns(self, value: Optional[int]) -> None:
        self.tn = value

    @property
    def trade_time(self) -> Optional[int]:
        return self.ts

    @trade_time.setter
    def trade_time(self, value: Optional[int]) -> None:
        self.ts = value

    @property
    def trader(self) -> Optional[UserId]:
        return self.u

    @trader.setter
    def trader(self, value: Optional[UserId]) -> None:
        self.u = value

    @property
    def exchange_fill_id(self) -> Optional[str]:
        return self.xid

    @exchange_fill_id.setter
    def exchange_fill_id(self, value: Optional[str]) -> None:
        self.xid = value


class BatchOrder(Struct, omit_defaults=True):
    orders: List[Order]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        orders: List[Order],
    ):
        return cls(
            orders,
        )

    def __str__(self) -> str:
        return f"BatchOrder(orders={self.orders})"


class CancelReject(Struct, omit_defaults=True):
    id: OrderId
    xid: str
    rm: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        id: OrderId,
        xid: str,
        rm: Optional[str] = None,
    ):
        return cls(
            id,
            xid,
            rm,
        )

    def __str__(self) -> str:
        return f"CancelReject(id={self.id},xid={self.xid},rm={self.rm})"


class CptyLoginRequest(Struct, omit_defaults=True):
    account: str
    trader: UserId

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account: str,
        trader: UserId,
    ):
        return cls(
            account,
            trader,
        )

    def __str__(self) -> str:
        return f"CptyLoginRequest(account={self.account},trader={self.trader})"


class ExecutionInfo(Struct, omit_defaults=True):
    """
    Information about a symbol related to its execution route.
    """

    execution_venue: str
    is_delisted: bool
    min_order_quantity: Decimal
    min_order_quantity_unit: MinOrderQuantityUnit
    step_size: Decimal
    tick_size: TickSize
    exchange_symbol: Optional[
        Annotated[
            Optional[str],
            Meta(
                description="If the execution venue has stable symbology, this may be populated"
            ),
        ]
    ] = None
    """
    If the execution venue has stable symbology, this may be populated
    """
    initial_margin: Optional[Decimal] = None
    maintenance_margin: Optional[Decimal] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        execution_venue: str,
        is_delisted: bool,
        min_order_quantity: Decimal,
        min_order_quantity_unit: MinOrderQuantityUnit,
        step_size: Decimal,
        tick_size: TickSize,
        exchange_symbol: Optional[str] = None,
        initial_margin: Optional[Decimal] = None,
        maintenance_margin: Optional[Decimal] = None,
    ):
        return cls(
            execution_venue,
            is_delisted,
            min_order_quantity,
            min_order_quantity_unit,
            step_size,
            tick_size,
            exchange_symbol,
            initial_margin,
            maintenance_margin,
        )

    def __str__(self) -> str:
        return f"ExecutionInfo(execution_venue={self.execution_venue},is_delisted={self.is_delisted},min_order_quantity={self.min_order_quantity},min_order_quantity_unit={self.min_order_quantity_unit},step_size={self.step_size},tick_size={self.tick_size},exchange_symbol={self.exchange_symbol},initial_margin={self.initial_margin},maintenance_margin={self.maintenance_margin})"


class Fill(Struct, omit_defaults=True):
    d: Annotated[OrderDir, Meta(title="dir")]
    id: Annotated[str, Meta(title="fill_id")]
    k: Annotated[FillKind, Meta(title="fill_kind")]
    p: Annotated[Decimal, Meta(title="price")]
    q: Annotated[Decimal, Meta(title="quantity")]
    s: Annotated[str, Meta(title="symbol")]
    tn: Annotated[int, Meta(ge=0, title="trade_time_ns")]
    ts: Annotated[
        int,
        Meta(description="When the cpty claims the trade happened", title="trade_time"),
    ]
    """
    When the cpty claims the trade happened
    """
    x: Annotated[str, Meta(title="execution_venue")]
    a: Optional[Annotated[Optional[str], Meta(title="account")]] = None
    agg: Optional[Annotated[int, Meta(title="is_taker")]] = None
    atn: Optional[Annotated[Optional[int], Meta(title="recv_time_ns")]] = None
    ats: Optional[
        Annotated[
            Optional[int],
            Meta(
                description="When Architect received the fill, if realtime",
                title="recv_time",
            ),
        ]
    ] = None
    """
    When Architect received the fill, if realtime
    """
    f: Optional[Annotated[Optional[Decimal], Meta(title="fee")]] = None
    fu: Optional[
        Annotated[
            Optional[str],
            Meta(
                description="Fee currency, if different from the price currency",
                title="fee_currency",
            ),
        ]
    ] = None
    """
    Fee currency, if different from the price currency
    """
    oid: Optional[Annotated[Optional[OrderId], Meta(title="order_id")]] = None
    u: Optional[Annotated[Optional[UserId], Meta(title="trader")]] = None
    xid: Optional[Annotated[Optional[str], Meta(title="exchange_fill_id")]] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        dir: OrderDir,
        fill_id: str,
        fill_kind: FillKind,
        price: Decimal,
        quantity: Decimal,
        symbol: str,
        trade_time_ns: int,
        trade_time: int,
        execution_venue: str,
        account: Optional[str] = None,
        is_taker: Optional[int] = None,
        recv_time_ns: Optional[int] = None,
        recv_time: Optional[int] = None,
        fee: Optional[Decimal] = None,
        fee_currency: Optional[str] = None,
        order_id: Optional[OrderId] = None,
        trader: Optional[UserId] = None,
        exchange_fill_id: Optional[str] = None,
    ):
        return cls(
            dir,
            fill_id,
            fill_kind,
            price,
            quantity,
            symbol,
            trade_time_ns,
            trade_time,
            execution_venue,
            account,
            is_taker,
            recv_time_ns,
            recv_time,
            fee,
            fee_currency,
            order_id,
            trader,
            exchange_fill_id,
        )

    def __str__(self) -> str:
        return f"Fill(dir={self.d},fill_id={self.id},fill_kind={self.k},price={self.p},quantity={self.q},symbol={self.s},trade_time_ns={self.tn},trade_time={self.ts},execution_venue={self.x},account={self.a},is_taker={self.agg},recv_time_ns={self.atn},recv_time={self.ats},fee={self.f},fee_currency={self.fu},order_id={self.oid},trader={self.u},exchange_fill_id={self.xid})"

    @property
    def dir(self) -> OrderDir:
        return self.d

    @dir.setter
    def dir(self, value: OrderDir) -> None:
        self.d = value

    @property
    def fill_id(self) -> str:
        return self.id

    @fill_id.setter
    def fill_id(self, value: str) -> None:
        self.id = value

    @property
    def fill_kind(self) -> FillKind:
        return self.k

    @fill_kind.setter
    def fill_kind(self, value: FillKind) -> None:
        self.k = value

    @property
    def price(self) -> Decimal:
        return self.p

    @price.setter
    def price(self, value: Decimal) -> None:
        self.p = value

    @property
    def quantity(self) -> Decimal:
        return self.q

    @quantity.setter
    def quantity(self, value: Decimal) -> None:
        self.q = value

    @property
    def symbol(self) -> str:
        return self.s

    @symbol.setter
    def symbol(self, value: str) -> None:
        self.s = value

    @property
    def trade_time_ns(self) -> int:
        return self.tn

    @trade_time_ns.setter
    def trade_time_ns(self, value: int) -> None:
        self.tn = value

    @property
    def trade_time(self) -> int:
        return self.ts

    @trade_time.setter
    def trade_time(self, value: int) -> None:
        self.ts = value

    @property
    def datetime(self) -> datetime:
        """
        Convenience property to get the timestamp as a datetime object in UTC.
        """
        return datetime.fromtimestamp(self.ts, tz=timezone.utc)

    @property
    def datetime_local(self) -> datetime:
        """
        Convenience property to get the timestamp as a datetime object in local time.
        """
        return datetime.fromtimestamp(self.ts)

    @property
    def execution_venue(self) -> str:
        return self.x

    @execution_venue.setter
    def execution_venue(self, value: str) -> None:
        self.x = value

    @property
    def account(self) -> Optional[str]:
        return self.a

    @account.setter
    def account(self, value: Optional[str]) -> None:
        self.a = value

    @property
    def is_taker(self) -> Optional[int]:
        return self.agg

    @is_taker.setter
    def is_taker(self, value: Optional[int]) -> None:
        self.agg = value

    @property
    def recv_time_ns(self) -> Optional[int]:
        return self.atn

    @recv_time_ns.setter
    def recv_time_ns(self, value: Optional[int]) -> None:
        self.atn = value

    @property
    def recv_time(self) -> Optional[int]:
        return self.ats

    @recv_time.setter
    def recv_time(self, value: Optional[int]) -> None:
        self.ats = value

    @property
    def fee(self) -> Optional[Decimal]:
        return self.f

    @fee.setter
    def fee(self, value: Optional[Decimal]) -> None:
        self.f = value

    @property
    def fee_currency(self) -> Optional[str]:
        return self.fu

    @fee_currency.setter
    def fee_currency(self, value: Optional[str]) -> None:
        self.fu = value

    @property
    def order_id(self) -> Optional[OrderId]:
        return self.oid

    @order_id.setter
    def order_id(self, value: Optional[OrderId]) -> None:
        self.oid = value

    @property
    def trader(self) -> Optional[UserId]:
        return self.u

    @trader.setter
    def trader(self, value: Optional[UserId]) -> None:
        self.u = value

    @property
    def exchange_fill_id(self) -> Optional[str]:
        return self.xid

    @exchange_fill_id.setter
    def exchange_fill_id(self, value: Optional[str]) -> None:
        self.xid = value


class Grants(Struct, omit_defaults=True):
    marketdata: Optional[BoolOrListForString] = None
    scoped: Optional[
        Annotated[
            Optional[bool],
            Meta(
                description="If true, auth is scoped to the specific claims rather than granting broad access permissions;"
            ),
        ]
    ] = None
    """
    If true, auth is scoped to the specific claims rather than granting broad access permissions;
    """

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        marketdata: Optional[BoolOrListForString] = None,
        scoped: Optional[bool] = None,
    ):
        return cls(
            marketdata,
            scoped,
        )

    def __str__(self) -> str:
        return f"Grants(marketdata={self.marketdata},scoped={self.scoped})"


class ModifyPending(Struct, omit_defaults=True):
    id: Annotated[OrderId, Meta(title="order_id")]
    mid: Annotated[str, Meta(title="modify_id")]
    nid: Annotated[
        OrderId,
        Meta(
            description="The new order ID that will be assigned to the order after modification.",
            title="new_order_id",
        ),
    ]
    """
    The new order ID that will be assigned to the order after modification.
    """
    o: Annotated[ModifyStatus, Meta(title="status")]
    tn: Annotated[int, Meta(ge=0, title="recv_time_ns")]
    ts: Annotated[int, Meta(title="recv_time")]
    p: Optional[Annotated[Optional[Decimal], Meta(title="new_price")]] = None
    q: Optional[Annotated[Optional[Decimal], Meta(title="new_quantity")]] = None
    r: Optional[Annotated[Optional[str], Meta(title="reject_reason")]] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        order_id: OrderId,
        modify_id: str,
        new_order_id: OrderId,
        status: ModifyStatus,
        recv_time_ns: int,
        recv_time: int,
        new_price: Optional[Decimal] = None,
        new_quantity: Optional[Decimal] = None,
        reject_reason: Optional[str] = None,
    ):
        return cls(
            order_id,
            modify_id,
            new_order_id,
            status,
            recv_time_ns,
            recv_time,
            new_price,
            new_quantity,
            reject_reason,
        )

    def __str__(self) -> str:
        return f"ModifyPending(order_id={self.id},modify_id={self.mid},new_order_id={self.nid},status={self.o},recv_time_ns={self.tn},recv_time={self.ts},new_price={self.p},new_quantity={self.q},reject_reason={self.r})"

    @property
    def order_id(self) -> OrderId:
        return self.id

    @order_id.setter
    def order_id(self, value: OrderId) -> None:
        self.id = value

    @property
    def modify_id(self) -> str:
        return self.mid

    @modify_id.setter
    def modify_id(self, value: str) -> None:
        self.mid = value

    @property
    def new_order_id(self) -> OrderId:
        return self.nid

    @new_order_id.setter
    def new_order_id(self, value: OrderId) -> None:
        self.nid = value

    @property
    def status(self) -> ModifyStatus:
        return self.o

    @status.setter
    def status(self, value: ModifyStatus) -> None:
        self.o = value

    @property
    def recv_time_ns(self) -> int:
        return self.tn

    @recv_time_ns.setter
    def recv_time_ns(self, value: int) -> None:
        self.tn = value

    @property
    def recv_time(self) -> int:
        return self.ts

    @recv_time.setter
    def recv_time(self, value: int) -> None:
        self.ts = value

    @property
    def new_price(self) -> Optional[Decimal]:
        return self.p

    @new_price.setter
    def new_price(self, value: Optional[Decimal]) -> None:
        self.p = value

    @property
    def new_quantity(self) -> Optional[Decimal]:
        return self.q

    @new_quantity.setter
    def new_quantity(self, value: Optional[Decimal]) -> None:
        self.q = value

    @property
    def reject_reason(self) -> Optional[str]:
        return self.r

    @reject_reason.setter
    def reject_reason(self, value: Optional[str]) -> None:
        self.r = value


class ModifyReject(Struct, omit_defaults=True):
    id: OrderId
    mid: str
    rm: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        id: OrderId,
        mid: str,
        rm: Optional[str] = None,
    ):
        return cls(
            id,
            mid,
            rm,
        )

    def __str__(self) -> str:
        return f"ModifyReject(id={self.id},mid={self.mid},rm={self.rm})"


class OptionsSeriesInfo(Struct, omit_defaults=True):
    derivative_kind: DerivativeKind
    exercise_type: OptionsExerciseType
    expiration_time_of_day: time
    expiration_time_zone: str
    is_cash_settled: bool
    multiplier: Decimal
    options_series: str
    quote_symbol: str
    strikes_by_expiration: Dict[str, List[Decimal]]
    underlying: str
    venue_discriminant: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        derivative_kind: DerivativeKind,
        exercise_type: OptionsExerciseType,
        expiration_time_of_day: time,
        expiration_time_zone: str,
        is_cash_settled: bool,
        multiplier: Decimal,
        options_series: str,
        quote_symbol: str,
        strikes_by_expiration: Dict[str, List[Decimal]],
        underlying: str,
        venue_discriminant: Optional[str] = None,
    ):
        return cls(
            derivative_kind,
            exercise_type,
            expiration_time_of_day,
            expiration_time_zone,
            is_cash_settled,
            multiplier,
            options_series,
            quote_symbol,
            strikes_by_expiration,
            underlying,
            venue_discriminant,
        )

    def __str__(self) -> str:
        return f"OptionsSeriesInfo(derivative_kind={self.derivative_kind},exercise_type={self.exercise_type},expiration_time_of_day={self.expiration_time_of_day},expiration_time_zone={self.expiration_time_zone},is_cash_settled={self.is_cash_settled},multiplier={self.multiplier},options_series={self.options_series},quote_symbol={self.quote_symbol},strikes_by_expiration={self.strikes_by_expiration},underlying={self.underlying},venue_discriminant={self.venue_discriminant})"


class OrderAck(Struct, omit_defaults=True):
    id: Annotated[OrderId, Meta(title="order_id")]
    eid: Optional[Annotated[Optional[str], Meta(title="exchange_order_id")]] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        order_id: OrderId,
        exchange_order_id: Optional[str] = None,
    ):
        return cls(
            order_id,
            exchange_order_id,
        )

    def __str__(self) -> str:
        return f"OrderAck(order_id={self.id},exchange_order_id={self.eid})"

    @property
    def order_id(self) -> OrderId:
        return self.id

    @order_id.setter
    def order_id(self, value: OrderId) -> None:
        self.id = value

    @property
    def exchange_order_id(self) -> Optional[str]:
        return self.eid

    @exchange_order_id.setter
    def exchange_order_id(self, value: Optional[str]) -> None:
        self.eid = value


class OrderCanceled(Struct, omit_defaults=True):
    id: OrderId
    xid: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        id: OrderId,
        xid: Optional[str] = None,
    ):
        return cls(
            id,
            xid,
        )

    def __str__(self) -> str:
        return f"OrderCanceled(id={self.id},xid={self.xid})"


class OrderCanceling(Struct, omit_defaults=True):
    id: OrderId
    xid: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        id: OrderId,
        xid: Optional[str] = None,
    ):
        return cls(
            id,
            xid,
        )

    def __str__(self) -> str:
        return f"OrderCanceling(id={self.id},xid={self.xid})"


class OrderReject(Struct, omit_defaults=True):
    id: OrderId
    r: Annotated[OrderRejectReason, Meta(title="reject_reason")]
    rm: Optional[Annotated[Optional[str], Meta(title="message")]] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        id: OrderId,
        reject_reason: OrderRejectReason,
        message: Optional[str] = None,
    ):
        return cls(
            id,
            reject_reason,
            message,
        )

    def __str__(self) -> str:
        return f"OrderReject(id={self.id},reject_reason={self.r},message={self.rm})"

    @property
    def reject_reason(self) -> OrderRejectReason:
        return self.r

    @reject_reason.setter
    def reject_reason(self, value: OrderRejectReason) -> None:
        self.r = value

    @property
    def message(self) -> Optional[str]:
        return self.rm

    @message.setter
    def message(self, value: Optional[str]) -> None:
        self.rm = value


class SnapshotOrUpdateForAliasKindAndSnapshotOrUpdateForStringAndString1(
    Struct, omit_defaults=True
):
    snapshot: Dict[str, SnapshotOrUpdateForStringAndString]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        snapshot: Dict[str, SnapshotOrUpdateForStringAndString],
    ):
        return cls(
            snapshot,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForAliasKindAndSnapshotOrUpdateForStringAndString1(snapshot={self.snapshot})"


Update = List[Union[AliasKind, Optional[SnapshotOrUpdateForStringAndString]]]


class SnapshotOrUpdateForAliasKindAndSnapshotOrUpdateForStringAndString2(
    Struct, omit_defaults=True
):
    updates: List[Update]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        updates: List[Update],
    ):
        return cls(
            updates,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForAliasKindAndSnapshotOrUpdateForStringAndString2(updates={self.updates})"


SnapshotOrUpdateForAliasKindAndSnapshotOrUpdateForStringAndString = Union[
    SnapshotOrUpdateForAliasKindAndSnapshotOrUpdateForStringAndString1,
    SnapshotOrUpdateForAliasKindAndSnapshotOrUpdateForStringAndString2,
]


class SnapshotOrUpdateForStringAndOptionsSeriesInfo1(Struct, omit_defaults=True):
    snapshot: Dict[str, OptionsSeriesInfo]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        snapshot: Dict[str, OptionsSeriesInfo],
    ):
        return cls(
            snapshot,
        )

    def __str__(self) -> str:
        return (
            f"SnapshotOrUpdateForStringAndOptionsSeriesInfo1(snapshot={self.snapshot})"
        )


Update1 = List[Union[str, Optional[OptionsSeriesInfo]]]


class SnapshotOrUpdateForStringAndOptionsSeriesInfo2(Struct, omit_defaults=True):
    updates: List[Update1]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        updates: List[Update1],
    ):
        return cls(
            updates,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndOptionsSeriesInfo2(updates={self.updates})"


SnapshotOrUpdateForStringAndOptionsSeriesInfo = Union[
    SnapshotOrUpdateForStringAndOptionsSeriesInfo1,
    SnapshotOrUpdateForStringAndOptionsSeriesInfo2,
]


class SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndProductCatalogInfo1(
    Struct
):
    snapshot: Dict[str, SnapshotOrUpdateForStringAndProductCatalogInfo]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        snapshot: Dict[str, SnapshotOrUpdateForStringAndProductCatalogInfo],
    ):
        return cls(
            snapshot,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndProductCatalogInfo1(snapshot={self.snapshot})"


Update4 = List[Union[str, Optional[SnapshotOrUpdateForStringAndProductCatalogInfo]]]


class SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndProductCatalogInfo2(
    Struct
):
    updates: List[Update4]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        updates: List[Update4],
    ):
        return cls(
            updates,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndProductCatalogInfo2(updates={self.updates})"


SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndProductCatalogInfo = Union[
    SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndProductCatalogInfo1,
    SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndProductCatalogInfo2,
]


class SpreaderParams(Struct, omit_defaults=True):
    dir: OrderDir
    leg1_marketdata_venue: str
    leg1_price_offset: Decimal
    leg1_price_ratio: Decimal
    leg1_quantity_ratio: Decimal
    leg1_symbol: str
    leg2_marketdata_venue: str
    leg2_price_offset: Decimal
    leg2_price_ratio: Decimal
    leg2_quantity_ratio: Decimal
    leg2_symbol: str
    limit_price: Decimal
    order_lockout: HumanDuration
    quantity: Decimal
    leg1_account: Optional[AccountIdOrName] = None
    leg1_execution_venue: Optional[str] = None
    leg2_account: Optional[AccountIdOrName] = None
    leg2_execution_venue: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        dir: OrderDir,
        leg1_marketdata_venue: str,
        leg1_price_offset: Decimal,
        leg1_price_ratio: Decimal,
        leg1_quantity_ratio: Decimal,
        leg1_symbol: str,
        leg2_marketdata_venue: str,
        leg2_price_offset: Decimal,
        leg2_price_ratio: Decimal,
        leg2_quantity_ratio: Decimal,
        leg2_symbol: str,
        limit_price: Decimal,
        order_lockout: HumanDuration,
        quantity: Decimal,
        leg1_account: Optional[AccountIdOrName] = None,
        leg1_execution_venue: Optional[str] = None,
        leg2_account: Optional[AccountIdOrName] = None,
        leg2_execution_venue: Optional[str] = None,
    ):
        return cls(
            dir,
            leg1_marketdata_venue,
            leg1_price_offset,
            leg1_price_ratio,
            leg1_quantity_ratio,
            leg1_symbol,
            leg2_marketdata_venue,
            leg2_price_offset,
            leg2_price_ratio,
            leg2_quantity_ratio,
            leg2_symbol,
            limit_price,
            order_lockout,
            quantity,
            leg1_account,
            leg1_execution_venue,
            leg2_account,
            leg2_execution_venue,
        )

    def __str__(self) -> str:
        return f"SpreaderParams(dir={self.dir},leg1_marketdata_venue={self.leg1_marketdata_venue},leg1_price_offset={self.leg1_price_offset},leg1_price_ratio={self.leg1_price_ratio},leg1_quantity_ratio={self.leg1_quantity_ratio},leg1_symbol={self.leg1_symbol},leg2_marketdata_venue={self.leg2_marketdata_venue},leg2_price_offset={self.leg2_price_offset},leg2_price_ratio={self.leg2_price_ratio},leg2_quantity_ratio={self.leg2_quantity_ratio},leg2_symbol={self.leg2_symbol},limit_price={self.limit_price},order_lockout={self.order_lockout},quantity={self.quantity},leg1_account={self.leg1_account},leg1_execution_venue={self.leg1_execution_venue},leg2_account={self.leg2_account},leg2_execution_venue={self.leg2_execution_venue})"


class SpreaderStatus(Struct, omit_defaults=True):
    current_spreader_phase: SpreaderPhase
    leg1_fill_quantity: Decimal
    leg2_fill_quantity: Decimal
    implied_spread_vwap: Optional[Decimal] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        current_spreader_phase: SpreaderPhase,
        leg1_fill_quantity: Decimal,
        leg2_fill_quantity: Decimal,
        implied_spread_vwap: Optional[Decimal] = None,
    ):
        return cls(
            current_spreader_phase,
            leg1_fill_quantity,
            leg2_fill_quantity,
            implied_spread_vwap,
        )

    def __str__(self) -> str:
        return f"SpreaderStatus(current_spreader_phase={self.current_spreader_phase},leg1_fill_quantity={self.leg1_fill_quantity},leg2_fill_quantity={self.leg2_fill_quantity},implied_spread_vwap={self.implied_spread_vwap})"


class Account(Struct, omit_defaults=True):
    id: str
    name: AccountName

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        id: str,
        name: AccountName,
    ):
        return cls(
            id,
            name,
        )

    def __str__(self) -> str:
        return f"Account(id={self.id},name={self.name})"


class FutureSpread(Struct, omit_defaults=True):
    legs: List[SpreadLeg]
    product_type: Literal["FutureSpread"]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        legs: List[SpreadLeg],
        product_type: Literal["FutureSpread"],
    ):
        return cls(
            legs,
            product_type,
        )

    def __str__(self) -> str:
        return f"FutureSpread(legs={self.legs},product_type={self.product_type})"


class Option(Struct, omit_defaults=True):
    instance: OptionsSeriesInstance
    product_type: Literal["Option"]
    series: str

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        instance: OptionsSeriesInstance,
        product_type: Literal["Option"],
        series: str,
    ):
        return cls(
            instance,
            product_type,
            series,
        )

    def __str__(self) -> str:
        return f"Option(instance={self.instance},product_type={self.product_type},series={self.series})"


class SnapshotOrUpdateForStringAndExecutionInfo1(Struct, omit_defaults=True):
    snapshot: Dict[str, ExecutionInfo]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        snapshot: Dict[str, ExecutionInfo],
    ):
        return cls(
            snapshot,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndExecutionInfo1(snapshot={self.snapshot})"


Update5 = List[Union[str, Optional[ExecutionInfo]]]


class SnapshotOrUpdateForStringAndExecutionInfo2(Struct, omit_defaults=True):
    updates: List[Update5]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        updates: List[Update5],
    ):
        return cls(
            updates,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndExecutionInfo2(updates={self.updates})"


SnapshotOrUpdateForStringAndExecutionInfo = Union[
    SnapshotOrUpdateForStringAndExecutionInfo1,
    SnapshotOrUpdateForStringAndExecutionInfo2,
]


class Enumerated(Struct, omit_defaults=True):
    outcome: Outcome

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        outcome: Outcome,
    ):
        return cls(
            outcome,
        )

    def __str__(self) -> str:
        return f"Enumerated(outcome={self.outcome})"


class EventContractSeriesInstance1(Struct, omit_defaults=True):
    Enumerated: Enumerated

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        Enumerated: Enumerated,
    ):
        return cls(
            Enumerated,
        )

    def __str__(self) -> str:
        return f"EventContractSeriesInstance1(Enumerated={self.Enumerated})"


EventContractSeriesInstance = Union[
    EventContractSeriesInstance1, EventContractSeriesInstance2
]


class AccountWithPermissions(Struct, omit_defaults=True):
    account: Account
    permissions: AccountPermissions
    trader: UserId

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        account: Account,
        permissions: AccountPermissions,
        trader: UserId,
    ):
        return cls(
            account,
            permissions,
            trader,
        )

    def __str__(self) -> str:
        return f"AccountWithPermissions(account={self.account},permissions={self.permissions},trader={self.trader})"


class SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndExecutionInfo1(
    Struct, omit_defaults=True
):
    snapshot: Dict[str, SnapshotOrUpdateForStringAndExecutionInfo]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        snapshot: Dict[str, SnapshotOrUpdateForStringAndExecutionInfo],
    ):
        return cls(
            snapshot,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndExecutionInfo1(snapshot={self.snapshot})"


Update3 = List[Union[str, Optional[SnapshotOrUpdateForStringAndExecutionInfo]]]


class SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndExecutionInfo2(
    Struct, omit_defaults=True
):
    updates: List[Update3]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        updates: List[Update3],
    ):
        return cls(
            updates,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndExecutionInfo2(updates={self.updates})"


SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndExecutionInfo = Union[
    SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndExecutionInfo1,
    SnapshotOrUpdateForStringAndSnapshotOrUpdateForStringAndExecutionInfo2,
]


class EventContract(Struct, omit_defaults=True):
    instance: EventContractSeriesInstance
    product_type: Literal["EventContract"]
    series: str

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        instance: EventContractSeriesInstance,
        product_type: Literal["EventContract"],
        series: str,
    ):
        return cls(
            instance,
            product_type,
            series,
        )

    def __str__(self) -> str:
        return f"EventContract(instance={self.instance},product_type={self.product_type},series={self.series})"


ProductType = Union[
    Fiat,
    Commodity,
    Crypto,
    Equity,
    Index,
    Future,
    FutureSpread,
    Perpetual,
    Option,
    EventContract,
    Unknown,
]


class ProductInfo(Struct, omit_defaults=True):
    product_type: ProductType
    price_display_format: Optional[PriceDisplayFormat] = None
    primary_venue: Optional[str] = None

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        product_type: ProductType,
        price_display_format: Optional[PriceDisplayFormat] = None,
        primary_venue: Optional[str] = None,
    ):
        return cls(
            product_type,
            price_display_format,
            primary_venue,
        )

    def __str__(self) -> str:
        return f"ProductInfo(product_type={self.product_type},price_display_format={self.price_display_format},primary_venue={self.primary_venue})"


class SnapshotOrUpdateForStringAndProductInfo1(Struct, omit_defaults=True):
    snapshot: Dict[str, ProductInfo]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        snapshot: Dict[str, ProductInfo],
    ):
        return cls(
            snapshot,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndProductInfo1(snapshot={self.snapshot})"


Update2 = List[Union[str, Optional[ProductInfo]]]


class SnapshotOrUpdateForStringAndProductInfo2(Struct, omit_defaults=True):
    updates: List[Update2]

    # Constructor that takes all field titles as arguments for convenience
    @classmethod
    def new(
        cls,
        updates: List[Update2],
    ):
        return cls(
            updates,
        )

    def __str__(self) -> str:
        return f"SnapshotOrUpdateForStringAndProductInfo2(updates={self.updates})"


SnapshotOrUpdateForStringAndProductInfo = Union[
    SnapshotOrUpdateForStringAndProductInfo1, SnapshotOrUpdateForStringAndProductInfo2
]
