from decimal import Decimal

price_band_pairs: dict[str, Decimal] = {
    "ZT": Decimal(0.125),
    "ZTT": Decimal(0.15625),
    "ZF": Decimal(0.25),
    "ZN": Decimal(0.5),
    "TN": Decimal(0.5),
    "MTN": Decimal(0.5),
    "TNT": Decimal(0.625),
    "TWE": Decimal(0.5),
    "UB": Decimal(0.5),
    "MWN": Decimal(0.5),
    "UBT": Decimal(0.125),
    "ZB": Decimal(0.5),
    "TUL": Decimal(0.5),
    "TUT": Decimal(0.5),
    "TUX": Decimal(0.5),
    "TUB": Decimal(0.5),
    "TYT": Decimal(0.25),
    "TUF": Decimal(0.25),
    "TFY": Decimal(0.25),
    "TAF": Decimal(0.25),
    "TOU": Decimal(0.5),
    "TUN": Decimal(0.5),
    "TYX": Decimal(0.5),
    "TOB": Decimal(0.5),
    "TOF": Decimal(0.25),
    "FOL": Decimal(0.5),
    "FYT": Decimal(0.5),
    "FYN": Decimal(0.5),
    "FIT": Decimal(0.5),
    "FIX": Decimal(0.5),
    "FOB": Decimal(0.5),
    "NIB": Decimal(0.5),
    "NOL": Decimal(0.5),
    "TOX": Decimal(0.5),
    "TEX": Decimal(0.5),
    "NON": Decimal(0.5),
    "NBY": Decimal(0.5),
    "NCB": Decimal(0.5),
    "NOB": Decimal(0.5),
    "BIB": Decimal(0.5),
    "BOB": Decimal(0.5),
    "BUB": Decimal(0.5),
    "NUB": Decimal(0.5),
    "TTW": Decimal(0.25),
    "TWW": Decimal(0.25),
    "TRW": Decimal(0.25),
    "THW": Decimal(0.25),
    "FTW": Decimal(0.25),
    "FYW": Decimal(0.25),
    "TYW": Decimal(0.5),
    "TOW": Decimal(0.5),
    "NYW": Decimal(0.5),
    "NTW": Decimal(0.5),
    "ZBW": Decimal(0.5),
    "ZTW": Decimal(0.5),
    "TWU": Decimal(0.5),
    "TWB": Decimal(0.5),
    "ZC": Decimal(0.0975),
    "ZCT": Decimal(0.02),
    "XC": Decimal(0.0975),
    "ZO": Decimal(0.0975),
    "ZR": Decimal(0.195),
    "ZS": Decimal(0.0975),
    "XK": Decimal(0.0975),
    "SBT": Decimal(0.02),
    "ZM": Decimal(7.9),
    "ZMT": Decimal(0.8),
    "ZL": Decimal(0.0079),
    "ZLT": Decimal(0.0008),
    "ZW": Decimal(0.0975),
    "XW": Decimal(0.0975),
    "CWD": Decimal(600),
    "ZWT": Decimal(0.02),
    "KE": Decimal(0.0975),
    "KWD": Decimal(600),
    "KET": Decimal(0.02),
    "MKC": Decimal(0.0975),
    "AUW": Decimal(0.05),
    "SAS": Decimal(3.6),
    "GF": Decimal(0.00975),
    "GFT": Decimal(0.002),
    "HE": Decimal(0.00975),
    "HET": Decimal(0.002),
    "LE": Decimal(0.00975),
    "LET": Decimal(0.002),
    "PRK": Decimal(0.00975),
    "BLK": Decimal(0.06),
    "CB": Decimal(0.04),
    "CSC": Decimal(0.06),
    "DC": Decimal(0.6),
    "GDK": Decimal(0.6),
    "DY": Decimal(0.015),
    "GNF": Decimal(0.03),
    "LBR": Decimal(2000),
    "GIE": Decimal(10),
    "GIT": Decimal(1.25),
    "GD": Decimal(5),
    "GDT": Decimal(0.63),
    "AW": Decimal(0.8),
    "AWT": Decimal(8),
    "DRS": Decimal(8),
    "DRT": Decimal(1),
    "CJ": Decimal(120),
    "KT": Decimal(0.03),
    "TT": Decimal(0.024),
    "YO": Decimal(0.0105),
    "FZE": Decimal(0.025),
    "EH": Decimal(0.039),
    "CU": Decimal(0.25),
    "FBD": Decimal(0.001),
    "FBT": Decimal(0.001),
    "UCR": Decimal(0.001),
    "UCS": Decimal(0.001),
    "UCE": Decimal(0.001),
    "USG": Decimal(0.001),
    "AEZ": Decimal(0.025),
    "RBF": Decimal(0.001),
    "BFR": Decimal(0.001),
    "MTF": Decimal(0.6),
    "BKT": Decimal(1),
    "SCF": Decimal(1),
    "BKF": Decimal(1),
    "SCT": Decimal(1),
    "ANT": Decimal(0.01),
    "ANC": Decimal(0.01),
    "CY": Decimal(1),
    "IBS": Decimal(0.001),
    "CFB": Decimal(0.001),
    "CFC": Decimal(0.001),
    "BZ": Decimal(0.5),
    "BZT": Decimal(5),
    "BZL": Decimal(0.2),
    "BZS": Decimal(0.2),
    "BB": Decimal(0.5),
    "BBT": Decimal(5),
    "ADB": Decimal(0.001),
    "BDB": Decimal(0.001),
    "CPD": Decimal(10),
    "CCM": Decimal(1),
    "WS": Decimal(0.5),
    "DCL": Decimal(0.01),
    "DBB": Decimal(0.001),
    "AUB": Decimal(0.01),
    "AFE": Decimal(0.001),
    "AFY": Decimal(0.01),
    "ABI": Decimal(0.001),
    "DCB": Decimal(1),
    "QM": Decimal(0.5),
    "JCC": Decimal(1),
    "JCY": Decimal(1),
    "CL": Decimal(0.5),
    "MCL": Decimal(0.5),
    "CLT": Decimal(5),
    "CLL": Decimal(0.2),
    "CLS": Decimal(0.2),
    "WNT": Decimal(100),
    "WNC": Decimal(100),
    "DCW": Decimal(0.001),
    "TCS": Decimal(1),
    "QCS": Decimal(1),
    "HCS": Decimal(1),
    "ACS": Decimal(1),
    "CLD": Decimal(1),
    "AXA": Decimal(0.01),
    "LLR": Decimal(1),
    "AWJ": Decimal(0.25),
    "MX": Decimal(0.01),
    "MO": Decimal(0.01),
    "AYX": Decimal(1),
    "AYV": Decimal(1),
    "MBC": Decimal(0.75),
    "MDB": Decimal(0.75),
    "DBT": Decimal(1),
    "DBL": Decimal(1),
    "CSX": Decimal(0.5),
    "BK": Decimal(1),
    "ABY": Decimal(1),
    "HTT": Decimal(1),
    "HTA": Decimal(1),
    "HIL": Decimal(1),
    "HIA": Decimal(1),
    "HTB": Decimal(1),
    "HIB": Decimal(1),
    "AFF": Decimal(1),
    "WHD": Decimal(1),
    "WDB": Decimal(1),
    "WHB": Decimal(1),
    "WBR": Decimal(1),
    "WMB": Decimal(1),
    "WMR": Decimal(1),
    "WMD": Decimal(1),
    "WTD": Decimal(1),
    "MBM": Decimal(1),
    "MAB": Decimal(1),
    "WTT": Decimal(0.75),
    "WTB": Decimal(1),
    "FFB": Decimal(1),
    "WTI": Decimal(0.75),
    "AY": Decimal(0.01),
    "AFH": Decimal(1),
    "AXB": Decimal(0.01),
    "TBK": Decimal(1),
    "HBX": Decimal(1),
    "WBX": Decimal(1),
    "OAD": Decimal(0.01),
    "AQK": Decimal(0.01),
    "PFP": Decimal(0.01),
    "FEF": Decimal(0.01),
    "XPP": Decimal(0.01),
    "PEX": Decimal(0.01),
    "LAF": Decimal(0.01),
    "PHF": Decimal(0.01),
    "LAP": Decimal(0.01),
    "APA": Decimal(0.01),
    "DAX": Decimal(0.01),
    "DAZ": Decimal(0.01),
    "DHA": Decimal(0.01),
    "EMC": Decimal(5),
    "EAA": Decimal(0.01),
    "EAE": Decimal(0.01),
    "YHE": Decimal(0.01),
    "YHF": Decimal(0.01),
    "ERL": Decimal(0.01),
    "YRP": Decimal(0.01),
    "EAC": Decimal(0.01),
    "YRW": Decimal(0.01),
    "EAB": Decimal(0.01),
    "ENP": Decimal(0.01),
    "YUE": Decimal(0.01),
    "EUB": Decimal(0.01),
    "YWK": Decimal(0.01),
    "YWF": Decimal(0.01),
    "YWE": Decimal(0.01),
    "EAW": Decimal(0.01),
    "NCO": Decimal(1),
    "NMO": Decimal(1),
    "NHO": Decimal(1),
    "NEO": Decimal(1),
    "NRO": Decimal(1),
    "NSO": Decimal(1),
    "NWO": Decimal(1),
    "NTP": Decimal(1),
    "NMP": Decimal(1),
    "NHP": Decimal(1),
    "NNP": Decimal(1),
    "NRP": Decimal(1),
    "NSP": Decimal(1),
    "NWP": Decimal(1),
    "IDL": Decimal(2),
    "COL": Decimal(2),
    "SRT": Decimal(2),
    "SDD": Decimal(2),
    "FAL": Decimal(2),
    "FTL": Decimal(2),
    "PDL": Decimal(2),
    "PTL": Decimal(2),
    "EJL": Decimal(2),
    "HOA": Decimal(0.05),
    "HWA": Decimal(0.05),
    "AJJ": Decimal(0.05),
    "ALM": Decimal(0.05),
    "AOJ": Decimal(0.05),
    "AOH": Decimal(0.05),
    "AHJ": Decimal(0.05),
    "AHM": Decimal(0.05),
    "LHV": Decimal(200),
    "NHH": Decimal(0.01),
    "NRR": Decimal(0.01),
    "NCD": Decimal(2),
    "NOD": Decimal(2),
    "NFO": Decimal(2),
    "MOI": Decimal(2),
    "MMO": Decimal(2),
    "MRI": Decimal(2),
    "MMR": Decimal(2),
    "MRT": Decimal(2),
    "NEP": Decimal(2),
    "NFD": Decimal(2),
    "MIP": Decimal(2),
    "MMP": Decimal(2),
    "MTI": Decimal(2),
    "MNT": Decimal(2),
    "MCT": Decimal(2),
    "ANL": Decimal(2),
    "ZAL": Decimal(2),
    "GNL": Decimal(2),
    "ZGL": Decimal(2),
    "JNL": Decimal(2),
    "ZJL": Decimal(2),
    "OOD": Decimal(0.05),
    "OFF": Decimal(0.05),
    "OPO": Decimal(0.05),
    "OMM": Decimal(0.05),
    "PFO": Decimal(2),
    "PZO": Decimal(2),
    "PHO": Decimal(2),
    "PBO": Decimal(2),
    "PCO": Decimal(2),
    "PUO": Decimal(2),
    "PQO": Decimal(2),
    "PYO": Decimal(2),
    "PTO": Decimal(2),
    "PMO": Decimal(2),
    "PVO": Decimal(2),
    "POC": Decimal(2),
    "PXO": Decimal(2),
    "PLO": Decimal(2),
    "PSO": Decimal(2),
    "PRO": Decimal(2),
    "PZP": Decimal(2),
    "PHP": Decimal(2),
    "PBP": Decimal(2),
    "PCP": Decimal(2),
    "PUP": Decimal(2),
    "PQP": Decimal(2),
    "PYP": Decimal(2),
    "PPL": Decimal(2),
    "PMP": Decimal(2),
    "PVP": Decimal(2),
    "PKP": Decimal(2),
    "PXP": Decimal(2),
    "PLP": Decimal(2),
    "PSP": Decimal(2),
    "PRP": Decimal(2),
    "VDL": Decimal(2),
    "PEL": Decimal(2),
    "PAL": Decimal(2),
    "AOL": Decimal(2),
    "MDD": Decimal(0.05),
    "MOA": Decimal(0.05),
    "MPP": Decimal(0.05),
    "MPA": Decimal(0.05),
    "PDJ": Decimal(200),
    "UDL": Decimal(2),
    "PNL": Decimal(2),
    "NOI": Decimal(2),
    "POL": Decimal(2),
    "JDL": Decimal(2),
    "WPL": Decimal(2),
    "WOL": Decimal(2),
    "PWL": Decimal(2),
    "DEB": Decimal(2),
    "DEP": Decimal(2),
    "ITB": Decimal(2),
    "ITP": Decimal(2),
    "JBT": Decimal(2),
    "JPT": Decimal(2),
    "JBK": Decimal(2),
    "JPK": Decimal(2),
    "ECF": Decimal(40),
    "LCS": Decimal(500),
    "RGI": Decimal(0.5),
    "GEO": Decimal(0.5),
    "NGO": Decimal(0.5),
    "NOT": Decimal(0.5),
    "CGO": Decimal(0.5),
    "UME": Decimal(0.02),
    "UFV": Decimal(0.02),
    "UFE": Decimal(0.02),
    "UFB": Decimal(0.02),
    "DFN": Decimal(0.02),
    "UNO": Decimal(0.02),
    "MFC": Decimal(0.02),
    "FLP": Decimal(200),
    "FLB": Decimal(0.2),
    "FLJ": Decimal(200),
    "TM": Decimal(0.2),
    "TMB": Decimal(0.2),
    "TMD": Decimal(0.2),
    "TH": Decimal(0.2),
    "FRS": Decimal(0.2),
    "FRC": Decimal(0.2),
    "TL": Decimal(0.2),
    "TLB": Decimal(0.2),
    "TLD": Decimal(0.2),
    "TK": Decimal(0.2),
    "TKB": Decimal(0.2),
    "TDM": Decimal(0.2),
    "XUK": Decimal(2000),
    "XUB": Decimal(0.2),
    "ACB": Decimal(0.2),
    "AEB": Decimal(0.2),
    "TFB": Decimal(0.2),
    "USE": Decimal(0.2),
    "RBM": Decimal(2000),
    "SBM": Decimal(2000),
    "SRB": Decimal(2000),
    "HGB": Decimal(100),
    "UPB": Decimal(100),
    "UPM": Decimal(100),
    "BPU": Decimal(100),
    "QG": Decimal(0.05),
    "NG": Decimal(0.05),
    "MNG": Decimal(0.05),
    "NGT": Decimal(5),
    "NN": Decimal(0.05),
    "NNT": Decimal(5),
    "NNE": Decimal(0.1),
    "HH": Decimal(0.05),
    "HHT": Decimal(5),
    "HP": Decimal(0.05),
    "NPG": Decimal(0.05),
    "NBP": Decimal(0.15),
    "TTE": Decimal(0.125),
    "NYP": Decimal(0.1),
    "THD": Decimal(0.1),
    "UKG": Decimal(1),
    "NBD": Decimal(1),
    "TTF": Decimal(1),
    "TAS": Decimal(50),
    "TTG": Decimal(0.5),
    "TTS": Decimal(50),
    "TTD": Decimal(1),
    "JKM": Decimal(0.01),
    "NWM": Decimal(0.01),
    "JKY": Decimal(0.01),
    "MTH": Decimal(250),
    "LNG": Decimal(100),
    "CPO": Decimal(15),
    "OPF": Decimal(15),
    "POG": Decimal(15),
    "MBA": Decimal(1),
    "CGB": Decimal(0.015),
    "CBB": Decimal(0.015),
    "CPP": Decimal(0.015),
    "CPB": Decimal(0.015),
    "APS": Decimal(2),
    "HPD": Decimal(1e-05),
    "HPE": Decimal(1e-05),
    "LEL": Decimal(1e-05),
    "LPE": Decimal(1e-05),
    "MAS": Decimal(2),
    "MAE": Decimal(2),
    "MAA": Decimal(2),
    "MPS": Decimal(2),
    "MBB": Decimal(1e-05),
    "MBR": Decimal(0.01),
    "MBL": Decimal(0.015),
    "PMF": Decimal(0.2),
    "PNF": Decimal(0.2),
    "MNB": Decimal(0.015),
    "MBE": Decimal(0.01),
    "PGG": Decimal(0.01),
    "PPW": Decimal(1e-05),
    "PPP": Decimal(1e-05),
    "AOB": Decimal(0.001),
    "FOM": Decimal(0.001),
    "EBE": Decimal(0.001),
    "AFI": Decimal(0.001),
    "FVB": Decimal(0.001),
    "FCB": Decimal(0.001),
    "FO": Decimal(1),
    "FL": Decimal(0.01),
    "CMF": Decimal(0.01),
    "CMB": Decimal(0.01),
    "FOA": Decimal(0.001),
    "BOO": Decimal(1),
    "AFK": Decimal(2),
    "EOB": Decimal(0.001),
    "MAC": Decimal(1),
    "FCN": Decimal(0.001),
    "FOR": Decimal(0.001),
    "NCP": Decimal(0.001),
    "GBR": Decimal(0.001),
    "EWG": Decimal(1),
    "EWB": Decimal(0.001),
    "FEW": Decimal(2),
    "EWN": Decimal(0.001),
    "JE": Decimal(0.0001),
    "QH": Decimal(0.015),
    "QU": Decimal(0.015),
    "AUH": Decimal(0.001),
    "EFM": Decimal(0.001),
    "ENS": Decimal(0.001),
    "AKX": Decimal(0.001),
    "AUF": Decimal(0.001),
    "UV": Decimal(2),
    "AKR": Decimal(0.001),
    "EFF": Decimal(0.001),
    "AUI": Decimal(2),
    "AGT": Decimal(0.01),
    "AET": Decimal(0.001),
    "GZ": Decimal(1),
    "ESB": Decimal(1),
    "AGX": Decimal(0.001),
    "UR": Decimal(0.01),
    "AUJ": Decimal(0.01),
    "AKZ": Decimal(0.001),
    "UN": Decimal(2),
    "EN": Decimal(1),
    "EPN": Decimal(0.001),
    "FSS": Decimal(2),
    "TW": Decimal(0.001),
    "AVL": Decimal(1000),
    "AWQ": Decimal(0.001),
    "ATU": Decimal(0.001),
    "GKS": Decimal(0.001),
    "GNO": Decimal(2000),
    "GNB": Decimal(2000),
    "GNS": Decimal(1000),
    "RGF": Decimal(250),
    "POB": Decimal(250),
    "GES": Decimal(2000),
    "SGF": Decimal(1000),
    "EGN": Decimal(2),
    "EGB": Decimal(2),
    "AVZ": Decimal(0.001),
    "CRG": Decimal(0.0001),
    "GCG": Decimal(0.001),
    "CRB": Decimal(0.0001),
    "ME": Decimal(0.025),
    "AGE": Decimal(0.0001),
    "GFC": Decimal(0.001),
    "MGH": Decimal(1),
    "MFB": Decimal(1),
    "GCB": Decimal(0.001),
    "GCU": Decimal(1),
    "GCI": Decimal(1),
    "AJ": Decimal(0.0001),
    "GUD": Decimal(0.0001),
    "AUS": Decimal(0.0001),
    "GY": Decimal(1),
    "ALY": Decimal(0.025),
    "LT": Decimal(0.025),
    "VV": Decimal(0.0001),
    "RVR": Decimal(0.0001),
    "GCM": Decimal(0.0001),
    "GCC": Decimal(0.001),
    "GBB": Decimal(0.0001),
    "AJB": Decimal(0.01),
    "JNC": Decimal(0.1),
    "JA": Decimal(2),
    "AJR": Decimal(0.01),
    "HJC": Decimal(0.01),
    "JFC": Decimal(1000),
    "JFB": Decimal(1000),
    "ALX": Decimal(0.0001),
    "AKL": Decimal(0.0001),
    "MH": Decimal(0.0001),
    "AJL": Decimal(0.0001),
    "AJS": Decimal(0.0001),
    "LL": Decimal(0.0001),
    "MQ": Decimal(0.0001),
    "GOC": Decimal(1),
    "ESS": Decimal(2),
    "AQA": Decimal(0.001),
    "MBS": Decimal(0.001),
    "MPE": Decimal(0.001),
    "MFP": Decimal(2),
    "MFD": Decimal(0.001),
    "MNS": Decimal(2),
    "MMF": Decimal(2),
    "MFR": Decimal(2),
    "MEW": Decimal(2),
    "MEF": Decimal(2),
    "MUD": Decimal(0.001),
    "MJB": Decimal(0.001),
    "MJC": Decimal(0.001),
    "MEE": Decimal(0.001),
    "MNC": Decimal(0.001),
    "MGF": Decimal(0.001),
    "MGB": Decimal(0.001),
    "MEO": Decimal(2),
    "MEB": Decimal(2),
    "MJN": Decimal(0.001),
    "MGS": Decimal(0.001),
    "MHE": Decimal(0.001),
    "MXB": Decimal(0.025),
    "MXR": Decimal(0.025),
    "MTB": Decimal(0.001),
    "MAF": Decimal(2),
    "MTS": Decimal(2),
    "MSB": Decimal(0.2),
    "MSG": Decimal(0.001),
    "UCM": Decimal(0.001),
    "MGN": Decimal(0.001),
    "NBB": Decimal(0.001),
    "NOO": Decimal(1),
    "NFC": Decimal(0.001),
    "NFG": Decimal(0.001),
    "AVK": Decimal(0.001),
    "AML": Decimal(0.01),
    "MM": Decimal(1),
    "VR": Decimal(1),
    "BUC": Decimal(0.025),
    "JTB": Decimal(0.025),
    "JET": Decimal(0.025),
    "NYF": Decimal(0.001),
    "HOB": Decimal(1),
    "ABH": Decimal(0.025),
    "AHL": Decimal(1),
    "MPX": Decimal(0.025),
    "HO": Decimal(0.015),
    "HOL": Decimal(0.002),
    "HOT": Decimal(5),
    "NLS": Decimal(0.025),
    "ULB": Decimal(0.0001),
    "RLX": Decimal(0.025),
    "ARE": Decimal(1),
    "RT": Decimal(0.025),
    "RB": Decimal(0.015),
    "RBT": Decimal(5),
    "RBL": Decimal(0.002),
    "RBB": Decimal(1),
    "XER": Decimal(0.001),
    "EXR": Decimal(0.0001),
    "ARY": Decimal(0.0001),
    "STR": Decimal(0.001),
    "STS": Decimal(0.001),
    "STY": Decimal(0.001),
    "ABS": Decimal(0.001),
    "GMB": Decimal(0.001),
    "UA": Decimal(2),
    "GMS": Decimal(2),
    "MSD": Decimal(0.001),
    "SD": Decimal(2),
    "STI": Decimal(0.001),
    "ABT": Decimal(0.001),
    "SE": Decimal(2),
    "SFB": Decimal(2),
    "EVC": Decimal(2),
    "AVU": Decimal(1),
    "SGB": Decimal(1),
    "AGA": Decimal(0.001),
    "ABX": Decimal(0.001),
    "ASD": Decimal(0.001),
    "AKS": Decimal(0.001),
    "RKA": Decimal(0.001),
    "SMU": Decimal(0.001),
    "YNO": Decimal(0.001),
    "ZKU": Decimal(0.001),
    "ASP": Decimal(0.001),
    "GDL": Decimal(0.001),
    "ATY": Decimal(0.001),
    "ATP": Decimal(0.001),
    "BTC": Decimal(400),
    "BFF": Decimal(400),
    "BTB": Decimal(50),
    "BNB": Decimal(50),
    "ABB": Decimal(50),
    "TBT": Decimal(5),
    "BTE": Decimal(400),
    "EBM": Decimal(400),
    "MBT": Decimal(400),
    "TBM": Decimal(5),
    "MIB": Decimal(50),
    "MYB": Decimal(50),
    "AMB": Decimal(50),
    "EBR": Decimal(400),
    "ETH": Decimal(4000),
    "ETB": Decimal(500),
    "ENB": Decimal(500),
    "ATB": Decimal(50),
    "ETE": Decimal(4000),
    "EEM": Decimal(4000),
    "MET": Decimal(4000),
    "EMB": Decimal(500),
    "EYB": Decimal(500),
    "AHB": Decimal(50),
    "IPO": Decimal(4000),
    "IPT": Decimal(100),
    "BIO": Decimal(12),
    "REX": Decimal(8),
    "QCN": Decimal(12),
    "NQ": Decimal(30),
    "NDA": Decimal(200),
    "NQT": Decimal(7.5),
    "NQX": Decimal(0.5),
    "AQT": Decimal(3),
    "NQQ": Decimal(7.5),
    "MNQ": Decimal(30),
    "ART": Decimal(5),
    "RSG": Decimal(4),
    "RGT": Decimal(1),
    "RSV": Decimal(4),
    "RVT": Decimal(1),
    "RTY": Decimal(8),
    "RTX": Decimal(0.5),
    "RLT": Decimal(2),
    "RTQ": Decimal(2),
    "RDA": Decimal(100),
    "ES": Decimal(10),
    "EST": Decimal(2.5),
    "ESX": Decimal(0.5),
    "ESG": Decimal(6),
    "EGT": Decimal(1.5),
    "ESQ": Decimal(2.5),
    "MES": Decimal(10),
    "EMD": Decimal(4),
    "EWF": Decimal(4),
    "EWFT": Decimal(1),
    "MMC": Decimal(4),
    "EMT": Decimal(1),
    "SMC": Decimal(4),
    "SMT": Decimal(1),
    "MSC": Decimal(4),
    "SG": Decimal(4),
    "SGT": Decimal(4),
    "SU": Decimal(4),
    "SUT": Decimal(1),
    "SDA": Decimal(1),
    "SDI": Decimal(0.5),
    "TRB": Decimal(3),
    "AST": Decimal(3),
    "RX": Decimal(8),
    "ADT": Decimal(25),
    "YM": Decimal(90),
    "YMX": Decimal(4),
    "YMT": Decimal(20),
    "MYM": Decimal(90),
    "TPY": Decimal(800),
    "TPB": Decimal(200),
    "TPD": Decimal(800),
    "TPT": Decimal(200),
    "FTT": Decimal(750),
    "FTU": Decimal(600),
    "FTB": Decimal(150),
    "FTC": Decimal(15),
    "ENY": Decimal(120),
    "NKD": Decimal(100),
    "NKT": Decimal(2500),
    "MNK": Decimal(100),
    "NIY": Decimal(100),
    "MNI": Decimal(100),
    "NIT": Decimal(2500),
    "IBV": Decimal(500),
    "XAZ": Decimal(8),
    "XZT": Decimal(8),
    "XAY": Decimal(4),
    "XYT": Decimal(8),
    "XAP": Decimal(8),
    "XPT": Decimal(8),
    "XAE": Decimal(8),
    "XET": Decimal(8),
    "XAF": Decimal(8),
    "XFT": Decimal(8),
    "XAV": Decimal(8),
    "XVT": Decimal(8),
    "XAI": Decimal(8),
    "XIT": Decimal(8),
    "XAB": Decimal(8),
    "XBT": Decimal(8),
    "XAR": Decimal(800),
    "XRT": Decimal(8),
    "XAK": Decimal(8),
    "XKT": Decimal(8),
    "XAU": Decimal(8),
    "XUT": Decimal(8),
    "SXB": Decimal(10),
    "RKT": Decimal(2.5),
    "SXI": Decimal(20),
    "IST": Decimal(5),
    "SXO": Decimal(20),
    "SWT": Decimal(5),
    "SOX": Decimal(8),
    "SOT": Decimal(20),
    "SXT": Decimal(50),
    "BOT": Decimal(25),
    "SXR": Decimal(50),
    "RET": Decimal(25),
    "EI": Decimal(3),
    "EIT": Decimal(75),
    "DVE": Decimal(300),
    "DVT": Decimal(75),
    "AJY": Decimal(60),
    "NOK": Decimal(500),
    "CZK": Decimal(0.0012),
    "ECK": Decimal(0.00012),
    "HUF": Decimal(1.2e-05),
    "KRW": Decimal(6e-07),
    "PLN": Decimal(0.0012),
    "EPZ": Decimal(0.0012),
    "TRL": Decimal(750),
    "EUS": Decimal(5),
    "RSD": Decimal(5),
    "RFI": Decimal(10),
    "RSI": Decimal(5),
    "SON": Decimal(10),
    "TIE": Decimal(20),
    "ZQ": Decimal(0.1),
    "FFV": Decimal(25),
    "IQB": Decimal(2000),
    "IQBT": Decimal(500),
    "HYB": Decimal(500),
    "HYV": Decimal(500),
    "DHB": Decimal(200),
    "IGHY": Decimal(500),
    "YIA": Decimal(1250),
    "YIT": Decimal(1250),
    "YIC": Decimal(1250),
    "YID": Decimal(5000),
    "YIW": Decimal(5000),
    "YIB": Decimal(5000),
    "YIY": Decimal(5000),
    "YII": Decimal(5000),
    "YIL": Decimal(5000),
    "YIO": Decimal(5200),
    "YIE": Decimal(5200),
    "ETU": Decimal(5000),
    "EIB": Decimal(5000),
    "EBY": Decimal(5000),
    "MGC": Decimal(10),
    "MGT": Decimal(2),
    "GC": Decimal(10),
    "GCD": Decimal(2),
    "GCT": Decimal(2),
    "GCK": Decimal(10),
    "GSP": Decimal(1.2),
    "SGU": Decimal(100),
    "SGC": Decimal(200),
    "QO": Decimal(10),
    "QI": Decimal(0.2),
    "SI": Decimal(0.2),
    "SIT": Decimal(0.02),
    "SIL": Decimal(0.2),
    "SSP": Decimal(0.2),
    "PA": Decimal(30),
    "PAM": Decimal(3000),
    "PAT": Decimal(20),
    "PL": Decimal(10),
    "PLM": Decimal(10),
    "PLT": Decimal(20),
    "ALA": Decimal(10),
    "ALB": Decimal(10),
    "ALI": Decimal(20),
    "EDP": Decimal(20),
    "MJP": Decimal(20),
    "HG": Decimal(0.03),
    "HGF": Decimal(100),
    "HGT": Decimal(0.01),
    "HGS": Decimal(0.04),
    "QC": Decimal(0.03),
    "MHG": Decimal(0.03),
    "LED": Decimal(2000),
    "ZNC": Decimal(5),
    "FSF": Decimal(5),
    "TIO": Decimal(5),
    "BUS": Decimal(3000),
    "HRC": Decimal(20),
    "AUP": Decimal(0.01),
    "AEP": Decimal(20),
    "HDG": Decimal(20),
    "HRP": Decimal(50),
    "COH": Decimal(50),
    "COB": Decimal(50),
    "LTH": Decimal(50),
    "LTC": Decimal(50),
    "MOX": Decimal(50),
    "SPM": Decimal(50),
    "UX": Decimal(7.5),
    "BOS": Decimal(4),
    "CHI": Decimal(4),
    "CUS": Decimal(4),
    "DEN": Decimal(4),
    "LAV": Decimal(4),
    "LAX": Decimal(4),
    "MIA": Decimal(4),
    "NYM": Decimal(4),
    "SDG": Decimal(4),
    "SFR": Decimal(4),
    "WDC": Decimal(4),
    "FPKO": Decimal(80),
    "FCPO": Decimal(80),
    "CPV": Decimal(80),
    "FPOL": Decimal(25),
    "FSOY": Decimal(24),
    "FKLI": Decimal(40),
    "FTIN": Decimal(120),
    "FGLD": Decimal(8),
    "FUPO": Decimal(24),
    "FCNH": Decimal(0.2),
    "BDS": Decimal(1),
    "DDB": Decimal(1),
    "ODO": Decimal(1),
    "ZGD": Decimal(0.75),
    "OQD": Decimal(0.75),
    "OQB": Decimal(0.5),
    "MWE": Decimal(0.0975),
}
