ALLOWED_AWS_COMMANDS: dict[str, dict] = {
    # Compute services (read-only)
    "ec2": {
        "describe-instances": {},
        "describe-images": {},
        "describe-volumes": {},
        "describe-snapshots": {},
        "describe-security-groups": {},
        "describe-subnets": {},
        "describe-vpcs": {},
        "describe-internet-gateways": {},
        "describe-route-tables": {},
        "describe-network-acls": {},
        "describe-nat-gateways": {},
        "describe-addresses": {},
        "describe-key-pairs": {},
        "describe-availability-zones": {},
        "describe-regions": {},
        "describe-instance-types": {},
        "describe-instance-attribute": {},
        "describe-instance-status": {},
        "describe-placement-groups": {},
        "describe-reserved-instances": {},
        "describe-spot-instances": {},
        "describe-spot-price-history": {},
        "describe-elastic-gpus": {},
        "describe-capacity-reservations": {},
        "describe-launch-templates": {},
        "describe-launch-template-versions": {},
        "describe-fleet-instances": {},
        "describe-fleets": {},
        "get-console-output": {},
        "get-console-screenshot": {},
        "get-instance-uefi-data": {},
        "list-images-in-recycle-bin": {},
        "list-snapshots-in-recycle-bin": {},
    },
    "lambda": {
        "list-functions": {},
        "list-layers": {},
        "list-layer-versions": {},
        "list-versions-by-function": {},
        "list-aliases": {},
        "get-function": {},
        "get-function-configuration": {},
        "get-layer-version": {},
        "get-alias": {},
        "get-policy": {},
        "get-account-settings": {},
        "get-event-source-mapping": {},
        "list-event-source-mappings": {},
        "get-function-code-signing-config": {},
        "get-code-signing-config": {},
        "list-code-signing-configs": {},
        "list-function-event-invoke-configs": {},
        "get-function-event-invoke-config": {},
        "get-provisioned-concurrency-config": {},
        "list-provisioned-concurrency-configs": {},
    },
    "ecs": {
        "list-clusters": {},
        "list-services": {},
        "list-tasks": {},
        "list-container-instances": {},
        "list-task-definitions": {},
        "list-task-definition-families": {},
        "describe-clusters": {},
        "describe-services": {},
        "describe-tasks": {},
        "describe-task-definition": {},
        "describe-container-instances": {},
        "describe-capacity-providers": {},
        "list-capacity-providers": {},
        "list-attributes": {},
        "list-tags-for-resource": {},
    },
    # Storage services (read-only)
    "s3": {
        "list-buckets": {},
        "list-objects": {},
        "list-objects-v2": {},
        "head-bucket": {},
        "head-object": {},
        "get-bucket-location": {},
        "get-bucket-versioning": {},
        "get-bucket-tagging": {},
        "get-bucket-policy-status": {},
        "get-bucket-encryption": {},
        "get-bucket-cors": {},
        "get-bucket-website": {},
        "get-bucket-lifecycle": {},
        "get-bucket-lifecycle-configuration": {},
        "get-bucket-replication": {},
        "get-bucket-request-payment": {},
        "get-bucket-notification": {},
        "get-bucket-notification-configuration": {},
        "get-bucket-inventory-configuration": {},
        "list-bucket-inventory-configurations": {},
        "get-bucket-metrics-configuration": {},
        "list-bucket-metrics-configurations": {},
        "get-bucket-analytics-configuration": {},
        "list-bucket-analytics-configurations": {},
        "get-bucket-intelligent-tiering-configuration": {},
        "list-bucket-intelligent-tiering-configurations": {},
        "get-object-attributes": {},
        "get-object-legal-hold": {},
        "get-object-lock-configuration": {},
        "get-object-retention": {},
        "get-object-tagging": {},
        "get-object-torrent": {},
        "list-multipart-uploads": {},
        "list-object-versions": {},
        "list-parts": {},
    },
    "s3api": {
        "list-buckets": {},
        "list-objects": {},
        "list-objects-v2": {},
        "head-bucket": {},
        "head-object": {},
        "get-bucket-location": {},
        "get-bucket-versioning": {},
        "get-bucket-tagging": {},
        "get-bucket-policy-status": {},
        "get-bucket-encryption": {},
        "get-bucket-cors": {},
        "get-bucket-website": {},
        "get-bucket-lifecycle": {},
        "get-bucket-lifecycle-configuration": {},
        "get-bucket-replication": {},
        "get-bucket-request-payment": {},
        "get-bucket-notification": {},
        "get-bucket-notification-configuration": {},
        "get-bucket-inventory-configuration": {},
        "list-bucket-inventory-configurations": {},
        "get-bucket-metrics-configuration": {},
        "list-bucket-metrics-configurations": {},
        "get-bucket-analytics-configuration": {},
        "list-bucket-analytics-configurations": {},
        "get-bucket-intelligent-tiering-configuration": {},
        "list-bucket-intelligent-tiering-configurations": {},
        "get-object-attributes": {},
        "get-object-legal-hold": {},
        "get-object-lock-configuration": {},
        "get-object-retention": {},
        "get-object-tagging": {},
        "get-object-torrent": {},
        "list-multipart-uploads": {},
        "list-object-versions": {},
        "list-parts": {},
    },
    "ebs": {
        "describe-volumes": {},
        "describe-volume-status": {},
        "describe-volume-attribute": {},
        "describe-snapshots": {},
        "describe-snapshot-attribute": {},
        "describe-fast-snapshot-restores": {},
        "list-snapshots-in-recycle-bin": {},
    },
    # Database services (read-only)
    "rds": {
        "describe-db-instances": {},
        "describe-db-clusters": {},
        "describe-db-snapshots": {},
        "describe-db-cluster-snapshots": {},
        "describe-db-parameter-groups": {},
        "describe-db-cluster-parameter-groups": {},
        "describe-db-parameters": {},
        "describe-db-cluster-parameters": {},
        "describe-db-subnet-groups": {},
        "describe-db-security-groups": {},
        "describe-option-groups": {},
        "describe-db-log-files": {},
        "describe-db-engine-versions": {},
        "describe-reserved-db-instances": {},
        "describe-reserved-db-instances-offerings": {},
        "describe-event-categories": {},
        "describe-event-subscriptions": {},
        "describe-events": {},
        "describe-pending-maintenance-actions": {},
        "describe-certificates": {},
        "describe-account-quotas": {},
        "describe-orderable-db-instance-options": {},
        "describe-valid-db-instance-modifications": {},
        "list-tags-for-resource": {},
    },
    "dynamodb": {
        "list-tables": {},
        "describe-table": {},
        "describe-time-to-live": {},
        "describe-continuous-backups": {},
        "describe-backup": {},
        "list-backups": {},
        "describe-global-table": {},
        "list-global-tables": {},
        "describe-global-table-settings": {},
        "describe-limits": {},
        "describe-endpoints": {},
        "list-tags-of-resource": {},
        "describe-contributor-insights": {},
        "list-contributor-insights": {},
        "describe-kinesis-streaming-destination": {},
        "describe-table-replica-auto-scaling": {},
        "describe-stream": {},
        "list-streams": {},
    },
    # Monitoring and logging (read-only)
    "cloudwatch": {
        "list-metrics": {},
        "get-metric-statistics": {},
        "get-metric-data": {},
        "describe-alarms": {},
        "describe-alarm-history": {},
        "describe-anomaly-detectors": {},
        "get-dashboard": {},
        "list-dashboards": {},
        "list-tags-for-resource": {},
        "get-insight-selectors": {},
        "get-metric-widget-image": {},
        "describe-insight-rules": {},
    },
    "logs": {
        "describe-destinations": {},
        "describe-export-tasks": {},
        "describe-log-groups": {},
        "describe-log-streams": {},
        "describe-metric-filters": {},
        "describe-queries": {},
        "describe-resource-policies": {},
        "describe-subscription-filters": {},
        "get-log-events": {},
        "filter-log-events": {},
        "get-query-results": {},
        "list-tags-log-group": {},
        "test-metric-filter": {},
    },
    "cloudtrail": {
        "describe-trails": {},
        "get-trail-status": {},
        "list-public-keys": {},
        "list-tags": {},
        "lookup-events": {},
        "get-insight-selectors": {},
        "get-event-selectors": {},
        "describe-query": {},
        "list-queries": {},
        "get-query-results": {},
    },
    # Networking (read-only)
    "elbv2": {
        "describe-load-balancers": {},
        "describe-listeners": {},
        "describe-listener-certificates": {},
        "describe-rules": {},
        "describe-target-groups": {},
        "describe-target-health": {},
        "describe-target-group-attributes": {},
        "describe-load-balancer-attributes": {},
        "describe-ssl-policies": {},
        "describe-account-limits": {},
        "list-tags-for-resource": {},
    },
    "elb": {
        "describe-load-balancers": {},
        "describe-load-balancer-attributes": {},
        "describe-load-balancer-policies": {},
        "describe-load-balancer-policy-types": {},
        "describe-instance-health": {},
        "describe-account-limits": {},
        "list-tags-for-resource": {},
    },
    "route53": {
        "list-hosted-zones": {},
        "list-resource-record-sets": {},
        "get-hosted-zone": {},
        "get-hosted-zone-count": {},
        "get-health-check": {},
        "list-health-checks": {},
        "get-health-check-count": {},
        "get-health-check-status": {},
        "get-health-check-last-failure-reason": {},
        "list-tags-for-resource": {},
        "list-tags-for-resources": {},
        "get-change": {},
        "list-geo-locations": {},
        "get-geo-location": {},
        "get-account-limit": {},
        "get-hosted-zone-limit": {},
        "list-vpc-association-authorizations": {},
        "list-query-logging-configs": {},
        "get-query-logging-config": {},
        "get-dnssec": {},
        "list-cidr-blocks": {},
        "list-cidr-collections": {},
        "list-cidr-locations": {},
        "get-cidr-collection": {},
    },
    "cloudfront": {
        "list-distributions": {},
        "get-distribution": {},
        "get-distribution-config": {},
        "list-streaming-distributions": {},
        "get-streaming-distribution": {},
        "get-streaming-distribution-config": {},
        "list-cloud-front-origin-access-identities": {},
        "get-cloud-front-origin-access-identity": {},
        "get-cloud-front-origin-access-identity-config": {},
        "list-invalidations": {},
        "get-invalidation": {},
        "list-tags-for-resource": {},
    },
    # Identity and Access (read-only)
    "iam": {
        "list-users": {},
        "list-groups": {},
        "list-roles": {},
        "list-policies": {},
        "list-attached-user-policies": {},
        "list-attached-group-policies": {},
        "list-attached-role-policies": {},
        "list-user-policies": {},
        "list-group-policies": {},
        "list-role-policies": {},
        "get-user": {},
        "get-group": {},
        "get-role": {},
        "get-policy": {},
        "get-policy-version": {},
        "list-policy-versions": {},
        "get-account-summary": {},
        "get-account-password-policy": {},
        "list-entities-for-policy": {},
        "list-groups-for-user": {},
        "simulate-custom-policy": {},
        "simulate-principal-policy": {},
        "get-context-keys-for-custom-policy": {},
        "get-context-keys-for-principal-policy": {},
        "list-mfa-devices": {},
        "list-virtual-mfa-devices": {},
        "list-ssh-public-keys": {},
        "get-ssh-public-key": {},
        "list-service-specific-credentials": {},
        "list-access-keys": {},
        "list-signing-certificates": {},
        "get-login-profile": {},
        "generate-credential-report": {},
        "get-credential-report": {},
        "generate-service-last-accessed-details": {},
        "get-service-last-accessed-details": {},
        "get-service-last-accessed-details-with-entities": {},
        "list-policies-granting-service-access": {},
        "list-instance-profiles": {},
        "get-instance-profile": {},
        "list-instance-profiles-for-role": {},
        "list-open-id-connect-providers": {},
        "get-open-id-connect-provider": {},
        "list-saml-providers": {},
        "get-saml-provider": {},
        "list-server-certificates": {},
        "get-server-certificate": {},
        "get-account-authorization-details": {},
        "list-tags-for-user": {},
        "list-tags-for-role": {},
    },
    # Systems Manager (read-only)
    "ssm": {
        "describe-instance-information": {},
        "describe-instance-associations-status": {},
        "describe-instance-patch-states": {},
        "describe-instance-patch-states-for-patch-group": {},
        "describe-parameters": {},
        "get-parameter": {},
        "get-parameters": {},
        "get-parameters-by-path": {},
        "describe-document-parameters": {},
        "describe-document-permission": {},
        "list-documents": {},
        "describe-document": {},
        "get-document": {},
        "list-associations": {},
        "describe-association": {},
        "describe-association-executions": {},
        "describe-association-execution-targets": {},
        "list-command-invocations": {},
        "list-commands": {},
        "get-command-invocation": {},
        "describe-automation-executions": {},
        "describe-automation-step-executions": {},
        "get-automation-execution": {},
        "describe-available-patches": {},
        "describe-effective-instance-associations": {},
        "describe-effective-patches-for-patch-group": {},
        "describe-inventory-deletions": {},
        "describe-maintenance-window-executions": {},
        "describe-maintenance-window-execution-task-invocations": {},
        "describe-maintenance-window-execution-tasks": {},
        "describe-maintenance-window-schedule": {},
        "describe-maintenance-window-targets": {},
        "describe-maintenance-window-tasks": {},
        "describe-maintenance-windows": {},
        "describe-maintenance-windows-for-target": {},
        "describe-ops-items": {},
        "get-ops-item": {},
        "describe-patch-baselines": {},
        "describe-patch-groups": {},
        "get-patch-baseline": {},
        "get-patch-baseline-for-patch-group": {},
        "describe-sessions": {},
        "get-connection-status": {},
        "list-compliance-items": {},
        "list-compliance-summaries": {},
        "list-resource-compliance-summaries": {},
        "list-resource-data-sync": {},
        "list-tags-for-resource": {},
        "get-calendar-state": {},
        "get-inventory": {},
        "get-inventory-schema": {},
        "list-inventory-entries": {},
        "get-ops-metadata": {},
        "list-ops-metadata": {},
        "get-service-setting": {},
        "list-document-versions": {},
    },
    # Help and information
    "help": {},
    "version": {},
    # Completion
    "completion": {},
}


DENIED_AWS_COMMANDS: dict[str, dict] = {
    # Services that modify state or access sensitive data
    "configure": {},
    "deploy": {},
    "s3-sync": {},
    # Services that can access secrets/sensitive data
    "secretsmanager": {},
    "kms": {},
    "ssm-get-parameter": {},  # Can access secrets in Parameter Store
    "sts": {},  # Can return credentials/tokens
    "cognito-identity": {},
    "cognito-idp": {},
    # Services that perform actions
    "ses": {},
    "sns": {},
    "sqs": {},
    "kinesis": {},
    "firehose": {},
    "glue": {},
    "athena": {},
    "redshift": {},
    "emr": {},
    "batch": {},
    "ecs-execute-command": {},  # Can execute commands in containers
    # Wildcard operations that apply to all services
    "*": {
        # Create operations
        "create-*": {},
        "run-*": {},
        "start-*": {},
        "launch-*": {},
        "allocate-*": {},
        "associate-*": {},
        "attach-*": {},
        "authorize-*": {},
        "import-*": {},
        "register-*": {},
        # Modify operations
        "modify-*": {},
        "update-*": {},
        "put-*": {},
        "set-*": {},
        "replace-*": {},
        "reset-*": {},
        "configure-*": {},
        "enable-*": {},
        "disable-*": {},
        "change-*": {},
        "edit-*": {},
        "tag-*": {},
        "untag-*": {},
        # Delete operations
        "delete-*": {},
        "terminate-*": {},
        "stop-*": {},
        "cancel-*": {},
        "deregister-*": {},
        "detach-*": {},
        "disassociate-*": {},
        "remove-*": {},
        "revoke-*": {},
        "release-*": {},
        "deallocate-*": {},
        # Actions that can trigger changes
        "invoke": {},
        "reboot-*": {},
        "restore-*": {},
        "copy-*": {},
        "move-*": {},
        "migrate-*": {},
        "promote-*": {},
        "failover-*": {},
        "rebuild-*": {},
        "resize-*": {},
        "scale-*": {},
        "invoke-*": {},  # Lambda invocations
        "send-*": {},  # SES/SNS sending
        "publish-*": {},  # SNS publishing
        "execute-*": {},  # Executing commands/queries
        # S3 specific file operations
        "cp": {},  # s3 cp
        "mv": {},  # s3 mv
        "rm": {},  # s3 rm
        "mb": {},  # s3 mb (make bucket)
        "rb": {},  # s3 rb (remove bucket)
        "sync": {},  # s3 sync
        # Sensitive data access
        "get-secret-*": {},
        "get-parameter-*": {},  # Can access sensitive SSM parameters
        "decrypt-*": {},
        "generate-*": {},
        "assume-*": {},
        "get-session-token": {},
        "get-federation-token": {},
        "get-caller-identity": {},
    },
}
