import re


SAFE_NAME_PATTERN = re.compile(r"^[a-zA-Z0-9][a-zA-Z0-9\-_.]*$")
SAFE_NAMESPACE_PATTERN = re.compile(r"^[a-z0-9][a-z0-9\-]*$")
SAFE_SELECTOR_PATTERN = re.compile(r"^[a-zA-Z0-9\-_.=,!()]+$")
SAFE_JQ_PATTERN = re.compile(r"^[a-zA-Z0-9.][a-zA-Z0-9\-_.]*$")


VALID_RESOURCE_TYPES = {
    "pods",
    "pod",
    "po",
    "services",
    "service",
    "svc",
    "deployments",
    "deployment",
    "deploy",
    "replicasets",
    "replicaset",
    "rs",
    "statefulsets",
    "statefulset",
    "sts",
    "daemonsets",
    "daemonset",
    "ds",
    "jobs",
    "job",
    "cronjobs",
    "cronjob",
    "cj",
    "configmaps",
    "configmap",
    "cm",
    "persistentvolumes",
    "persistentvolume",
    "pv",
    "persistentvolumeclaims",
    "persistentvolumeclaim",
    "pvc",
    "nodes",
    "node",
    "no",
    "namespaces",
    "namespace",
    "ns",
    "ingresses",
    "ingress",
    "ing",
    "networkpolicies",
    "networkpolicy",
    "netpol",
    "serviceaccounts",
    "serviceaccount",
    "sa",
    "roles",
    "role",
    "rolebindings",
    "rolebinding",
    "clusterroles",
    "clusterrole",
    "clusterrolebindings",
    "clusterrolebinding",
    "endpoints",
    "endpoint",
    "ep",
    "events",
    "event",
    "ev",
    "horizontalpodautoscalers",
    "horizontalpodautoscaler",
    "hpa",
    "verticalpodautoscalers",
    "verticalpodautoscaler",
    "vpa",
    "poddisruptionbudgets",
    "poddisruptionbudget",
    "pdb",
    "all",
}
