# Contributing to Healthyself Journal

Thanks for your interest in contributing! This project aims to make reflective journaling more accessible through voice input and evidence-based questions.

## Getting Started

1. **Setup**: See [docs/reference/SETUP_DEV.md](docs/reference/SETUP_DEV.md) for development environment setup
2. **Architecture**: Review [docs/reference/ARCHITECTURE.md](docs/reference/ARCHITECTURE.md) to understand the system
3. **Quick guidance**: Check [AGENTS.md](AGENTS.md) for a project overview

## Making Changes

- Fork the repo and create a feature branch
- Follow existing code patterns (check neighboring files for conventions)
- Run tests: `pytest tests/test_*.py` (see [TESTING.md](TESTING.md))
- Submit a pull request with a clear description of changes

## Philosophy

This project prioritizes:
- **Voice-first** interaction to reduce friction
- **Privacy by default** with local processing options
- **Simple, maintainable** solutions over complex abstractions

## Questions?

Feel free to open an issue for discussion. The project is in early stages, so feedback and ideas are welcome!

## License

By contributing, you agree that your contributions will be licensed under the same license as the project.