# Global Crisis Resources Catalogue

## Introduction

This document provides a comprehensive, verified catalogue of crisis helpline numbers, text services, and online support resources for mental health and suicide prevention across countries worldwide. These resources are essential for the journaling app to provide appropriate, accurate, and potentially life-saving support to users regardless of their location.

**Purpose**: To ensure users experiencing emotional distress or crisis have immediate access to professional, verified support services in their region.

**Critical Context**: Research found that 9% of mental health apps with 1M+ downloads provided **erroneous crisis helpline numbers**. This catalogue maintains high verification standards to prevent such dangerous errors.

## See Also

- `SAFEGUARDING.md` – Safeguarding principles and guardrails
- `INSIGHTS.md` – Insights feature boundaries and crisis detection considerations
- `PRODUCT_VISION_FEATURES.md` – Evidence-based product approach
- `../conversations/251017a_safeguarding_crisis_resources_research.md` – Research findings on crisis resources
- `../planning/251017d_global_crisis_resources_catalogue.md` – Planning and research methodology
- `UPDATE_CRISIS_RESOURCES.md` – Quarterly verification procedures

## How to Use This Resource

### For Developers

1. **Integration**: These resources should be accessible within the app's dialogue flow, especially when crisis indicators are detected
2. **Display**: Show resources visually even in voice-first mode (long phone numbers are error-prone when spoken)
3. **Geography**: Consider asking users for their location once, or detecting from system locale with manual override
4. **Privacy**: Consider whether to log crisis resource access (anonymous logging recommended)

### For Users

If you're experiencing a crisis or need immediate support:
- **Emergency (life-threatening)**: Call local emergency services (999 UK, 911 US, 112 EU, etc.)
- **Crisis support**: Use the resources below for your country
- **All services listed** are free, confidential, and staffed by trained professionals

### Important Disclaimers

⚠️ **Accuracy**: All resources have been verified with official sources as of October 2025. However, numbers and services can change. If you encounter an error, please report it.

⚠️ **Not a replacement**: These resources do not replace emergency services for immediate, life-threatening situations.

⚠️ **Geographic restrictions**: Some numbers may not work internationally. Use country-specific numbers when possible.

## Verification Methodology

**Standards Applied:**
- ✅ All resources verified through official government or NGO websites
- ✅ Multiple authoritative sources cross-referenced where possible
- ✅ Verification date and source URL documented for each entry
- ✅ Service characteristics confirmed (24/7 availability, free access, languages)

**Verification Date**: October 2025

**Next Verification Due**: January 2026 (quarterly schedule)

**Update Process**: See `UPDATE_CRISIS_RESOURCES.md`

---

## International/Multi-Country Resources

### Find A Helpline (powered by ThroughLine)
**Coverage**: 150+ countries, 1,300+ verified services

- **Website**: https://findahelpline.com/i/iasp
- **Description**: The largest, most accurate helpline resource in the world, maintained by ThroughLine in partnership with IASP
- **Features**: Auto-detects location, provides local crisis services
- **Languages**: Multiple languages based on region
- **Verification**: Official IASP partnership, continuously updated
- **Source**: https://www.iasp.info/crisis-centres-helplines/
- **Verified**: October 2025

### Befrienders Worldwide
**Coverage**: 349 emotional support centres in 32 countries

- **Website**: https://befrienders.org
- **Map**: https://befrienders.org/map/
- **Description**: International network providing emotional support to people who are suicidal or in distress
- **Contact Methods**: Phone, email, SMS, internet chat, or in-person (varies by location)
- **Estimated Reach**: 7 million people annually
- **Verification**: Official organization website with individual centre listings
- **Source**: https://befrienders.org/
- **Verified**: October 2025

---

## North America

### United States

#### 988 Suicide & Crisis Lifeline
**Primary national crisis line**

- **Phone**: 988 (call or text)
- **Chat**: https://988lifeline.org
- **Hours**: 24/7/365
- **Cost**: Free and confidential
- **Languages**: English (default), Spanish (press 2 or text "AYUDA" to 988)
- **Special Features**: Trained counselors, georouting for local resources
- **Description**: The national mental health crisis lifeline providing immediate support
- **Source**: https://www.samhsa.gov/mental-health/988
- **Source**: https://www.fcc.gov/988-suicide-and-crisis-lifeline
- **Verified**: October 2025

#### Crisis Text Line
- **Text**: HOME to 741741
- **WhatsApp**: 443-SUPPORT (English) or 442-AYUDAME (Spanish)
- **Hours**: 24/7
- **Cost**: Free
- **Languages**: English, Spanish
- **Description**: Text-based crisis support, typically connected within 5 minutes
- **Populations**: All crises including anxiety, depression, self-harm, suicidal thoughts
- **Source**: https://www.crisistextline.org
- **Verified**: October 2025

#### Veterans Crisis Line
- **Phone**: 988, then press 1
- **Text**: 838255
- **Chat**: https://www.veteranscrisisline.net/chat
- **Hours**: 24/7
- **Who**: Veterans, service members, National Guard, Reserve, and supporters
- **Note**: Don't need to be enrolled in VA benefits to use
- **Source**: https://www.veteranscrisisline.net
- **Verified**: October 2025

#### The Trevor Project (LGBTQ+ Youth)
- **Phone**: 1-866-488-7386
- **Text**: START to 678678
- **Chat**: https://www.thetrevorproject.org/get-help
- **Hours**: 24/7/365
- **Cost**: Free and confidential
- **Who**: LGBTQ+ young people under 25
- **Description**: Crisis counselors trained in LGBTQ+ issues
- **Note**: 2025 - continues to operate independently after 988 LGBTQ+ specialized services ended
- **Source**: https://www.thetrevorproject.org
- **Verified**: October 2025

### Canada

#### 988 Suicide Crisis Helpline
**National crisis line**

- **Phone**: 988 (call or text)
- **Hours**: 24/7
- **Cost**: Free
- **Languages**: English, French, additional support in Cree, Ojibwe, Inuktitut (via Hope for Wellness Helpline)
- **Description**: Federally funded service delivered through 39 partner centres nationwide
- **Operated by**: Centre for Addiction and Mental Health (CAMH)
- **Launched**: November 30, 2023
- **Source**: https://mentalhealthcommission.ca/catalyst/988-launches-in-canada/
- **Verified**: October 2025

#### Kids Help Phone
- **Phone**: 1-800-668-6868
- **Text**: CONNECT to 686868
- **Chat**: Available 7 PM - midnight ET at kidshelpphone.ca
- **Hours**: 24/7
- **Languages**: English, French, plus 100+ languages via interpreters (including Plains Cree, Severn Ojibwe, Ukrainian, Russian, Pashto, Dari, Mandarin, Arabic)
- **Who**: Young people (youth and young adults)
- **Special**: Indigenous youth can text FIRST NATIONS, INUIT, or METIS to 686868 for culturally-appropriate support
- **Source**: https://kidshelpphone.ca
- **Verified**: October 2025

---

## Europe

### United Kingdom

#### Samaritans
- **Phone**: 116 123 (UK and Ireland)
- **Email**: jo@samaritans.org (reply within 24 hours)
- **Hours**: 24/7, 365 days/year
- **Cost**: Free from all phones (won't appear on phone bill)
- **Languages**: English
- **Description**: Emotional support for anyone in distress, struggling to cope, or at risk of suicide
- **In-person**: Available at local branches
- **Source**: https://www.samaritans.org
- **Verified**: October 2025

#### SHOUT Crisis Text Line
- **Text**: SHOUT to 85258
- **Regional keywords**: EYUP (South Yorkshire), HEAR (Cambridgeshire), SUSSEX, THEMIX (under 25)
- **Hours**: 24/7
- **Cost**: Free from all major UK mobile networks
- **Who**: Anyone in UK struggling with mental health
- **Description**: Text-based support from trained Crisis Responders
- **Partnership**: Mental Health Innovations & Crisis Text Line
- **Source**: https://giveusashout.org
- **Verified**: October 2025

#### NHS 111 Mental Health Option
- **Phone**: 111, select mental health option
- **Online**: 111.nhs.uk
- **Hours**: 24/7
- **Cost**: Free
- **Who**: Anyone in the UK (for self or others)
- **BSL**: British Sign Language service available
- **Description**: Access to NHS mental health crisis support
- **Note**: Some NHS trusts have additional 24/7 crisis lines
- **Source**: https://www.nhs.uk/nhs-services/mental-health-services/where-to-get-urgent-help-for-mental-health/
- **Verified**: October 2025

### Ireland

#### Samaritans Ireland
- **Phone**: 116 123 (free)
- **Email**: jo@samaritans.ie
- **Hours**: 24/7
- **Cost**: Free
- **Description**: Same service as UK Samaritans, emotional support by trained volunteers
- **Source**: https://www.samaritans.org/samaritans-ireland/
- **Verified**: October 2025

#### Pieta House
- **Phone**: 1800 247 247
- **Text**: HELP to 51444
- **Hours**: 24/7
- **Cost**: Free
- **Who**: People with suicidal ideation, engaging in self-harm, or bereaved by suicide
- **Staff**: Qualified therapists
- **Services**: Free counselling available
- **Source**: Government listings via hse.ie
- **Verified**: October 2025

#### Text About It
- **Text**: HELLO to 50808
- **Hours**: 24/7
- **Cost**: Free
- **Funded by**: HSE (Health Service Executive)
- **Description**: Safe space with trained listening volunteers
- **Website**: textaboutit.ie
- **Source**: Government mental health services listings
- **Verified**: October 2025

### Germany

#### Telefonseelsorge
- **Phone**: 0800 111 0 111 or 0800 111 0 222 or 116 123
- **Online chat**: Available via website
- **Email**: Available via website
- **Hours**: 24/7
- **Cost**: Free and anonymous
- **Languages**: German
- **Who**: All German-speaking people at home and abroad
- **Volunteers**: 7,500 trained volunteers
- **Source**: https://gesund.bund.de/en/emergency-numbers (German government)
- **Source**: U.S. Embassy in Germany mental health resources
- **Verified**: October 2025

### France

#### 3114 - National Suicide Prevention Line
- **Phone**: 3114
- **Hours**: 24/7 (24h/24, 7j/7)
- **Cost**: Free and confidential
- **Languages**: French
- **Staff**: Healthcare professionals (nurses, psychologists) trained in suicide prevention
- **Launched**: October 1, 2021 by French Ministry of Health
- **Website**: https://3114.fr
- **Source**: French government health ministry
- **Verified**: October 2025

#### SOS Amitié
- **Phone**: 09 72 39 40 50
- **English line**: 01 46 21 46 46
- **Chat**: Monday-Sunday, 13h-3h via website
- **Hours**: 24/7 (phone)
- **Cost**: Free, anonymous, confidential
- **Description**: Volunteer-based listening service for difficult times
- **Source**: https://www.infosuicide.org
- **Verified**: October 2025

### Netherlands

#### 113 Zelfmoordpreventie (Suicide Prevention)
- **Phone**: 113 (standard rate) or 0800-0113 (free)
- **Chat**: Available via website
- **Hours**: 24/7
- **Who**: People with thoughts of suicide and their loved ones
- **Languages**: Dutch
- **Calls**: ~500/day
- **Organization**: National suicide prevention centre, government-funded
- **Emergency**: Call 112 for life-threatening situations
- **Website**: https://www.113.nl
- **Source**: Dutch government (rijksoverheid.nl), official 113 website
- **Verified**: October 2025

### Spain

#### Teléfono de la Esperanza
- **Phone**: 717 003 717 (primary), 914 590 050, 914 590 055
- **Hours**: 24 hours
- **Cost**: Free, anonymous
- **Description**: Emotional crisis intervention service
- **Source**: Government listings, organization social media
- **Note**: Previous references to 717 00 37 37 may be outdated formatting
- **Verified**: October 2025

---

## Asia-Pacific

### Australia

#### Lifeline
- **Phone**: 13 11 14
- **Text**: 0477 13 11 14
- **Chat**: 24/7 via lifeline.org.au
- **Hours**: 24/7
- **Cost**: Free from mobiles (pre-paid and post-paid)
- **Description**: Australia's largest crisis support and suicide prevention service
- **Staff**: Trained Crisis Supporters
- **Website**: https://www.lifeline.org.au
- **Source**: Official Lifeline Australia website
- **Verified**: October 2025

#### Beyond Blue
- **Phone**: 1300 22 4636
- **Chat**: Available via website
- **Email**: Available via website
- **Hours**: 24/7
- **Cost**: Free and confidential
- **Who**: Anyone in Australia
- **Topics**: Anxiety, bullying, depression, grief, loneliness, self-harm, stress, suicide, trauma, PTSD
- **Accessibility**: National Relay Service (TRS), Translating and Interpreting Service (TIS) available 24/7
- **Programs**: NewAccess free mental health coaching
- **Website**: https://www.beyondblue.org.au
- **Source**: Official Beyond Blue website, healthdirect.gov.au
- **Verified**: October 2025 (last reviewed March 2025)

### New Zealand

#### 1737
- **Phone**: 1737 or 0800 1737 1737
- **Text**: 1737
- **Hours**: 24/7
- **Cost**: Free
- **Who**: Anyone in New Zealand
- **Staff**: Trained counsellors and peer support workers
- **Operator**: Whakarongorau Aotearoa / New Zealand Telehealth Services
- **Funded by**: Health New Zealand
- **Description**: Brief emotional support, not for severe mental illness emergencies
- **Website**: https://www.1737.org.nz
- **Source**: Official 1737 website, healthed.govt.nz
- **Verified**: October 2025 (content updated August 2025)

#### Lifeline Aotearoa
- **Phone**: 0800 543 354 (0800 LIFELINE)
- **Text**: HELP (4357)
- **Hours**: 24/7
- **Cost**: Free
- **Additional**: Suicide Crisis Helpline 0508 828 865 (free nationwide)
- **Who**: Everyone in New Zealand
- **Topics**: Anxiety, depression, self-harm, stress, suicide
- **History**: Helping New Zealanders for 60+ years
- **Website**: https://www.lifeline.org.nz
- **Source**: Official Lifeline Aotearoa website
- **Verified**: October 2025

### India

#### AASRA
- **Phone**: +91-22-27546669 (or 022-27546669 domestic)
- **Email**: aasrahelpline@yahoo.com
- **Hours**: 24/7 nationwide
- **Who**: Anyone in India
- **Location**: Navi Mumbai (serves all of India)
- **Description**: Crisis intervention for lonely, distressed, and suicidal individuals
- **Staff**: Professionally trained volunteers
- **Source**: Official AASRA website, multiple crisis helpline directories
- **Verified**: October 2025

#### Vandrevala Foundation
- **Phone**: 1860-2662-345 or +91-22-2570-6000
- **Text/WhatsApp**: +91-9999666555 (international WhatsApp)
- **Chat**: Available via website
- **Hours**: 24/7
- **Cost**: Free
- **Languages**: English, Hindi, regional languages (counselors in every state)
- **Who**: Anyone in India
- **Topics**: Abuse, anxiety, bullying, depression, grief, LGBTQ+ issues, self-harm, suicide, trauma
- **Services**: Voice calls, WhatsApp counseling
- **Website**: https://www.vandrevalafoundation.com
- **Source**: Official Vandrevala Foundation website, government listings
- **Verified**: October 2025

### Japan

#### TELL (Tokyo English Lifeline)
- **Phone**: 03-5774-0992
- **Chat**: 10:30 PM - 2 AM Fri/Sat/Sun via telljp.com/lifeline/tell-chat/
- **Hours**: 9 AM - 11 PM daily (phone)
- **Cost**: Free, anonymous, confidential
- **Languages**: English
- **Who**: English speakers in Japan
- **Description**: Emotional support and referrals from trained counselors
- **Recommended by**: U.S. Embassy in Japan
- **Website**: https://telljp.com
- **Source**: Official TELL website, U.S. Embassy, IASP listings
- **Verified**: October 2025

### Singapore

#### Samaritans of Singapore (SOS)
- **Phone**: 1767 (24-hour hotline)
- **Text/WhatsApp**: 9151 1767 (CareText)
- **Email**: pat@sos.org.sg (CareMail)
- **Hours**: 24/7
- **Who**: Individuals facing crisis, thinking about suicide, or affected by suicide
- **Founded**: 1969
- **Description**: Confidential emotional support from trained volunteers
- **Note**: Old number 1800-221-4444 has been replaced by 1767
- **Website**: https://www.sos.org.sg
- **Source**: Official SOS website, government listings
- **Verified**: October 2025

---

## Middle East & Africa

### South Africa

#### SADAG (South African Depression and Anxiety Group)
- **Suicide Crisis Helpline**: 0800 567 567
- **Office**: 011 234 4837 (8 AM - 5 PM)
- **Text**: 31393
- **WhatsApp**: Available
- **Hours**: 24/7 (crisis line)
- **Cost**: Toll-free
- **Description**: South Africa's only 24/7 Suicide Crisis Helpline
- **Organization**: Country's leading mental health support organization
- **Staff**: Trained counselors
- **Website**: https://www.sadag.org
- **Source**: Official SADAG website, government listings
- **Verified**: October 2025

---

## Latin America

### Brazil

#### CVV (Centro de Valorização da Vida)
- **Phone**: 188
- **Chat**: Available via cvv.org.br
- **Email**: Available via website
- **In-person**: Available at some locations in 20 states + Federal District
- **Hours**: 24/7 (phone)
- **Cost**: Free (no cost on 188), confidential, anonymous
- **Languages**: Portuguese
- **Volunteers**: ~3,300 volunteers
- **Contacts**: 2.7 million annual contacts
- **Founded**: 1962 in São Paulo
- **Campaign**: Setembro Amarelo (September Yellow) - national suicide prevention
- **Website**: https://cvv.org.br
- **Source**: Official CVV website, Brazilian government health ministry
- **Verified**: October 2025

---

## Implementation Guidance

### Geographic Selection Strategies

**Option A: User Selection at First Launch**
- Pros: Accurate, respects user privacy
- Cons: Requires user action, may be skipped
- Implementation: Config setting `default_country` in user settings

**Option B: Auto-detect from System Locale**
- Pros: Zero friction, works immediately
- Cons: May be incorrect for travelers, VPN users
- Implementation: Python `locale.getdefaultlocale()` with manual override option

**Option C: Show International + User's Country (Recommended)**
- Pros: Always shows Find A Helpline (works everywhere), plus local resources
- Cons: Slightly longer list
- Implementation: Always show international section + detected/selected country resources

### When to Surface Resources

1. **On explicit request**: User says "I need help" or "crisis resources"
2. **Crisis pattern detection** (if implemented): Detected indicators trigger gentle offer of resources
3. **Session boundaries footer**: Brief mention available at end of sessions
4. **Standalone CLI command**: `healthyselfjournal help crisis` shows resources

### Displaying Resources

**Voice-first considerations:**
- ❌ Don't read long phone numbers aloud (error-prone)
- ✅ Display visually on terminal
- ✅ Offer to "show crisis resources on screen"
- ✅ Provide short, memorable numbers when possible

**CLI Display Format:**
```
If you need immediate support, these free, confidential resources are available 24/7:

UK:
  Samaritans: 116 123 (call) or text SHOUT to 85258
  NHS Mental Health: Call 111

US:
  988 Suicide & Crisis Lifeline: Call or text 988
  Crisis Text Line: Text HOME to 741741

Find A Helpline (150+ countries): https://findahelpline.com
```

### Privacy Considerations

**What to log:**
- ✅ "Crisis resources accessed" (anonymous count)
- ✅ Timestamp of access (for pattern analysis)

**What NOT to log:**
- ❌ Which specific resource was used
- ❌ User's country/location
- ❌ Session content leading to access

**Privacy Policy Note**: Add clear statement about what crisis-related data is/isn't logged

### Accessibility Features

**For Deaf/Hard of Hearing:**
- Include text/SMS options prominently
- Note services with TTY/video relay available
- Chat services listed where available

**For Non-English Speakers:**
- Highlight multilingual services
- Note interpreter availability (e.g., Kids Help Phone, Beyond Blue)
- Include services in major languages

**For Specific Populations:**
- LGBTQ+ youth: Trevor Project
- Veterans: Veterans Crisis Line
- Youth: Kids Help Phone
- Separate section for population-specific services

---

## Maintenance and Updates

### Quarterly Verification Schedule

**Q1 2026 (January)**: Full verification of all resources
- Check all phone numbers are still operational
- Verify websites are live and URLs unchanged
- Check for service changes or discontinuations
- Review hours of operation

**Process**: See `UPDATE_CRISIS_RESOURCES.md`

### Reporting Errors

If you encounter an incorrect number or outdated information:

1. **Immediate**: Note the error with date and details
2. **Verify**: Check official source website
3. **Update**: Correct this document with new verification date
4. **Document**: Note change in git commit message
5. **Consider**: Add to "Known Issues" section if widespread

### Adding New Resources

When adding newly discovered resources:

1. **Verify** with at least 2 authoritative sources (government, established NGO, academic)
2. **Document** source URLs and verification date
3. **Test** if possible (check website is live, phone number format correct)
4. **Include** all standard fields (hours, cost, languages, populations served)
5. **Update** "Last Verified" date for affected section

### Deprecation Process

When a service shuts down or changes:

1. **Strike through** old information: ~~0800 OLD NUMBER~~
2. **Note** deprecation date and replacement if any
3. **Update** references in code/prompts
4. **Keep** historical record for 6 months
5. **Remove** entirely after 6 months if no replacement

---

## Statistics and Coverage

### Coverage Summary (October 2025)

- **Countries with verified resources**: 19
- **Total services catalogued**: 40+
- **24/7 services**: 95%+
- **Free services**: 100%
- **Services with text/chat options**: 70%+
- **Multilingual services**: 30%+

### International Directory Coverage

- **Find A Helpline**: 150+ countries, 1,300+ services
- **Befrienders Worldwide**: 32 countries, 349 centres

### Known Gaps

**Regions needing more research:**
- Middle East (outside Israel): Limited verified resources found
- Africa (outside South Africa): Few national crisis lines identified
- Southeast Asia: Many countries lack nationwide services
- Eastern Europe: Language barriers in verification
- Central Asia: Limited online resources available

**Populations needing more resources:**
- Deaf/hard of hearing: Few dedicated TTY/video relay services catalogued
- Indigenous populations: Limited culturally-appropriate services (exception: Canada)
- Older adults: No age-specific services identified
- Refugees/immigrants: Language-specific services limited

---

## Research Sources and References

### Primary Sources

1. **IASP (International Association for Suicide Prevention)**
   - https://www.iasp.info/crisis-centres-helplines/
   - Partnership with Find A Helpline/ThroughLine

2. **Befrienders Worldwide**
   - https://befrienders.org/
   - https://befrienders.org/map/

3. **Find A Helpline (ThroughLine)**
   - https://findahelpline.com
   - 150+ countries, continuously updated

### Government Health Authorities

- UK: NHS (nhs.uk), UK Government
- US: SAMHSA (samhsa.gov), FCC, VA
- Canada: Mental Health Commission of Canada, CAMH
- Australia: healthdirect.gov.au
- New Zealand: healthed.govt.nz
- Germany: gesund.bund.de (Federal Ministry of Health)
- France: French Ministry of Health
- Netherlands: rijksoverheid.nl
- Ireland: HSE (hse.ie)
- Brazil: Brazilian Health Ministry

### Research Studies Cited

1. **BMC Medicine systematic assessment (69 apps)**
   - Finding: 9% provided erroneous crisis helpline numbers
   - Finding: Only 7% incorporated all 6 evidence-based suicide prevention strategies

2. **NICE Digital Health Technologies Framework**
   - Standard: Demonstrate safety and benefit outweighs risk
   - Requirement: Verified crisis resources are part of safety measures

3. **WHO Guidelines on Digital Health Interventions**
   - Ethics and governance standards for AI/digital health

### Additional Verification Sources

- U.S. Embassies in various countries (mental health resource pages)
- National suicide prevention organizations
- Crisis Text Line (international)
- Individual service websites (primary source for each entry)

---

## Appendix: Service Change History

**Format**: [Date] - [Country/Service] - [Change Description] - [Verification Source]

- **October 2025**: Initial catalogue created with comprehensive verification
- **July 2025**: Singapore SOS changed from 1800-221-4444 to 1767 (verified via sos.org.sg)
- **November 2023**: Canada launched 988 service (verified via Mental Health Commission)
- **July 2022**: US launched 988 (replacing 1-800-273-8255 as primary number)
- **October 2021**: France launched 3114 national prevention line
- **September 2015**: UK Samaritans changed to 116 123 (from 0845)

*Note: This history section should be updated with each verification cycle*

---

## Contact for Updates

To report errors or suggest additions to this catalogue:

1. **GitHub Issues**: Submit issue to healthyselfjournal repository
2. **Email**: Contact project maintainer
3. **Pull Request**: Submit PR with verified new resources

All updates must include:
- Source verification (official website URL)
- Date of verification
- Details of what changed or what to add

---

**Document Last Updated**: October 17, 2025
**Next Verification Due**: January 2026
**Document Maintainer**: Project Lead
**Verification Standard**: Quarterly with source documentation


----
---
## Appendix: Crisis Protocol and Safeguarding Guidance

### Crisis/suicidality: recommended in-app protocol (voice-first, local-first)
- **Detection triggers (examples, not exhaustive)**
  - High-risk phrases: explicit self-harm intent, plans, means, timeframes; “can’t go on,” “I want to die,” “hurt myself,” “kill myself.”
  - Severe hopelessness/acute distress: repeated “no way out,” “everyone better off without me.”
- **Immediate response behavior**
  - Stop reflective dialogue immediately; switch to a fixed, neutral crisis message. No coaching, advice, or exploration of plans/means.
  - Offer crisis resources with regional options (embed offline-capable numbers; allow config override in `user_config.toml`).
  - Encourage contacting a trusted person now; emphasize help and hope; plain tone (no praise/superlatives/emojis).
  - Terminate the session gracefully after showing resources; suggest returning when safe. Avoid rumination loops.
- **Resource set (embed; adapt by region, show at least a global fallback)**
  - US: 988 Suicide & Crisis Lifeline (call or text 988); 911 for immediate danger; Crisis Text Line text HOME to 741741; Trevor Project (LGBTQ+ youth) 1‑866‑488‑7386 / text START to 678678.
  - UK/ROI: Samaritans 116 123; 999/112 for immediate danger; Shout text SHOUT to 85258.
  - CA: Talk Suicide Canada 1‑833‑456‑4566; text 45645; 911.
  - AU: Lifeline 13 11 14; 000.
  - Global: IASP helpline directory (link).
- **Prompt/LLM guardrails (put in `healthyselfjournal/prompts/question.prompt.md.jinja`)**
  - “If the input suggests imminent self‑harm or active suicidal ideation, output only the crisis message template. Do not ask follow‑ups. Do not discuss methods. Do not provide advice.”
  - Always avoid diagnostic labels, causal interpretations, or prescriptive advice.
- **Runtime guardrails (optional heuristic layer)**
  - Local phrase matcher with allowlist/denylist and short cooldown to avoid repeated triggers.
  - Log a minimal, non-content event (e.g., “crisis_flagged=true” with timestamp) to `sessions/events.log`; do not store verbatim content.
  - Expose region/resource config (CLI flag and `user_config.toml`) and a “panic keyword” (e.g., user says “help”) that shows the same message.
- **Testing**
  - Unit tests that assert the crisis template replaces normal responses on trigger phrases; tests that boundaries/footer are present; no method words echoed.

#### Crisis message template (neutral tone, region-agnostic shell)
```text
I’m really sorry you’re going through this. If you’re in immediate danger, please contact your local emergency services now.

If you’re in the US, you can call or text 988 (Suicide & Crisis Lifeline). In the UK or Ireland, you can call Samaritans at 116 123. For other countries, see the International Association for Suicide Prevention directory. You can also text a trained counselor (US: text HOME to 741741; UK: text SHOUT to 85258; CA: text 45645).

I’m a journaling tool and can’t keep you safe in a crisis. Reaching a person now can help—consider calling someone you trust. We can continue journaling another time when you feel safer.
```

### Other major safeguarding areas to guard against (with app-level handling)
- Harm to others / violent intent: Show “cannot assist with harm” + emergency services guidance; terminate session.
- Domestic/sexual violence, stalking, trafficking: Provide country-specific hotlines; avoid advice; end session if immediate danger suggested.
- Child abuse/endangerment, minors using the app: Adults-only positioning; if under 18 content surfaces, show child-appropriate hotlines and stop dialogue.
- Eating disorders/self-harm behaviors: Avoid body/weight/method details; present professional resources; pivot or terminate if acute risk.
- Psychosis/mania, severe dissociation: Avoid interpretation; suggest professional help; terminate if safety is unclear.
- Substance overdose/withdrawal risk: Provide emergency guidance and hotlines; stop session if acute.
- Medical emergencies (chest pain, stroke, etc.): Advise emergency services immediately; terminate session.
- Suicidal contagion/media-effect risks: Never repeat method details; use neutral, non-sensational language; emphasize help/hope.
- Privacy/data security: Local-first storage; easy redaction/deletion; no cloud backup by default; consider optional session encryption; avoid storing crisis verbatims.
- Overuse/dependence/parasitic parasocial dynamics: Weekly usage reflection; 20‑min break nudges; neutral tone (anti‑sycophancy); emphasize user agency and offline action.
- Legal/regulatory boundaries: Not medical advice, not a crisis service, not a medical device; explicit scope boundaries in UI and prompts; avoid duty-to-warn claims (app is local and non-monitoring).

### Implementation trade-offs (brief)
- Sensitivity vs specificity: Prefer a conservative trigger set plus manual “help” keyword; false positives end a session but are safer than false negatives.
- Region routing: Simple config-driven region selection beats geo-IP (offline-first); include a global fallback.
- Data retention: Minimal event metadata; configurable auto-redaction of the last N seconds around a crisis trigger.
- UX: Non-blocking break nudges; crisis flow must be blocking and terminate session.

### Two quick questions
1) Which regions should we support first for embedded numbers (US/UK/CA/AU, plus global IASP)?
2) Do you want crisis triggers to auto-redact recent transcript audio/text, or just avoid logging content and leave files intact?

### Pointers to align with your docs
- Safeguarding principles and operational guardrails: `docs/reference/SAFEGUARDING.md`
- Product values and break nudges: `docs/reference/PRODUCT_VISION_FEATURES.md`
- Risk topics and escalation: `docs/research/RESEARCH_TOPICS.md` (Tier 6, rumination/circuit-breakers)
- Evidence and workflow standards: `docs/reference/SCIENTIFIC_RESEARCH_EVIDENCE_PRINCIPLES.md`

### References (authoritative)
- WHO (2023) Ethics and governance of AI for health [link](https://www.who.int/publications/i/item/9789240077989)
- NICE (2022) Evidence Standards Framework for Digital Health Technologies [link](https://www.nice.org.uk/about/what-we-do/our-programmes/evidence-standards-framework-for-digital-health-technologies)
- 988 Suicide & Crisis Lifeline (US) guidance and resources [link](https://988lifeline.org)
- Samaritans guidance for online services and talking about suicide [link](https://www.samaritans.org)
- Crisis Text Line (US/UK/CA) counsel-by-text numbers [link](https://www.crisistextline.org)
- IASP international helpline directory [link](https://www.iasp.info/resources/Crisis_Centres)



