# Update Crisis Resources - Quarterly Verification Procedure

## Purpose

This document provides step-by-step instructions for verifying and updating the global crisis resources catalogue (`docs/reference/GLOBAL_CRISIS_RESOURCES.md`) on a quarterly basis. Regular verification is critical to ensure accuracy - research found that 9% of mental health apps provided **erroneous crisis helpline numbers**, which can cost lives.

## Schedule

**Verification Frequency**: Quarterly (every 3 months)

**Recommended Timeline**:
- Q1: January
- Q2: April
- Q3: July
- Q4: October

**Time Estimate**: 4-6 hours for full verification

## Verification Standards

### Source Quality Hierarchy

Use authoritative sources in this priority order:

1. **Official government health/crisis services** (highest priority)
2. **Established international NGOs** (IASP, Befrienders Worldwide, WHO)
3. **National crisis line organizations** (official websites)
4. **Regional/local official services**
5. **Academic/research institution compilations**
6. **Vetted aggregator sites** (Find A Helpline, with cross-verification)

### Minimum Requirements

For each resource verification:
- ✅ At least **2 authoritative sources** required (preferably including official website)
- ✅ Check source was updated/reviewed within last 12 months
- ✅ Document source URLs and verification date
- ✅ Verify ALL fields (phone, text, hours, cost, languages)

### Unacceptable Sources

- ❌ Unverified aggregator lists (Wikipedia, Reddit, forums without citations)
- ❌ Sources over 2 years old without current confirmation
- ❌ Single-source information without corroboration
- ❌ AI-generated content without official verification

## Verification Checklist

### Phase 1: International Directories

Check these first as they cover multiple countries:

- [ ] **Find A Helpline** (https://findahelpline.com/i/iasp)
  - [ ] Verify homepage loads
  - [ ] Test location detection feature
  - [ ] Check "About" page for service count/coverage
  - [ ] Note any major changes to coverage
  - [ ] Update statistics in catalogue if changed

- [ ] **Befrienders Worldwide** (https://befrienders.org)
  - [ ] Verify main website loads
  - [ ] Check map feature (https://befrienders.org/map/)
  - [ ] Verify member centres page
  - [ ] Note any new centres or closures
  - [ ] Update statistics if changed

- [ ] **IASP Crisis Centres** (https://www.iasp.info/crisis-centres-helplines/)
  - [ ] Verify page loads and partnership with Find A Helpline
  - [ ] Check for any announcements about service changes

### Phase 2: Priority Regions - Phone Number Verification

For each country/service, verify:

#### United Kingdom
- [ ] **Samaritans** (116 123)
  - [ ] Check https://www.samaritans.org
  - [ ] Verify number on homepage: 116 123
  - [ ] Verify email: jo@samaritans.org
  - [ ] Check "Talk to us" page for any changes
  - [ ] Verify 24/7 availability statement

- [ ] **SHOUT** (85258)
  - [ ] Check https://giveusashout.org
  - [ ] Verify text keyword: SHOUT to 85258
  - [ ] Check for new regional keywords
  - [ ] Verify 24/7 availability
  - [ ] Check partnerships page for NHS updates

- [ ] **NHS 111 Mental Health**
  - [ ] Check https://www.nhs.uk/nhs-services/mental-health-services/where-to-get-urgent-help-for-mental-health/
  - [ ] Verify 111 mental health option exists
  - [ ] Check for any service changes or regional updates

#### United States
- [ ] **988 Suicide & Crisis Lifeline**
  - [ ] Check https://988lifeline.org
  - [ ] Check https://www.samhsa.gov/mental-health/988
  - [ ] Verify number: 988 (call or text)
  - [ ] Verify Spanish option (press 2 / text AYUDA)
  - [ ] Check chat availability
  - [ ] Verify 24/7/365 status

- [ ] **Crisis Text Line** (HOME to 741741)
  - [ ] Check https://www.crisistextline.org
  - [ ] Verify text keywords: HOME, HELLO, HOLA to 741741
  - [ ] Check WhatsApp numbers: 443-SUPPORT, 442-AYUDAME
  - [ ] Verify 24/7 availability

- [ ] **Veterans Crisis Line** (988 press 1)
  - [ ] Check https://www.veteranscrisisline.net
  - [ ] Verify: 988 then press 1
  - [ ] Verify text: 838255
  - [ ] Verify chat link works

- [ ] **Trevor Project** (1-866-488-7386)
  - [ ] Check https://www.thetrevorproject.org/get-help
  - [ ] Verify phone: 1-866-488-7386
  - [ ] Verify text: START to 678678
  - [ ] Check for any service status updates
  - [ ] Note any government partnership changes

#### Canada
- [ ] **988 Suicide Crisis Helpline**
  - [ ] Check Mental Health Commission of Canada website
  - [ ] Verify 988 service operational
  - [ ] Check for language support updates
  - [ ] Verify partner centre count (was 39)

- [ ] **Kids Help Phone** (1-800-668-6868)
  - [ ] Check https://kidshelpphone.ca
  - [ ] Verify phone: 1-800-668-6868
  - [ ] Verify text: CONNECT to 686868
  - [ ] Check language list for updates
  - [ ] Verify Indigenous support keywords

#### Australia
- [ ] **Lifeline** (13 11 14)
  - [ ] Check https://www.lifeline.org.au
  - [ ] Verify phone: 13 11 14
  - [ ] Verify text: 0477 13 11 14
  - [ ] Check chat availability

- [ ] **Beyond Blue** (1300 22 4636)
  - [ ] Check https://www.beyondblue.org.au
  - [ ] Verify phone: 1300 22 4636
  - [ ] Check for program updates
  - [ ] Verify accessibility options

#### New Zealand
- [ ] **1737**
  - [ ] Check https://www.1737.org.nz
  - [ ] Verify number: 1737 or 0800 1737 1737
  - [ ] Check operator information
  - [ ] Note any service scope changes

- [ ] **Lifeline Aotearoa** (0800 543 354)
  - [ ] Check https://www.lifeline.org.nz
  - [ ] Verify phone: 0800 543 354
  - [ ] Verify text: HELP (4357)
  - [ ] Verify suicide crisis helpline: 0508 828 865

#### Ireland
- [ ] **Samaritans Ireland** (116 123)
  - [ ] Check https://www.samaritans.org/samaritans-ireland/
  - [ ] Verify same number as UK: 116 123

- [ ] **Pieta House** (1800 247 247)
  - [ ] Check via HSE listings or Pieta website
  - [ ] Verify phone: 1800 247 247
  - [ ] Verify text: HELP to 51444

- [ ] **Text About It** (50808)
  - [ ] Check textaboutit.ie if available
  - [ ] Verify text: HELLO to 50808
  - [ ] Check HSE funding status

### Phase 3: European Countries

#### Germany - Telefonseelsorge
- [ ] Check https://www.telefonseelsorge.de (if accessible)
- [ ] Verify via gesund.bund.de (German govt)
- [ ] Verify numbers: 0800 111 0 111, 0800 111 0 222, 116 123
- [ ] Check for any service announcements

#### France - 3114
- [ ] Check https://3114.fr
- [ ] Verify national number: 3114
- [ ] Check French government health site for updates
- [ ] Verify 24/7 operation

#### France - SOS Amitié
- [ ] Check for official website
- [ ] Verify phone: 09 72 39 40 50
- [ ] Verify English line: 01 46 21 46 46
- [ ] Check chat hours

#### Netherlands - 113
- [ ] Check https://www.113.nl
- [ ] Verify phone: 113 or 0800-0113
- [ ] Check for service updates
- [ ] Verify daily call volume if reported

#### Spain - Teléfono de la Esperanza
- [ ] Search for official website or government listings
- [ ] Verify primary number: 717 003 717
- [ ] Verify alternative: 914 590 050, 914 590 055
- [ ] Check format consistency

### Phase 4: Asia-Pacific

#### India - AASRA
- [ ] Check https://www.aasra.info
- [ ] Verify phone: +91-22-27546669
- [ ] Verify email: aasrahelpline@yahoo.com
- [ ] Check location information

#### India - Vandrevala Foundation
- [ ] Check https://www.vandrevalafoundation.com
- [ ] Verify phone: 1860-2662-345 or +91-22-2570-6000
- [ ] Verify WhatsApp: +91-9999666555
- [ ] Check service availability statement

#### Japan - TELL
- [ ] Check https://telljp.com
- [ ] Verify phone: 03-5774-0992
- [ ] Verify hours: 9 AM - 11 PM
- [ ] Check chat service hours
- [ ] Verify U.S. Embassy recommendation still current

#### Singapore - SOS
- [ ] Check https://www.sos.org.sg
- [ ] Verify phone: 1767
- [ ] Verify text/WhatsApp: 9151 1767
- [ ] Note any number changes

### Phase 5: Africa and Latin America

#### South Africa - SADAG
- [ ] Check https://www.sadag.org
- [ ] Verify suicide crisis line: 0800 567 567
- [ ] Verify office: 011 234 4837
- [ ] Verify text: 31393
- [ ] Check for service updates

#### Brazil - CVV
- [ ] Check https://cvv.org.br
- [ ] Verify phone: 188
- [ ] Check volunteer count if updated
- [ ] Verify Setembro Amarelo campaign info

### Phase 6: Website Functionality Check

For ALL services with websites listed:

- [ ] Load each website URL in browser
- [ ] Verify page loads (not 404, not taken down)
- [ ] Check SSL certificate valid (https works)
- [ ] Verify contact information visible on homepage/contact page
- [ ] Note if website language changed or domain moved

### Phase 7: New Services Search

Conduct targeted web searches for new services:

- [ ] "crisis helpline [country] 2026" for major countries
- [ ] "suicide prevention hotline [country] official"
- [ ] Check for new government mental health initiatives
- [ ] Search Find A Helpline for newly added countries
- [ ] Review IASP announcements for new member centres

## Web Search Strategies

### Effective Search Patterns

For each country:
- `[country name] mental health crisis helpline official 2026`
- `[country name] suicide prevention hotline government`
- `[country name] crisis support 24/7`
- `[specific service name] official website 2026`

### Official Source Websites to Check

**Government Health Departments:**
- UK: nhs.uk, gov.uk/health
- US: samhsa.gov, mentalhealth.gov
- Canada: canada.ca/health
- Australia: health.gov.au, healthdirect.gov.au
- New Zealand: health.govt.nz

**International Organizations:**
- WHO: who.int (search "mental health")
- IASP: iasp.info
- Befrienders: befrienders.org

**News Sources for Service Changes:**
- "[service name] shut down"
- "[service name] new number"
- "[country] mental health helpline change"
- Check organization social media for announcements

### Cross-Reference Multiple Sources

For each resource, verify with:
1. Official organization website
2. Government health department listing
3. Third-party directory (Find A Helpline, IASP)
4. Recent news articles (within 12 months)

## Documentation Requirements

### For Each Verified Resource

Update `docs/reference/GLOBAL_CRISIS_RESOURCES.md` with:

```markdown
#### Service Name
- **Phone**: [verified number]
- **Text/Chat**: [verified details]
- **Hours**: [verified hours]
- **Cost**: [verified - free/toll/etc]
- **Languages**: [verified languages]
- **Who**: [verified populations served]
- **Description**: [brief description]
- **Source**: [URL of official source]
- **Source**: [URL of second verification source]
- **Verified**: [Month Year of THIS verification]
```

### Changes to Document

For any changes found:

**Format:**
```
OLD: ~~[old information]~~
NEW: [new information]
**Changed**: [Month Year] - [reason/source]
```

**Append to Service Change History section:**
```
- **[Month Year]**: [Country/Service] - [Change Description] - [Source URL]
```

### If Service No Longer Exists

1. Strike through the entry: `~~Service Name~~`
2. Add note: **DISCONTINUED as of [Month Year]** - [Replacement service if any]
3. Keep entry for 6 months, then remove
4. Document in Service Change History
5. Update coverage statistics

### If Number/Details Changed

1. Strike through old: `~~Old: 0800 123 4567~~`
2. Add new with date: `**Current as of Oct 2025**: 0800 765 4321`
3. Note in Service Change History section
4. Verify change with at least 2 sources

## Commit Message Format

After completing verification and making updates:

```
docs: verify crisis resources Q[1-4] 2026 - [summary of changes]

Quarterly verification completed:
- Verified [N] services across [M] countries
- Changes: [list major changes]
- New services: [list any new additions]
- Discontinued: [list any removed services]
- All sources re-verified as of [Month Year]

Next verification due: [Month Year]
```

Example:
```
docs: verify crisis resources Q1 2026 - updated Singapore number

Quarterly verification completed:
- Verified 42 services across 19 countries
- Changes: Singapore SOS changed from 1800-221-4444 to 1767
- New services: Added Malaysia Befrienders KL
- Discontinued: None
- All sources re-verified as of January 2026

Next verification due: April 2026
```

## Error Handling

### If Resource Cannot Be Verified

**Options:**
1. **Recent (within 6 months)**: Keep with note "⚠️ Could not verify [Month Year], last verified [Date]"
2. **Old (6-12 months)**: Flag for removal: "⚠️ UNVERIFIED - scheduled for removal [Date]"
3. **Very old (12+ months)**: Remove and document in Service Change History

**Add to document:**
```
⚠️ **Verification Status**: Could not verify as of [Month Year].
Last confirmed: [Previous Date].
If you have used this service recently, please report: [contact method]
```

### If Official Source Conflicts with Directory

**Resolution Priority:**
1. Official government source (highest)
2. Organization's official website
3. Recent government announcements/press releases
4. Established directory (IASP, Befrienders) if recently updated
5. Aggregator (Find A Helpline) - lowest priority, verify independently

**Document the conflict:**
```
**Note**: Directory lists [X], official source shows [Y].
Using official source [Y] verified [Date] via [URL].
```

### If Website Down or Changed

1. Try archived version: web.archive.org
2. Search for official announcement of move/closure
3. Check organization social media
4. Look for government announcements
5. If moved, update URL; if closed, mark discontinued

## Quality Checks

Before committing changes, verify:

- [ ] All "Verified: [Date]" fields updated to current verification date for checked services
- [ ] All source URLs tested and working
- [ ] "Next Verification Due" date updated in document footer
- [ ] Statistics section updated (if numbers changed)
- [ ] Service Change History section has new entries
- [ ] No broken markdown formatting
- [ ] Spelling and grammar checked
- [ ] Cross-references between sections consistent

## Automation Opportunities

**Potential scripts to develop:**

1. **URL Checker**: Test all URLs return 200 status
   - Input: Extract all URLs from markdown
   - Output: List of broken links

2. **Phone Format Validator**: Check phone number formatting
   - Ensure consistency in international format
   - Flag unusual patterns

3. **Verification Date Checker**: Find resources with old verification dates
   - Parse all "Verified: [Date]" entries
   - Flag resources over 6 months old

4. **Reminder System**: Calendar alerts for quarterly verification
   - Set up calendar reminders 2 weeks before due date
   - Include link to this instruction document

## Template for Verification Session

Copy this checklist at start of each verification:

```
# Crisis Resources Verification - Q[1-4] 202[X]

**Date Started**: [Date]
**Verifier**: [Name]
**Estimated Completion**: [Date]

## Summary Statistics
- Services checked: 0/42
- Changes found: 0
- New services added: 0
- Services removed: 0
- Websites broken: 0

## Changes Log
[List changes as you find them]

## Questions/Issues
[Note anything unclear or needing follow-up]

## Next Steps
[ ] Update GLOBAL_CRISIS_RESOURCES.md
[ ] Update verification dates
[ ] Run quality checks
[ ] Commit with proper message
[ ] Update this template with lessons learned
```

## Resources

**This Document**: `docs/reference/UPDATE_CRISIS_RESOURCES.md`

**Main Catalogue**: `GLOBAL_CRISIS_RESOURCES.md`

**Planning Doc**: `docs/planning/251017d_global_crisis_resources_catalogue.md`

**Research Context**: `docs/conversations/251017a_safeguarding_crisis_resources_research.md`

**Related**: `docs/reference/SAFEGUARDING.md`

---

**Last Updated**: October 17, 2025
**Next Review**: January 2026 (with Q1 verification)
