#!/bin/bash
# ReqNinja Installation & Functionality Test
# This script demonstrates installing and using ReqNinja from scratch

echo "🧪 ReqNinja Installation & Functionality Test"
echo "=============================================="
echo ""

echo "📦 Step 1: Package Information"
echo "Package Name: reqninja"
echo "PyPI URL: https://pypi.org/project/reqninja/"
echo "GitHub: https://github.com/vishal-ravi/reqninja"
echo ""

echo "💾 Step 2: Installation Command"
echo "Command: pip install reqninja"
echo "Alternative: pip install reqninja --upgrade"
echo ""

echo "🖥️ Step 3: CLI Usage Examples"
echo "Basic commands you can try:"
echo ""
echo "  # Check version"
echo "  reqninja --version"
echo ""
echo "  # Simple GET request"
echo "  reqninja http get https://httpbin.org/json"
echo ""
echo "  # POST with JSON data"
echo "  reqninja http post https://httpbin.org/post --json-data '{\"test\": \"data\"}'"
echo ""
echo "  # Show headers only"
echo "  reqninja http get https://httpbin.org/headers --headers-only"
echo ""
echo "  # Save response to file"
echo "  reqninja http get https://httpbin.org/json --save response.json"
echo ""

echo "🐍 Step 4: Python API Examples"
echo "Python code you can run:"
echo ""
echo "  import reqninja"
echo "  "
echo "  # Simple GET request"
echo "  response = reqninja.get('https://httpbin.org/json')"
echo "  print(response.json())"
echo "  "
echo "  # POST with data"
echo "  response = reqninja.post('https://httpbin.org/post', json={'key': 'value'})"
echo "  print(f'Status: {response.status_code}')"
echo "  "
echo "  # Using client class"
echo "  client = reqninja.ReqNinjaClient()"
echo "  response = client.get('https://httpbin.org/json')"
echo ""

echo "✅ Step 5: Verification Checklist"
echo "After installation, verify these work:"
echo "  □ reqninja --version shows version number"
echo "  □ reqninja --help shows usage information"
echo "  □ import reqninja works in Python"
echo "  □ HTTP requests complete successfully"
echo "  □ JSON responses parse correctly"
echo ""

echo "🎯 Quick Test Commands"
echo "Run these to verify everything works:"
echo ""
echo "# Test 1: Version check"
echo "reqninja --version"
echo ""
echo "# Test 2: Simple API call"
echo "reqninja http get https://httpbin.org/json --headers-only"
echo ""
echo "# Test 3: Python import"
echo "python -c \"import reqninja; print('✅ ReqNinja works!')\""
echo ""

echo "🚀 ReqNinja is ready to use!"
echo "For documentation visit: https://github.com/vishal-ravi/reqninja"
