"""Constants for the SolarEdge Monitoring API."""

from datetime import timedelta
import logging
from typing import Final

DOMAIN = "solaredge"

LOGGER = logging.getLogger(__package__)

DATA_API_CLIENT: Final = "api_client"
DATA_MODULES_COORDINATOR: Final = "modules_coordinator"

# Config for solaredge monitoring api requests.
CONF_SITE_ID = "site_id"
CONF_SECTION_API_AUTH = "api_auth"
CONF_SECTION_WEB_AUTH = "web_auth"
DEFAULT_NAME = "SolarEdge"

OVERVIEW_UPDATE_DELAY = timedelta(minutes=15)
DETAILS_UPDATE_DELAY = timedelta(hours=12)
INVENTORY_UPDATE_DELAY = timedelta(hours=12)
POWER_FLOW_UPDATE_DELAY = timedelta(minutes=15)
ENERGY_DETAILS_DELAY = timedelta(minutes=15)
MODULE_STATISTICS_UPDATE_DELAY = timedelta(hours=12)

SCAN_INTERVAL = timedelta(minutes=15)
