"""Public API for the jinpy-utils logger package.

This module exposes the primary logger classes, configuration models, enums,
exceptions, and factory helpers for convenient imports, for example:

    from jinpy_utils.logger import Logger, GlobalLoggerConfig, LogLevel, get_logger
"""

from jinpy_utils.logger.backends import (
    BackendFactory,
    BackendInterface,
    BaseBackend,
    ConsoleBackend,
    FileBackend,
    LogEntry,
    RestApiBackend,
    WebSocketBackend,
)
from jinpy_utils.logger.config import (
    BackendConfig,
    ConsoleBackendConfig,
    DatabaseBackendConfig,
    FileBackendConfig,
    GlobalLoggerConfig,
    LoggerConfig,
    RestApiBackendConfig,
    RetryConfig,
    SecurityConfig,
    WebSocketBackendConfig,
    create_cloud_config,
    create_development_config,
    create_production_config,
)
from jinpy_utils.logger.core import (
    Logger,
    LoggerManager,
    configure_from_env,
    get_logger,
    set_global_config,
    shutdown_all_loggers,
)
from jinpy_utils.logger.enums import (
    BackendType,
    BatchStrategy,
    CompressionType,
    ConnectionState,
    LogFormat,
    LogLevel,
    RetryStrategy,
    SecurityLevel,
)
from jinpy_utils.logger.exceptions import (
    JPYLoggerBackendError,
    JPYLoggerConfigurationError,
    JPYLoggerConnectionError,
    JPYLoggerError,
    JPYLoggerPerformanceError,
    JPYLoggerSecurityError,
    JPYLoggerWebSocketError,
)

__all__: list[str] = [
    "BackendConfig",
    "BackendFactory",
    "BackendInterface",
    "BackendType",
    "BaseBackend",
    "BatchStrategy",
    "CompressionType",
    "ConnectionState",
    "ConsoleBackend",
    "ConsoleBackendConfig",
    "DatabaseBackendConfig",
    "FileBackend",
    "FileBackendConfig",
    "GlobalLoggerConfig",
    "JPYLoggerBackendError",
    "JPYLoggerConfigurationError",
    "JPYLoggerConnectionError",
    "JPYLoggerError",
    "JPYLoggerPerformanceError",
    "JPYLoggerSecurityError",
    "JPYLoggerWebSocketError",
    "LogEntry",
    "LogFormat",
    "LogLevel",
    "Logger",
    "LoggerConfig",
    "LoggerManager",
    "RestApiBackend",
    "RestApiBackendConfig",
    "RetryConfig",
    "RetryStrategy",
    "SecurityConfig",
    "SecurityLevel",
    "WebSocketBackend",
    "WebSocketBackendConfig",
    "configure_from_env",
    "create_cloud_config",
    "create_development_config",
    "create_production_config",
    "get_logger",
    "set_global_config",
    "shutdown_all_loggers",
]
