<a id="mypy-boto3-ivs"></a>

# mypy-boto3-ivs

[![PyPI - mypy-boto3-ivs](https://img.shields.io/pypi/v/mypy-boto3-ivs.svg?color=blue)](https://pypi.org/project/mypy-boto3-ivs)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ivs.svg?color=blue)](https://pypi.org/project/mypy-boto3-ivs)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-ivs?color=blue)](https://pypistats.org/packages/mypy-boto3-ivs)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.IVS 1.18.33](https://boto3.amazonaws.com/v1/documentation/api/1.18.33/reference/services/ivs.html#IVS)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ivs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ivs/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ivs](#mypy-boto3-ivs)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `IVS` service.

```bash
python -m pip install boto3-stubs[ivs]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ivs]` in your environment:
  `python -m pip install 'boto3-stubs[ivs]'`

Both type checking and auto-complete should work for `IVS` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[ivs]` in your environment:
  `python -m pip install 'boto3-stubs[ivs]'`

Both type checking and auto-complete should work for `IVS` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ivs]` in your environment:
  `python -m pip install 'boto3-stubs[ivs]'`
- Run `mypy` as usual

Type checking should work for `IVS` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ivs]` in your environment:
  `python -m pip install 'boto3-stubs[ivs]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `IVS` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`IVSClient` provides annotations for `boto3.client("ivs")`.

```python
import boto3

from mypy_boto3_ivs import IVSClient

client: IVSClient = boto3.client("ivs")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: IVSClient = session.client("ivs")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ivs.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ivs import IVSClient
from mypy_boto3_ivs.paginator import (
    ListChannelsPaginator,
    ListPlaybackKeyPairsPaginator,
    ListRecordingConfigurationsPaginator,
    ListStreamKeysPaginator,
    ListStreamsPaginator,
)

client: IVSClient = boto3.client("ivs")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_channels_paginator: ListChannelsPaginator = client.get_paginator("list_channels")
list_playback_key_pairs_paginator: ListPlaybackKeyPairsPaginator = client.get_paginator("list_playback_key_pairs")
list_recording_configurations_paginator: ListRecordingConfigurationsPaginator = client.get_paginator("list_recording_configurations")
list_stream_keys_paginator: ListStreamKeysPaginator = client.get_paginator("list_stream_keys")
list_streams_paginator: ListStreamsPaginator = client.get_paginator("list_streams")
```

<a id="literals"></a>

### Literals

`mypy_boto3_ivs.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ivs.literals import (
    ChannelLatencyModeType,
    ChannelTypeType,
    ListChannelsPaginatorName,
    ListPlaybackKeyPairsPaginatorName,
    ListRecordingConfigurationsPaginatorName,
    ListStreamKeysPaginatorName,
    ListStreamsPaginatorName,
    RecordingConfigurationStateType,
    StreamHealthType,
    StreamStateType,
)

def check_value(value: ChannelLatencyModeType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ivs.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ivs.type_defs import (
    BatchErrorTypeDef,
    BatchGetChannelRequestRequestTypeDef,
    BatchGetChannelResponseTypeDef,
    BatchGetStreamKeyRequestRequestTypeDef,
    BatchGetStreamKeyResponseTypeDef,
    ChannelSummaryTypeDef,
    ChannelTypeDef,
    CreateChannelRequestRequestTypeDef,
    CreateChannelResponseTypeDef,
    CreateRecordingConfigurationRequestRequestTypeDef,
    CreateRecordingConfigurationResponseTypeDef,
    CreateStreamKeyRequestRequestTypeDef,
    CreateStreamKeyResponseTypeDef,
    DeleteChannelRequestRequestTypeDef,
    DeletePlaybackKeyPairRequestRequestTypeDef,
    DeleteRecordingConfigurationRequestRequestTypeDef,
    DeleteStreamKeyRequestRequestTypeDef,
    DestinationConfigurationTypeDef,
    GetChannelRequestRequestTypeDef,
    GetChannelResponseTypeDef,
    GetPlaybackKeyPairRequestRequestTypeDef,
    GetPlaybackKeyPairResponseTypeDef,
    GetRecordingConfigurationRequestRequestTypeDef,
    GetRecordingConfigurationResponseTypeDef,
    GetStreamKeyRequestRequestTypeDef,
    GetStreamKeyResponseTypeDef,
    GetStreamRequestRequestTypeDef,
    GetStreamResponseTypeDef,
    ImportPlaybackKeyPairRequestRequestTypeDef,
    ImportPlaybackKeyPairResponseTypeDef,
    ListChannelsRequestRequestTypeDef,
    ListChannelsResponseTypeDef,
    ListPlaybackKeyPairsRequestRequestTypeDef,
    ListPlaybackKeyPairsResponseTypeDef,
    ListRecordingConfigurationsRequestRequestTypeDef,
    ListRecordingConfigurationsResponseTypeDef,
    ListStreamKeysRequestRequestTypeDef,
    ListStreamKeysResponseTypeDef,
    ListStreamsRequestRequestTypeDef,
    ListStreamsResponseTypeDef,
    ListTagsForResourceRequestRequestTypeDef,
    ListTagsForResourceResponseTypeDef,
    PaginatorConfigTypeDef,
    PlaybackKeyPairSummaryTypeDef,
    PlaybackKeyPairTypeDef,
    PutMetadataRequestRequestTypeDef,
    RecordingConfigurationSummaryTypeDef,
    RecordingConfigurationTypeDef,
    ResponseMetadataTypeDef,
    S3DestinationConfigurationTypeDef,
    StopStreamRequestRequestTypeDef,
    StreamKeySummaryTypeDef,
    StreamKeyTypeDef,
    StreamSummaryTypeDef,
    StreamTypeDef,
    TagResourceRequestRequestTypeDef,
    UntagResourceRequestRequestTypeDef,
    UpdateChannelRequestRequestTypeDef,
    UpdateChannelResponseTypeDef,
)

def get_structure() -> BatchErrorTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-ivs` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-ivs docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ivs/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
