#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys

import bootstrap3

try:
    from setuptools import setup
except ImportError:
    from distutils.core import setup

version = bootstrap3.__version__

if sys.argv[-1] == 'publish':
    os.system('cd docs && make html')
    os.system('python setup.py sdist upload')
    print("You probably want to also tag the version now:")
    print("  git tag -a %s -m 'version %s'" % (version, version))
    print("  git push --tags")
    sys.exit()

readme = open('README.rst').read()
history = open('HISTORY.rst').read().replace('.. :changelog:', '')

setup(
    name='django-bootstrap3',
    version=version,
    description="""Bootstrap support for Django projects""",
    long_description=readme + '\n\n' + history,
    author='Dylan Verheul',
    author_email='dylan@dyve.net',
    url='https://github.com/dyve/django-bootstrap3',
    packages=[
        'bootstrap3',
    ],
    include_package_data=True,
    install_requires=[
    ],
    license="Apache License 2.0",
    zip_safe=False,
    keywords='django-bootstrap3',
    classifiers=[
        'Development Status :: 4 - Beta',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.3',
        'Operating System :: OS Independent',
        'Topic :: Software Development :: Libraries',
        'Topic :: Utilities',
        'Environment :: Web Environment',
        'Framework :: Django',
    ],
)
