#pragma once

#include <vector>
#include <cmath>
#include "load_inst.hpp"

namespace htminer {
    void Build_MDD(std::vector<int>& items, std::vector<int>& items_lim);

    class Arc {
    public:
        unsigned int chld;    
        unsigned int sibl;
        unsigned int freq;        
        unsigned int anct;
        int itmset;
        int item;

        Arc(unsigned int _itm, int _itmset, unsigned int _anc) {
            chld = 0;    
            sibl = 0;
            freq = 0;
            itmset = _itmset;
            anct = _anc;
            item = _itm;
        }

        Arc() {
            chld = 0;    
            sibl = 0;
            freq = 0;
        }
    };

    class VArc {
    public:
        unsigned int sibl;    
        std::vector<int> seq;

        VArc(std::vector<int>& items, unsigned int _sib) {
            sibl = _sib;
            seq.swap(items);
        }
        
        VArc() {
            sibl = 0;
        }
    };

    class CArc {
    public:
        std::vector<int> seq;
        std::vector<unsigned int> ancest;

        CArc(std::vector<unsigned int>& _anc, std::vector<int>& items) {
            ancest.swap(_anc);
            seq.swap(items);
        }
    };

    extern std::vector<Arc> Tree;
    extern std::vector<VArc> VTree;
    extern std::vector<CArc> CTree;
}
