# Generated by Django 4.2.23 on 2025-07-29 17:30

from django.db import migrations, models
import django.db.models.deletion
import pretix.base.models.base


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('pretixbase', '0184_customer'),
    ]

    operations = [
        migrations.CreateModel(
            name='Wallet',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('pan', models.CharField(max_length=19)),
                ('currency', models.CharField(max_length=10)),
                ('customer', models.OneToOneField(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='wallet', to='pretixbase.customer')),
                ('issuer', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='wallets', to='pretixbase.organizer')),
                ('order_position', models.OneToOneField(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='wallet', to='pretixbase.orderposition')),
            ],
            options={
                'abstract': False,
            },
            bases=(models.Model, pretix.base.models.base.LoggingMixin),
        ),
        migrations.CreateModel(
            name='WalletTransaction',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('value', models.DecimalField(decimal_places=2, max_digits=13)),
                ('descriptor', models.TextField(default='')),
                ('data', models.JSONField(default=dict)),
                ('order_payment', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='wallet_transactions', to='pretixbase.orderpayment')),
                ('order_position', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='wallet_transactions', to='pretixbase.orderposition')),
                ('order_refund', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='wallet_transactions', to='pretixbase.orderrefund')),
                ('wallet', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='transactions', to='pretix_wallet.wallet')),
            ],
        ),
        migrations.CreateModel(
            name='WalletItem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ('issue_wallet_balance', models.BooleanField(default=False)),
                ('item', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='wallet', to='pretixbase.item')),
            ],
        ),
    ]
