# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['AddonArgs', 'Addon']

@pulumi.input_type
class AddonArgs:
    def __init__(__self__, *,
                 src: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Addon resource.
        :param pulumi.Input[_builtins.str] src: The source URL to display in a frame in the PagerDuty UI. `HTTPS` is required.
        :param pulumi.Input[_builtins.str] name: The name of the add-on.
        """
        pulumi.set(__self__, "src", src)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def src(self) -> pulumi.Input[_builtins.str]:
        """
        The source URL to display in a frame in the PagerDuty UI. `HTTPS` is required.
        """
        return pulumi.get(self, "src")

    @src.setter
    def src(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "src", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the add-on.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _AddonState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 src: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Addon resources.
        :param pulumi.Input[_builtins.str] name: The name of the add-on.
        :param pulumi.Input[_builtins.str] src: The source URL to display in a frame in the PagerDuty UI. `HTTPS` is required.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if src is not None:
            pulumi.set(__self__, "src", src)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the add-on.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def src(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source URL to display in a frame in the PagerDuty UI. `HTTPS` is required.
        """
        return pulumi.get(self, "src")

    @src.setter
    def src(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "src", value)


@pulumi.type_token("pagerduty:index/addon:Addon")
class Addon(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 src: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        With [add-ons](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODEwNQ-install-an-add-on), third-party developers can write their own add-ons to PagerDuty's UI. Given a configuration containing a src parameter, that URL will be embedded in an iframe on a page that's available to users from a drop-down menu.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.Addon("example",
            name="Internal Status Page",
            src="https://intranet.example.com/status")
        ```

        ## Import

        Add-ons can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/addon:Addon example P3DH5M6
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the add-on.
        :param pulumi.Input[_builtins.str] src: The source URL to display in a frame in the PagerDuty UI. `HTTPS` is required.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AddonArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With [add-ons](https://developer.pagerduty.com/api-reference/b3A6Mjc0ODEwNQ-install-an-add-on), third-party developers can write their own add-ons to PagerDuty's UI. Given a configuration containing a src parameter, that URL will be embedded in an iframe on a page that's available to users from a drop-down menu.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_pagerduty as pagerduty

        example = pagerduty.Addon("example",
            name="Internal Status Page",
            src="https://intranet.example.com/status")
        ```

        ## Import

        Add-ons can be imported using the `id`, e.g.

        ```sh
        $ pulumi import pagerduty:index/addon:Addon example P3DH5M6
        ```

        :param str resource_name: The name of the resource.
        :param AddonArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AddonArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 src: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AddonArgs.__new__(AddonArgs)

            __props__.__dict__["name"] = name
            if src is None and not opts.urn:
                raise TypeError("Missing required property 'src'")
            __props__.__dict__["src"] = src
        super(Addon, __self__).__init__(
            'pagerduty:index/addon:Addon',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            src: Optional[pulumi.Input[_builtins.str]] = None) -> 'Addon':
        """
        Get an existing Addon resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] name: The name of the add-on.
        :param pulumi.Input[_builtins.str] src: The source URL to display in a frame in the PagerDuty UI. `HTTPS` is required.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AddonState.__new__(_AddonState)

        __props__.__dict__["name"] = name
        __props__.__dict__["src"] = src
        return Addon(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the add-on.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def src(self) -> pulumi.Output[_builtins.str]:
        """
        The source URL to display in a frame in the PagerDuty UI. `HTTPS` is required.
        """
        return pulumi.get(self, "src")

