DATASET_SIZES = {
    "XS": 10_000_000,
    "S": 25_000_000,
    "M": 50_000_000,
    "L": 100_000_000,
}

# Per-packet information (PPI) constants
PPI_MAX_LEN = 30
IPT_POS = 0
DIR_POS = 1
SIZE_POS = 2
PUSH_FLAGS_POS = 3
TCP_PPI_CHANNELS = [IPT_POS, DIR_POS, SIZE_POS, PUSH_FLAGS_POS]
UDP_PPI_CHANNELS = [IPT_POS, DIR_POS, SIZE_POS]

# Features
FLOWSTATS_TO_SCALE =  ["BYTES", "BYTES_REV", "PACKETS", "PACKETS_REV", "PPI_LEN", "PPI_ROUNDTRIPS", "PPI_DURATION", "DURATION"]
FLOWSTATS_NO_CLIP = ["DURATION", "PPI_LEN", "PPI_ROUNDTRIPS", "PPI_DURATION"]
SELECTED_TCP_FLAGS = ["FLAG_CWR", "FLAG_CWR_REV", "FLAG_ECE", "FLAG_ECE_REV", "FLAG_PSH_REV", "FLAG_RST", "FLAG_RST_REV", "FLAG_FIN", "FLAG_FIN_REV"]
PHIST_BIN_COUNT = 8

# Column names
ID_COLUMN = "ID"
APP_COLUMN = "APP"
CATEGORY_COLUMN = "CATEGORY"
PPI_COLUMN = "PPI"
TLS_SNI_COLUMN = "TLS_SNI"
QUIC_SNI_COLUMN = "QUIC_SNI"

# Servicemap constants
SERVICEMAP_PROVIDER_COLUMN = "Service Provider"
SERVICEMAP_CATEGORY_COLUMN = "Service Category"
SERVICEMAP_FILE = "servicemap.csv"

# Class labels
UNKNOWN_STR_LABEL = "_unknown"
DEFAULT_BACKGROUND_CLASS = "default-background"
GOOGLE_BACKGROUND_CLASS = "google-background"

# Indices
INDICES_TABLE_FIELD = "TABLE"
INDICES_INDEX_FIELD = "INDEX"
INDICES_APP_FIELD = "APP"
INDICES_SNI_FIELD = "SNI"
INDICES_DTYPE = [(INDICES_TABLE_FIELD, "int32"), (INDICES_INDEX_FIELD, "int32"), (INDICES_APP_FIELD, "int32"), (INDICES_SNI_FIELD, "U50")]
