# Generated by Django 5.0.12 on 2025-02-24 13:45
from collections import defaultdict

from django.core.exceptions import ValidationError
from django.core.validators import URLValidator
from django.db import migrations, models
from tqdm import tqdm


def migrate_identifier( apps, schema_editor):
    from wbnews.models.news import News as NewsClass
    News = apps.get_model('wbnews', 'News')
    objs = []
    qs = News.objects.all()
    guid = set()
    for new in tqdm(qs, total=qs.count()):
        new.guid = NewsClass.get_default_guid(new.title, new.link)
        if new.guid not in guid:
            guid.add(new.guid)
            objs.append(new)
    print(len(objs))
    News.objects.bulk_update(objs, ['guid'], batch_size=10000)

    leftovers = News.objects.filter(guid__isnull=True)
    print(leftovers.count())
    leftovers.delete()

    qs = News.objects.all()
    for new in tqdm(qs, total=qs.count()):
        try:
            URLValidator()(new.link)
        except ValidationError:
            new.link = None
            objs.append(new)

    News.objects.bulk_update(objs, ['link'], batch_size=10000)

class Migration(migrations.Migration):

    dependencies = [
        ('io', '0008_importsource_resource_kwargs'),
        ('wbnews', '0011_newsrelationship_content_object_repr'),
    ]

    operations = [
        migrations.AlterUniqueTogether(
            name='news',
            unique_together=set(),
        ),
        migrations.AddField(
            model_name='news',
            name='guid',
            field=models.CharField(default=None, blank=True, null=True, max_length=1024),
            preserve_default=False,
        ),
         migrations.RunSQL(sql="SET CONSTRAINTS ALL IMMEDIATE;"),
        migrations.RunPython(migrate_identifier),
        migrations.RunSQL(sql="SET CONSTRAINTS ALL DEFERRED;"),
        migrations.AlterField(
            model_name='news',
            name='guid',
            field=models.CharField(max_length=1024, unique=True),
        ),
        migrations.AlterField(
            model_name='news',
            name='link',
            field=models.URLField(max_length=1024, blank=True, null=True, verbose_name='Link'),
        ),
        migrations.AddField(
            model_name='news',
            name='mark_as_duplicate',
            field=models.BooleanField(default=False, verbose_name='Mark as duplicate'),
        ),
        migrations.AlterField(
            model_name='newsrelationship',
            name='sentiment',
            field=models.PositiveIntegerField(blank=True, choices=[(4, 'Positive'), (3, 'Slightly Positive'),
                                                                   (2, 'Slightly Negative'), (1, 'Negative')],
                                              null=True),
        ),
        migrations.RenameField(
            model_name='newssource',
            old_name='url',
            new_name='endpoint',
        ),
        migrations.AlterField(
            model_name='newssource',
            name='endpoint',
            field=models.CharField(max_length=1024, unique=True),
        ),
    ]
