@echo off
REM clj-kondo Installer for Windows
REM Version: 2024.11.14 (Updated: 2025-01-20)

echo Installing clj-kondo...

REM Create install directory
set INSTALL_DIR=%ProgramFiles%\clj-kondo
if not exist "%INSTALL_DIR%" mkdir "%INSTALL_DIR%"

REM Download clj-kondo Windows binary
echo Downloading clj-kondo 2024.11.14...
powershell -Command "& {Invoke-WebRequest -Uri 'https://github.com/clj-kondo/clj-kondo/releases/download/v2024.11.14/clj-kondo-2024.11.14-windows-amd64.zip' -OutFile '%TEMP%\clj-kondo.zip'}"

if %ERRORLEVEL% NEQ 0 (
    echo ERROR: Failed to download clj-kondo
    exit /b 1
)

REM Extract the zip file
echo Extracting clj-kondo...
powershell -Command "& {Expand-Archive -Path '%TEMP%\clj-kondo.zip' -DestinationPath '%INSTALL_DIR%' -Force}"

if %ERRORLEVEL% NEQ 0 (
    echo ERROR: Failed to extract clj-kondo
    del "%TEMP%\clj-kondo.zip"
    exit /b 1
)

REM Clean up
del "%TEMP%\clj-kondo.zip"

REM Add to PATH (user level, no UAC)
echo Adding clj-kondo to PATH...
powershell -Command "& {$oldPath = [Environment]::GetEnvironmentVariable('Path', 'User'); if ($oldPath -notlike '*%INSTALL_DIR%*') { [Environment]::SetEnvironmentVariable('Path', $oldPath + ';%INSTALL_DIR%', 'User') }}"

echo.
echo clj-kondo installed successfully!
echo.
echo You may need to restart your terminal for PATH changes to take effect.
echo Test with: clj-kondo --version
