# coding: utf-8

"""
    Akeyless API

    The purpose of this application is to provide access to Akeyless API.  # noqa: E501

    The version of the OpenAPI document: 3.0
    Contact: support@akeyless.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from akeyless.configuration import Configuration


class DeriveKey(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'accessibility': 'str',
        'alg': 'str',
        'hash_function': 'str',
        'iter': 'int',
        'json': 'bool',
        'key_len': 'int',
        'mem': 'int',
        'name': 'str',
        'parallelism': 'int',
        'salt': 'str',
        'token': 'str',
        'uid_token': 'str'
    }

    attribute_map = {
        'accessibility': 'accessibility',
        'alg': 'alg',
        'hash_function': 'hash-function',
        'iter': 'iter',
        'json': 'json',
        'key_len': 'key-len',
        'mem': 'mem',
        'name': 'name',
        'parallelism': 'parallelism',
        'salt': 'salt',
        'token': 'token',
        'uid_token': 'uid-token'
    }

    def __init__(self, accessibility='regular', alg='pbkdf2', hash_function='sha256', iter=None, json=False, key_len=None, mem=16384, name=None, parallelism=1, salt=None, token=None, uid_token=None, local_vars_configuration=None):  # noqa: E501
        """DeriveKey - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._accessibility = None
        self._alg = None
        self._hash_function = None
        self._iter = None
        self._json = None
        self._key_len = None
        self._mem = None
        self._name = None
        self._parallelism = None
        self._salt = None
        self._token = None
        self._uid_token = None
        self.discriminator = None

        if accessibility is not None:
            self.accessibility = accessibility
        self.alg = alg
        if hash_function is not None:
            self.hash_function = hash_function
        self.iter = iter
        if json is not None:
            self.json = json
        self.key_len = key_len
        if mem is not None:
            self.mem = mem
        self.name = name
        if parallelism is not None:
            self.parallelism = parallelism
        if salt is not None:
            self.salt = salt
        if token is not None:
            self.token = token
        if uid_token is not None:
            self.uid_token = uid_token

    @property
    def accessibility(self):
        """Gets the accessibility of this DeriveKey.  # noqa: E501

        for personal password manager  # noqa: E501

        :return: The accessibility of this DeriveKey.  # noqa: E501
        :rtype: str
        """
        return self._accessibility

    @accessibility.setter
    def accessibility(self, accessibility):
        """Sets the accessibility of this DeriveKey.

        for personal password manager  # noqa: E501

        :param accessibility: The accessibility of this DeriveKey.  # noqa: E501
        :type: str
        """

        self._accessibility = accessibility

    @property
    def alg(self):
        """Gets the alg of this DeriveKey.  # noqa: E501

        Kdf algorithm  # noqa: E501

        :return: The alg of this DeriveKey.  # noqa: E501
        :rtype: str
        """
        return self._alg

    @alg.setter
    def alg(self, alg):
        """Sets the alg of this DeriveKey.

        Kdf algorithm  # noqa: E501

        :param alg: The alg of this DeriveKey.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and alg is None:  # noqa: E501
            raise ValueError("Invalid value for `alg`, must not be `None`")  # noqa: E501

        self._alg = alg

    @property
    def hash_function(self):
        """Gets the hash_function of this DeriveKey.  # noqa: E501

        HashFunction the hash function to use (relevant for pbkdf2)  # noqa: E501

        :return: The hash_function of this DeriveKey.  # noqa: E501
        :rtype: str
        """
        return self._hash_function

    @hash_function.setter
    def hash_function(self, hash_function):
        """Sets the hash_function of this DeriveKey.

        HashFunction the hash function to use (relevant for pbkdf2)  # noqa: E501

        :param hash_function: The hash_function of this DeriveKey.  # noqa: E501
        :type: str
        """

        self._hash_function = hash_function

    @property
    def iter(self):
        """Gets the iter of this DeriveKey.  # noqa: E501

        IterationCount the number of iterations  # noqa: E501

        :return: The iter of this DeriveKey.  # noqa: E501
        :rtype: int
        """
        return self._iter

    @iter.setter
    def iter(self, iter):
        """Sets the iter of this DeriveKey.

        IterationCount the number of iterations  # noqa: E501

        :param iter: The iter of this DeriveKey.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and iter is None:  # noqa: E501
            raise ValueError("Invalid value for `iter`, must not be `None`")  # noqa: E501

        self._iter = iter

    @property
    def json(self):
        """Gets the json of this DeriveKey.  # noqa: E501

        Set output format to JSON  # noqa: E501

        :return: The json of this DeriveKey.  # noqa: E501
        :rtype: bool
        """
        return self._json

    @json.setter
    def json(self, json):
        """Sets the json of this DeriveKey.

        Set output format to JSON  # noqa: E501

        :param json: The json of this DeriveKey.  # noqa: E501
        :type: bool
        """

        self._json = json

    @property
    def key_len(self):
        """Gets the key_len of this DeriveKey.  # noqa: E501

        KeyLength the byte length of the generated key  # noqa: E501

        :return: The key_len of this DeriveKey.  # noqa: E501
        :rtype: int
        """
        return self._key_len

    @key_len.setter
    def key_len(self, key_len):
        """Sets the key_len of this DeriveKey.

        KeyLength the byte length of the generated key  # noqa: E501

        :param key_len: The key_len of this DeriveKey.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and key_len is None:  # noqa: E501
            raise ValueError("Invalid value for `key_len`, must not be `None`")  # noqa: E501

        self._key_len = key_len

    @property
    def mem(self):
        """Gets the mem of this DeriveKey.  # noqa: E501

        MemorySizeInKb the memory paramter in kb (relevant for argon2id)  # noqa: E501

        :return: The mem of this DeriveKey.  # noqa: E501
        :rtype: int
        """
        return self._mem

    @mem.setter
    def mem(self, mem):
        """Sets the mem of this DeriveKey.

        MemorySizeInKb the memory paramter in kb (relevant for argon2id)  # noqa: E501

        :param mem: The mem of this DeriveKey.  # noqa: E501
        :type: int
        """

        self._mem = mem

    @property
    def name(self):
        """Gets the name of this DeriveKey.  # noqa: E501

        Static Secret full name  # noqa: E501

        :return: The name of this DeriveKey.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DeriveKey.

        Static Secret full name  # noqa: E501

        :param name: The name of this DeriveKey.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def parallelism(self):
        """Gets the parallelism of this DeriveKey.  # noqa: E501

        Parallelism the number of threads to use (relevant for argon2id)  # noqa: E501

        :return: The parallelism of this DeriveKey.  # noqa: E501
        :rtype: int
        """
        return self._parallelism

    @parallelism.setter
    def parallelism(self, parallelism):
        """Sets the parallelism of this DeriveKey.

        Parallelism the number of threads to use (relevant for argon2id)  # noqa: E501

        :param parallelism: The parallelism of this DeriveKey.  # noqa: E501
        :type: int
        """

        self._parallelism = parallelism

    @property
    def salt(self):
        """Gets the salt of this DeriveKey.  # noqa: E501

        Salt Base64 encoded salt value. If not provided, the salt will be generated as part of the operation. The salt should be securely-generated random bytes, minimum 64 bits, 128 bits is recommended  # noqa: E501

        :return: The salt of this DeriveKey.  # noqa: E501
        :rtype: str
        """
        return self._salt

    @salt.setter
    def salt(self, salt):
        """Sets the salt of this DeriveKey.

        Salt Base64 encoded salt value. If not provided, the salt will be generated as part of the operation. The salt should be securely-generated random bytes, minimum 64 bits, 128 bits is recommended  # noqa: E501

        :param salt: The salt of this DeriveKey.  # noqa: E501
        :type: str
        """

        self._salt = salt

    @property
    def token(self):
        """Gets the token of this DeriveKey.  # noqa: E501

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :return: The token of this DeriveKey.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this DeriveKey.

        Authentication token (see `/auth` and `/configure`)  # noqa: E501

        :param token: The token of this DeriveKey.  # noqa: E501
        :type: str
        """

        self._token = token

    @property
    def uid_token(self):
        """Gets the uid_token of this DeriveKey.  # noqa: E501

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :return: The uid_token of this DeriveKey.  # noqa: E501
        :rtype: str
        """
        return self._uid_token

    @uid_token.setter
    def uid_token(self, uid_token):
        """Sets the uid_token of this DeriveKey.

        The universal identity token, Required only for universal_identity authentication  # noqa: E501

        :param uid_token: The uid_token of this DeriveKey.  # noqa: E501
        :type: str
        """

        self._uid_token = uid_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeriveKey):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DeriveKey):
            return True

        return self.to_dict() != other.to_dict()
